/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.GrayFilter;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

class GrayFilterConfig
extends AnAction
implements DumbAware {
    private static final String BRIGHTNESS = "brightness";
    private static final String CONTRAST = "contrast";
    private static final String ALPHA = "alpha";
    private final Object[][] data = new Object[3][2];
    private boolean lafListenerAdded;

    GrayFilterConfig() {
    }

    private void setData() {
        this.data[0][0] = BRIGHTNESS;
        this.data[1][0] = CONTRAST;
        this.data[2][0] = ALPHA;
        this.data[0][1] = String.valueOf(this.getGrayFilterProperty(BRIGHTNESS));
        this.data[1][1] = String.valueOf(this.getGrayFilterProperty(CONTRAST));
        this.data[2][1] = String.valueOf(this.getGrayFilterProperty(ALPHA));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GrayFilterConfig.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Window activeFrame;
        if (e == null) {
            GrayFilterConfig.$$$reportNull$$$0(1);
        }
        if ((activeFrame = IdeFrameImpl.getActiveFrame()) == null) {
            return;
        }
        this.setData();
        if (!this.lafListenerAdded) {
            this.lafListenerAdded = true;
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(LafManagerListener.TOPIC, source -> this.setData());
        }
        final JTable table = new JTable(this.data, new String[]{"Property", "Value"}){

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                return (table1, value, isSelected, hasFocus, row1, column1) -> {
                    JLabel label = new JLabel((String)GrayFilterConfig.this.data[row][column]);
                    label.setOpaque(true);
                    label.setBackground(JBColor.border());
                    label.setBorder((Border)JBUI.Borders.emptyLeft((int)((int)Math.ceil(UISettings.getDefFontSize()))));
                    return label;
                };
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }
        };
        table.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)new AbstractTableCellEditor(){
            final JTextField component = new JTextField();

            public Object getCellEditorValue() {
                return this.component.getText();
            }

            public Component getTableCellEditorComponent(JTable table1, Object value, boolean isSelected, int row, int column) {
                this.component.setText((String)GrayFilterConfig.this.data[row][column]);
                return this.component;
            }
        });
        table.getColumnModel().getColumn(1).getCellEditor().addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                String prop = (String)GrayFilterConfig.this.data[table.getSelectedRow()][0];
                try {
                    int value = Integer.parseInt((String)((TableCellEditor)e.getSource()).getCellEditorValue());
                    GrayFilterConfig.this.setGrayFilterProperty(prop, value);
                    GrayFilterConfig.this.data[table.getSelectedRow()][1] = String.valueOf(GrayFilterConfig.this.getGrayFilterProperty(prop));
                    IconLoader.clearCache();
                    GrayFilterConfig.updateUI(SwingUtilities.getWindowAncestor(table));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        table.setColumnSelectionAllowed(true);
        table.setTableHeader(null);
        for (int c = 0; c < table.getColumnCount(); ++c) {
            table.getColumnModel().getColumn(c).setPreferredWidth(JBUIScale.scale((int)100));
        }
        for (int r = 0; r < table.getRowCount(); ++r) {
            table.setRowHeight(r, (int)Math.ceil(UISettings.getDefFontSize() * 2.0f));
        }
        final JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)table, "Center");
        DialogWrapper dlg = new DialogWrapper(this, false){
            {
                super(arg0);
                this.init();
            }

            protected JComponent createCenterPanel() {
                return tablePanel;
            }
        };
        dlg.setModal(false);
        dlg.setTitle("GrayFilter");
        dlg.setResizable(false);
        dlg.show();
    }

    private int getGrayFilterProperty(String prop) {
        GrayFilter filter = this.getGrayFilter();
        if (BRIGHTNESS.equals(prop)) {
            return filter.getBrightness();
        }
        if (CONTRAST.equals(prop)) {
            return filter.getContrast();
        }
        if (ALPHA.equals(prop)) {
            return filter.getAlpha();
        }
        throw new IllegalArgumentException("wrong property: " + prop);
    }

    protected GrayFilter getGrayFilter() {
        return (GrayFilter)UIUtil.getGrayFilter();
    }

    private void setGrayFilterProperty(String prop, int value) {
        GrayFilter filter = this.getGrayFilter();
        int brightness = filter.getBrightness();
        int contrast = filter.getContrast();
        int alpha = filter.getAlpha();
        if (BRIGHTNESS.equals(prop)) {
            brightness = value;
        } else if (CONTRAST.equals(prop)) {
            contrast = value;
        } else if (ALPHA.equals(prop)) {
            alpha = value;
        } else {
            return;
        }
        String key = this.getGrayFilterKey();
        UIManager.getDefaults().remove(key);
        UIManager.getDefaults().put(key, new GrayFilter(brightness, contrast, alpha));
    }

    protected String getGrayFilterKey() {
        return "grayFilter";
    }

    private static void updateUI(Window exclude) {
        for (Window w : Window.getWindows()) {
            if (w == exclude) continue;
            IJSwingUtilities.updateComponentTreeUI((Component)w);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/GrayFilterConfig";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/GrayFilterConfig";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

