/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.ExcludeUrlEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.SourceRootEntity;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/internal/PrintModulesAndEntitySources;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.ide.internal"})
@SourceDebugExtension(value={"SMAP\nPrintModulesAndEntitySources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrintModulesAndEntitySources.kt\ncom/intellij/internal/PrintModulesAndEntitySources\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n23#2:37\n23#2:46\n1321#3:38\n1322#3:45\n1869#4:39\n1869#4,2:40\n1869#4,2:42\n1870#4:44\n*S KotlinDebug\n*F\n+ 1 PrintModulesAndEntitySources.kt\ncom/intellij/internal/PrintModulesAndEntitySources\n*L\n14#1:37\n34#1:46\n21#1:38\n21#1:45\n23#1:39\n25#1:40,2\n28#1:42,2\n23#1:44\n*E\n"})
public final class PrintModulesAndEntitySources
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            PrintModulesAndEntitySources $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PrintModulesAndEntitySources.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Project is null, can't print modules");
            return;
        }
        StringBuilder builder = new StringBuilder();
        ImmutableEntityStorage snap = WorkspaceModelKt.getWorkspaceModel((Project)project).getCurrentSnapshot();
        Sequence $this$forEach$iv = snap.entities(ModuleEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleEntity module = (ModuleEntity)element$iv;
            boolean bl = false;
            builder.append("Module: " + module.getName() + ", source: " + module.getEntitySource()).append('\n');
            Iterable $this$forEach$iv2 = module.getContentRoots();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ContentRootEntity contentRootEntity = (ContentRootEntity)element$iv2;
                boolean bl2 = false;
                builder.append(" - ContentRoot: " + contentRootEntity.getUrl() + ", source: " + contentRootEntity.getEntitySource()).append('\n');
                Iterable $this$forEach$iv3 = contentRootEntity.getSourceRoots();
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    SourceRootEntity sourceRootEntity = (SourceRootEntity)element$iv3;
                    boolean bl3 = false;
                    builder.append("   - SourceRoot: " + sourceRootEntity.getUrl() + ", source: " + sourceRootEntity.getEntitySource()).append('\n');
                }
                $this$forEach$iv3 = contentRootEntity.getExcludedUrls();
                $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    ExcludeUrlEntity exclude = (ExcludeUrlEntity)element$iv3;
                    boolean bl4 = false;
                    builder.append("   - ExcludeRoot: " + exclude.getUrl() + ", source: " + exclude.getEntitySource()).append('\n');
                }
            }
        }
        PrintModulesAndEntitySources $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(PrintModulesAndEntitySources.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("\n" + builder);
    }
}

