/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.indexing.IndexingBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ToggleDumbModeAction
extends DumbAwareAction {
    private static final Key<Boolean> DUMB = Key.create((String)"ToggleDumbModeAction");

    ToggleDumbModeAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ToggleDumbModeAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        if (ToggleDumbModeAction.isToggledDumb(project)) {
            ToggleDumbModeAction.setToggledDumb(project, false);
        } else {
            ToggleDumbModeAction.setToggledDumb(project, true);
            new MyDumbModeTask(project).queue(project);
        }
    }

    private static void setToggledDumb(Project project, boolean value) {
        project.putUserData(DUMB, (Object)value);
    }

    private static boolean isToggledDumb(Project project) {
        return project.getUserData(DUMB) == Boolean.TRUE;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ToggleDumbModeAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ToggleDumbModeAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        boolean dumb = DumbService.getInstance((Project)project).isDumb();
        if (!dumb && ToggleDumbModeAction.isToggledDumb(project)) {
            ToggleDumbModeAction.setToggledDumb(project, false);
        }
        e.getPresentation().setEnabled(!dumb || ToggleDumbModeAction.isToggledDumb(project));
        e.getPresentation().setText(dumb ? "Exit Dumb Mode" : "Enter Dumb Mode");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/ToggleDumbModeAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/ToggleDumbModeAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class MyDumbModeTask
    extends DumbModeTask {
        private final Project myProject;

        private MyDumbModeTask(Project project) {
            this.myProject = project;
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyDumbModeTask.$$$reportNull$$$0(0);
            }
            indicator.setIndeterminate(true);
            indicator.setText(IndexingBundle.message((String)"toggled.dumb.mode", (Object[])new Object[0]));
            while (ToggleDumbModeAction.isToggledDumb(this.myProject)) {
                indicator.checkCanceled();
                TimeoutUtil.sleep((long)100L);
            }
        }

        @Nullable
        public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
            if (taskFromQueue == null) {
                MyDumbModeTask.$$$reportNull$$$0(1);
            }
            if (taskFromQueue instanceof MyDumbModeTask && ((MyDumbModeTask)taskFromQueue).myProject.equals((Object)this.myProject)) {
                return this;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskFromQueue";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/ToggleDumbModeAction$MyDumbModeTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performInDumbMode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryMergeWith";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

