/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.focus;

import com.intellij.internal.InternalActionsBundle;
import com.intellij.internal.focus.FocusTracesDialog;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.openapi.wm.impl.FocusRequestInfo;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class FocusTracesAction
extends AnAction
implements DumbAware {
    private static boolean myActive = false;
    private AWTEventListener myFocusTracker;

    FocusTracesAction() {
        this.setEnabledInModalContext(true);
    }

    public static boolean isActive() {
        return myActive;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            FocusTracesAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        IdeFocusManager manager = IdeFocusManager.getGlobalInstance();
        if (!(manager instanceof FocusManagerImpl)) {
            return;
        }
        final FocusManagerImpl focusManager = (FocusManagerImpl)manager;
        boolean bl = myActive = !myActive;
        if (myActive) {
            this.myFocusTracker = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    if (event instanceof FocusEvent && event.getID() == 1004) {
                        focusManager.recordFocusRequest(((FocusEvent)event).getComponent(), false);
                    }
                }
            };
            Toolkit.getDefaultToolkit().addAWTEventListener(this.myFocusTracker, 4L);
        }
        if (!myActive) {
            List requests = focusManager.getRequests();
            new FocusTracesDialog(project, new ArrayList<FocusRequestInfo>(requests)).show();
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.myFocusTracker);
            this.myFocusTracker = null;
            requests.clear();
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            FocusTracesAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FocusTracesAction.$$$reportNull$$$0(2);
        }
        Presentation presentation = e.getPresentation();
        presentation.setText(myActive ? InternalActionsBundle.messagePointer((String)"action.presentation.FocusTracesAction.text.stop.focus.tracing", (Object[])new Object[0]) : InternalActionsBundle.messagePointer((String)"action.presentation.FocusTracesAction.text.start.focus.tracing", (Object[])new Object[0]));
        presentation.setEnabledAndVisible(e.getProject() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/focus/FocusTracesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/focus/FocusTracesAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

