/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef;

import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefCookie;
import com.intellij.ui.jcef.JBCefCookieManager;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBDimension;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

final class CookieManagerDialog
extends JDialog {
    private static final String myTitle = "Cookie Manager";
    private static final String myDeleteCookiesButtonText = "Delete All Cookies";
    private final JBCefBrowser myJBCefBrowser;
    private final JBCefCookieManager myJBCefCookieManager;
    private final CookieTableModel myTableModel = new CookieTableModel();

    CookieManagerDialog(Frame owner, JBCefBrowser jbCefBrowser) {
        super(owner, myTitle, false);
        this.setLayout(new BorderLayout());
        this.setSize((Dimension)JBDimension.size((Dimension)new Dimension(800, 600)));
        this.myJBCefBrowser = jbCefBrowser;
        this.myJBCefCookieManager = jbCefBrowser.getJBCefCookieManager();
        JBTable cookieTable = new JBTable((TableModel)this.myTableModel);
        cookieTable.setFillsViewportHeight(true);
        this.add(new JScrollPane((Component)cookieTable));
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        JButton myDeleteCookiesButton = new JButton(myDeleteCookiesButtonText);
        myDeleteCookiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CookieManagerDialog.this.myJBCefCookieManager.deleteCookies(true)) {
                    List cookies = CookieManagerDialog.this.myJBCefCookieManager.getCookies();
                    CookieManagerDialog.this.update(cookies);
                }
            }
        });
        controlPanel.add(myDeleteCookiesButton);
        this.add((Component)controlPanel, "South");
    }

    public void update(List<? extends JBCefCookie> cefCookies) {
        this.myTableModel.clear();
        this.myTableModel.show(cefCookies);
    }

    private static final class CookieTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"Name", "Value", "Domain", "Path", "Secure", "HTTP only", "Created", "Last Access", "Expires"};
        private final ArrayList<Object[]> rowData = new ArrayList();

        private CookieTableModel() {
        }

        private void show(@NotNull List<? extends JBCefCookie> cefCookies) {
            if (cefCookies == null) {
                CookieTableModel.$$$reportNull$$$0(0);
            }
            for (JBCefCookie jBCefCookie : cefCookies) {
                Object[] entry = new Object[]{jBCefCookie.getName(), jBCefCookie.getValue(), jBCefCookie.getDomain(), jBCefCookie.getPath(), jBCefCookie.isSecure(), jBCefCookie.isHttpOnly(), jBCefCookie.getCreation(), jBCefCookie.getLastAccess(), jBCefCookie.getExpires()};
                int row = this.rowData.size();
                this.rowData.add(entry);
                this.fireTableRowsInserted(row, row);
            }
        }

        public void clear() {
            int count = this.rowData.size();
            if (count > 0) {
                this.rowData.clear();
                this.fireTableRowsDeleted(0, count - 1);
            }
        }

        @Override
        public int getRowCount() {
            return this.rowData.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (!this.rowData.isEmpty() && this.rowData.get(0)[columnIndex] != null) {
                return this.rowData.get(0)[columnIndex].getClass();
            }
            return Object.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.rowData.get(rowIndex)[columnIndex];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cefCookies", "com/intellij/internal/jcef/CookieManagerDialog$CookieTableModel", "show"));
        }
    }
}

