/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef.test.cases;

import com.intellij.internal.jcef.test.cases.PerformanceTest;
import com.intellij.ui.jcef.JBCefBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/jcef/test/cases/FpsTestPanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "browser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "getBrowser", "()Lcom/intellij/ui/jcef/JBCefBrowser;", "repaintListener", "Lcom/intellij/internal/jcef/test/cases/PerformanceTest$RepaintListener;", "getRepaintListener", "()Lcom/intellij/internal/jcef/test/cases/PerformanceTest$RepaintListener;", "load", "", "applyNumericOnlyFilter", "textField", "Ljavax/swing/JTextField;", "intellij.platform.ide.internal"})
final class FpsTestPanel
extends JPanel {
    @NotNull
    private final JBCefBrowser browser = new JBCefBrowser();
    @NotNull
    private final PerformanceTest.RepaintListener repaintListener;

    public FpsTestPanel() {
        super(new BorderLayout());
        JCheckBox jCheckBox;
        JTextField jTextField;
        JComponent jComponent = this.browser.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        this.repaintListener = new PerformanceTest.RepaintListener(jComponent);
        this.browser.getJBCefClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadEnd(CefBrowser browser2, CefFrame frame, int httpStatusCode) {
                Intrinsics.checkNotNullParameter((Object)browser2, (String)"browser");
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                browser2.getDevToolsClient().executeDevToolsMethod("Overlay.setShowFPSCounter", "{ \"show\": true }");
            }
        }, this.browser.getCefBrowser());
        this.add((Component)this.repaintListener, "Center");
        JPanel controlPanel = new JPanel();
        JLabel fpsLimitLabel = new JLabel("FPS limit:");
        JTextField $this$_init__u24lambda_u240 = jTextField = new JTextField(5);
        boolean bl = false;
        this.applyNumericOnlyFilter($this$_init__u24lambda_u240);
        $this$_init__u24lambda_u240.getDocument().addDocumentListener(new DocumentListener(this, $this$_init__u24lambda_u240){
            final /* synthetic */ FpsTestPanel this$0;
            final /* synthetic */ JTextField $this_apply;
            {
                this.this$0 = $receiver;
                this.$this_apply = $receiver2;
            }

            public void insertUpdate(DocumentEvent e) {
                this.updateFpsLimit();
            }

            public void removeUpdate(DocumentEvent e) {
                this.updateFpsLimit();
            }

            public void changedUpdate(DocumentEvent e) {
                this.updateFpsLimit();
            }

            private final void updateFpsLimit() {
                CefBrowser cefBrowser = this.this$0.getBrowser().getCefBrowser();
                String string = this.$this_apply.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                Integer n = StringsKt.toIntOrNull((String)string);
                cefBrowser.setWindowlessFrameRate(n != null ? n : 0);
            }
        });
        JTextField fpsLimitInput2 = jTextField;
        controlPanel.add(fpsLimitLabel);
        controlPanel.add(fpsLimitInput2);
        JLabel primitivesNumberLabel = new JLabel("Number of primitives:");
        JTextField $this$_init__u24lambda_u241 = bl = new JTextField(5);
        boolean bl2 = false;
        this.applyNumericOnlyFilter($this$_init__u24lambda_u241);
        $this$_init__u24lambda_u241.getDocument().addDocumentListener(new DocumentListener(this, $this$_init__u24lambda_u241){
            final /* synthetic */ FpsTestPanel this$0;
            final /* synthetic */ JTextField $this_apply;
            {
                this.this$0 = $receiver;
                this.$this_apply = $receiver2;
            }

            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private final void update() {
                CefBrowser cefBrowser = this.this$0.getBrowser().getCefBrowser();
                String string = this.$this_apply.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                Integer n = StringsKt.toIntOrNull((String)string);
                cefBrowser.executeJavaScript("Particles.setParticlesCount(" + (n != null ? n : 0) + ")", null, 0);
            }
        });
        JTextField primitivesNumberInput2 = bl;
        controlPanel.add(primitivesNumberLabel);
        controlPanel.add(primitivesNumberInput2);
        JCheckBox $this$_init__u24lambda_u242 = jCheckBox = new JCheckBox("Pause", false);
        boolean bl3 = false;
        $this$_init__u24lambda_u242.addActionListener(arg_0 -> FpsTestPanel.lambda$2$0($this$_init__u24lambda_u242, this, arg_0));
        JCheckBox animateBackgroundCheckbox = jCheckBox;
        controlPanel.add(animateBackgroundCheckbox);
        this.add((Component)controlPanel, "South");
        this.setVisible(true);
        this.revalidate();
        this.repaint();
    }

    @NotNull
    public final JBCefBrowser getBrowser() {
        return this.browser;
    }

    @NotNull
    public final PerformanceTest.RepaintListener getRepaintListener() {
        return this.repaintListener;
    }

    public final void load() {
        InputStream resourceAsStream;
        InputStream inputStream = this.getClass().getResourceAsStream("resources/performance_test/fps_test.html");
        if (inputStream == null) {
            throw new RuntimeException("Cannot find fps_test.html");
        }
        InputStream inputStream2 = resourceAsStream = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        String html = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        this.browser.loadHTML(html);
    }

    private final void applyNumericOnlyFilter(JTextField textField) {
        block0: {
            Document document = textField.getDocument();
            AbstractDocument abstractDocument = document instanceof AbstractDocument ? (AbstractDocument)document : null;
            if (abstractDocument == null) break block0;
            abstractDocument.setDocumentFilter(new DocumentFilter(){

                public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) {
                    Intrinsics.checkNotNullParameter((Object)fb, (String)"fb");
                    if (string != null) {
                        boolean bl;
                        block3: {
                            CharSequence $this$all$iv = string;
                            boolean $i$f$all = false;
                            for (int i = 0; i < $this$all$iv.length(); ++i) {
                                char element$iv;
                                char it = element$iv = $this$all$iv.charAt(i);
                                boolean bl2 = false;
                                if (Character.isDigit(it)) continue;
                                bl = false;
                                break block3;
                            }
                            bl = true;
                        }
                        if (bl) {
                            super.insertString(fb, offset, string, attr);
                        }
                    }
                }

                public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) {
                    Intrinsics.checkNotNullParameter((Object)fb, (String)"fb");
                    if (text != null) {
                        boolean bl;
                        block3: {
                            CharSequence $this$all$iv = text;
                            boolean $i$f$all = false;
                            for (int i = 0; i < $this$all$iv.length(); ++i) {
                                char element$iv;
                                char it = element$iv = $this$all$iv.charAt(i);
                                boolean bl2 = false;
                                if (Character.isDigit(it)) continue;
                                bl = false;
                                break block3;
                            }
                            bl = true;
                        }
                        if (bl) {
                            super.replace(fb, offset, length, text, attrs);
                        }
                    }
                }
            });
        }
    }

    private static final void lambda$2$0(JCheckBox $this_apply, FpsTestPanel this$0, ActionEvent it) {
        if ($this_apply.isSelected()) {
            this$0.browser.getCefBrowser().executeJavaScript("Particles.pause()", null, 0);
        } else {
            this$0.browser.getCefBrowser().executeJavaScript("Particles.continue()", null, 0);
        }
    }
}

