/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef.test.cases;

import com.intellij.internal.jcef.test.cases.PlotlyChart;
import com.intellij.internal.jcef.test.cases.ScrollTestPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.ui.jcef.TestUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\b\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u00a8\u0006\u0002"}, d2={"runScrollingTest", "", "intellij.platform.ide.internal"})
public final class ScrollTestKt {
    public static final void runScrollingTest() {
        SwingUtilities.invokeLater(ScrollTestKt::runScrollingTest$lambda$0);
    }

    private static final void runScrollingTest$lambda$0() {
        JSplitPane jSplitPane;
        ScrollTestPanel testPanel = new ScrollTestPanel();
        PlotlyChart chart = new PlotlyChart();
        PlotlyChart.newPlot$default(chart, "[\n  {\n    x: [],\n    y: [],\n    mode: 'lines',\n    name: 'Scrolling Amount Requested',\n    line: { color: 'rgba(255, 99, 132, 1)' },\n  },\n  {\n    x: [],\n    y: [],\n    mode: 'lines',\n    name: 'Scrolling Amount Performed',\n    line: { color: 'rgba(54, 162, 235, 1)' },\n  },\n]", "        {\n          title: 'Scroll Tracking Diagram',\n          xaxis: { title: 'Time, ms' },\n          yaxis: { title: 'Scrolling Amount, pixels' },\n          showlegend: true,\n          legend: {\n            orientation: 'h',\n            y: -0.2,\n            x: 0.5,\n            xanchor: 'center',\n          },\n          dragmode: 'pan',\n        }", null, 4, null);
        Ref.DoubleRef scrollRequested = new Ref.DoubleRef();
        Ref.ObjectRef firstEvent = new Ref.ObjectRef();
        Function2 appendToChart = (arg_0, arg_1) -> ScrollTestKt.runScrollingTest$lambda$0$0(firstEvent, chart, arg_0, arg_1);
        int rotationFactor = RegistryManager.Companion.getInstance().intValue("ide.browser.jcef.osr.wheelRotation.factor");
        testPanel.getBrowser().getCefBrowser().getUIComponent().addMouseWheelListener(arg_0 -> ScrollTestKt.runScrollingTest$lambda$0$1(scrollRequested, rotationFactor, appendToChart, arg_0));
        testPanel.getRepaintListener().setOnRepaint((Function0<Unit>)((Function0)() -> ScrollTestKt.runScrollingTest$lambda$0$2(testPanel, appendToChart)));
        testPanel.load();
        JSplitPane $this$runScrollingTest_u24lambda_u240_u243 = jSplitPane = new JSplitPane(1);
        boolean bl = false;
        $this$runScrollingTest_u24lambda_u240_u243.setLeftComponent(testPanel.getComponent());
        $this$runScrollingTest_u24lambda_u240_u243.setRightComponent(chart.getComponent());
        $this$runScrollingTest_u24lambda_u240_u243.setResizeWeight(0.5);
        JSplitPane splitPane = jSplitPane;
        JFrame frame = new JFrame("Scrolling Test");
        frame.setDefaultCloseOperation(2);
        frame.setSize(1200, 800);
        frame.getContentPane().add(splitPane);
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(testPanel, chart){
            final /* synthetic */ ScrollTestPanel $testPanel;
            final /* synthetic */ PlotlyChart $chart;
            {
                this.$testPanel = $testPanel;
                this.$chart = $chart;
            }

            public void windowClosed(WindowEvent e) {
                Disposer.dispose((Disposable)((Disposable)this.$testPanel.getBrowser()));
                Disposer.dispose((Disposable)this.$chart);
            }
        });
    }

    private static final Unit runScrollingTest$lambda$0$0(Ref.ObjectRef $firstEvent, PlotlyChart $chart, double scrollAmount, int index) {
        long timeNow = System.currentTimeMillis();
        if ($firstEvent.element == null) {
            $firstEvent.element = timeNow;
        }
        $chart.extendTraces(StringsKt.trimIndent((String)("\n        {\n          x: [[" + (timeNow - ((Number)$firstEvent.element).longValue()) + "]],\n          y: [[" + scrollAmount + "]]\n        }\n      ")), "[" + index + "]");
        return Unit.INSTANCE;
    }

    private static final void runScrollingTest$lambda$0$1(Ref.DoubleRef $scrollRequested, int $rotationFactor, Function2 $appendToChart, MouseWheelEvent it) {
        $scrollRequested.element += it.getPreciseWheelRotation() * (double)$rotationFactor;
        $appendToChart.invoke((Object)$scrollRequested.element, (Object)0);
    }

    private static final Unit runScrollingTest$lambda$0$2(ScrollTestPanel $testPanel, Function2 $appendToChart) {
        Color color = TestUtils.getColorAt((Component)$testPanel.getBrowser().getBrowserComponent(), (int)0, (int)0);
        if (color != null) {
            double scrollPerformed = color.getBlue() + (color.getGreen() << 8) + (color.getRed() << 16);
            $appendToChart.invoke((Object)scrollPerformed, (Object)1);
        }
        return Unit.INSTANCE;
    }
}

