/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml.completion;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u0006\n\u0002\b\u0005\bf\u0018\u0000 \b2\u00020\u0001:\u0004\b\t\n\u000bJ\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/internal/ml/completion/DecoratingItemsPolicy;", "", "itemsToDecorate", "", "", "scores", "", "", "Companion", "ByAbsoluteThreshold", "ByRelativeThreshold", "Composite", "intellij.platform.ide.internal"})
public interface DecoratingItemsPolicy {
    @NotNull
    public static final Companion Companion = com.intellij.internal.ml.completion.DecoratingItemsPolicy$Companion.$$INSTANCE;

    @NotNull
    public Set<Integer> itemsToDecorate(@NotNull Iterable<Double> var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/ml/completion/DecoratingItemsPolicy$ByAbsoluteThreshold;", "Lcom/intellij/internal/ml/completion/DecoratingItemsPolicy;", "threshold", "", "<init>", "(D)V", "itemsToDecorate", "", "", "scores", "", "intellij.platform.ide.internal"})
    public static final class ByAbsoluteThreshold
    implements DecoratingItemsPolicy {
        private final double threshold;

        public ByAbsoluteThreshold(double threshold) {
            this.threshold = threshold;
        }

        @Override
        @NotNull
        public Set<Integer> itemsToDecorate(@NotNull Iterable<Double> scores) {
            Intrinsics.checkNotNullParameter(scores, (String)"scores");
            Double d = (Double)CollectionsKt.firstOrNull(scores);
            if (d != null) {
                double it = ((Number)d).doubleValue();
                boolean bl = false;
                if (it >= this.threshold) {
                    return SetsKt.setOf((Object)0);
                }
            }
            return SetsKt.emptySet();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/ml/completion/DecoratingItemsPolicy$ByRelativeThreshold;", "Lcom/intellij/internal/ml/completion/DecoratingItemsPolicy;", "threshold", "", "<init>", "(D)V", "itemsToDecorate", "", "", "scores", "", "intellij.platform.ide.internal"})
    public static final class ByRelativeThreshold
    implements DecoratingItemsPolicy {
        private final double threshold;

        public ByRelativeThreshold(double threshold) {
            this.threshold = threshold;
        }

        @Override
        @NotNull
        public Set<Integer> itemsToDecorate(@NotNull Iterable<Double> scores) {
            Intrinsics.checkNotNullParameter(scores, (String)"scores");
            List topItems = CollectionsKt.take(scores, (int)2);
            if (topItems.size() == 1 || topItems.size() >= 2 && ((Number)topItems.get(0)).doubleValue() - ((Number)topItems.get(1)).doubleValue() >= this.threshold) {
                return SetsKt.setOf((Object)0);
            }
            return SetsKt.emptySet();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/internal/ml/completion/DecoratingItemsPolicy$Companion;", "", "<init>", "()V", "DISABLED", "Lcom/intellij/internal/ml/completion/DecoratingItemsPolicy;", "getDISABLED", "()Lcom/intellij/internal/ml/completion/DecoratingItemsPolicy;", "intellij.platform.ide.internal"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final DecoratingItemsPolicy DISABLED;

        private Companion() {
        }

        @NotNull
        public final DecoratingItemsPolicy getDISABLED() {
            return DISABLED;
        }

        static {
            $$INSTANCE = new Companion();
            DISABLED = new DecoratingItemsPolicy(){

                public Set<Integer> itemsToDecorate(Iterable<Double> scores) {
                    Intrinsics.checkNotNullParameter(scores, (String)"scores");
                    return SetsKt.emptySet();
                }
            };
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016R\u0018\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/ml/completion/DecoratingItemsPolicy$Composite;", "Lcom/intellij/internal/ml/completion/DecoratingItemsPolicy;", "policies", "", "<init>", "([Lcom/intellij/internal/ml/completion/DecoratingItemsPolicy;)V", "[Lcom/intellij/internal/ml/completion/DecoratingItemsPolicy;", "itemsToDecorate", "", "", "scores", "", "", "intellij.platform.ide.internal"})
    public static final class Composite
    implements DecoratingItemsPolicy {
        @NotNull
        private final DecoratingItemsPolicy[] policies;

        public Composite(DecoratingItemsPolicy ... policies) {
            Intrinsics.checkNotNullParameter((Object)policies, (String)"policies");
            this.policies = policies;
        }

        @Override
        @NotNull
        public Set<Integer> itemsToDecorate(@NotNull Iterable<Double> scores) {
            Intrinsics.checkNotNullParameter(scores, (String)"scores");
            if (this.policies.length == 0) {
                return SetsKt.emptySet();
            }
            Set result = null;
            for (DecoratingItemsPolicy policy : this.policies) {
                if (!(result = result == null ? policy.itemsToDecorate(scores) : CollectionsKt.intersect((Iterable)result, (Iterable)policy.itemsToDecorate(scores))).isEmpty()) continue;
                return SetsKt.emptySet();
            }
            Set set = result;
            if (set == null) {
                set = SetsKt.emptySet();
            }
            return set;
        }
    }
}

