/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0006R\u001f\u0010\u0004\u001a\u0013\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/fileTypes/FileExtensionCounter;", "", "<init>", "()V", "fileExtensionCounter", "", "", "Lorg/jetbrains/annotations/NotNull;", "", "totalCount", "recordOriginalFileType", "", "fileExtension", "getFileExtensionsList", "", "getFileExtensionCount", "extension", "getFileExtensionUsagePercentage", "intellij.platform.ide.internal"})
@SourceDebugExtension(value={"SMAP\nFileExtensionCounter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileExtensionCounter.kt\ncom/intellij/internal/statistic/collectors/fus/fileTypes/FileExtensionCounter\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,22:1\n382#2,7:23\n*S KotlinDebug\n*F\n+ 1 FileExtensionCounter.kt\ncom/intellij/internal/statistic/collectors/fus/fileTypes/FileExtensionCounter\n*L\n12#1:23,7\n*E\n"})
public final class FileExtensionCounter {
    @NotNull
    private final Map<String, Integer> fileExtensionCounter = new LinkedHashMap();
    private int totalCount;

    /*
     * WARNING - void declaration
     */
    public final void recordOriginalFileType(@NotNull String fileExtension) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)fileExtension, (String)"fileExtension");
        Map<String, Integer> map = this.fileExtensionCounter;
        String key$iv = fileExtension;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Integer answer$iv = 0;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        int currentFileExtensionCount = ((Number)object).intValue();
        this.fileExtensionCounter.put(fileExtension, currentFileExtensionCount + 1);
        int n = this.totalCount;
        this.totalCount = n + 1;
    }

    @NotNull
    public final List<String> getFileExtensionsList() {
        return CollectionsKt.toList((Iterable)this.fileExtensionCounter.keySet());
    }

    public final int getFileExtensionCount(@NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return ((Number)this.fileExtensionCounter.getOrDefault(extension, 0)).intValue();
    }

    public final int getFileExtensionUsagePercentage(@NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return MathKt.roundToInt((double)((double)this.getFileExtensionCount(extension) / (double)this.totalCount * (double)100));
    }
}

