/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.execution.wsl.WslPath;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.JpsElementPropertiesSerializer;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;

final class ProjectStructureUsageCollector
extends ProjectUsagesCollector {
    private final EventLogGroup GROUP = new EventLogGroup("project.structure", 6);
    private final EventId1<Integer> MODULES_TOTAL = this.GROUP.registerEvent("modules.total", (EventField)EventFields.Count);
    private final EventId1<Integer> MODULE_GROUPS_TOTAL = this.GROUP.registerEvent("module.groups.total", (EventField)EventFields.Count);
    private final EventId1<Integer> UNLOADED_MODULES_TOTAL = this.GROUP.registerEvent("unloaded.modules.total", (EventField)EventFields.Count);
    private final EventId1<Integer> CONTENT_ROOTS_TOTAL = this.GROUP.registerEvent("content.roots.total", (EventField)EventFields.Count);
    private final EventId1<Integer> SOURCE_ROOTS_TOTAL = this.GROUP.registerEvent("source.roots.total", (EventField)EventFields.Count);
    private final EventId1<Integer> EXCLUDED_ROOTS_TOTAL = this.GROUP.registerEvent("excluded.roots.total", (EventField)EventFields.Count);
    private final EventId2<Integer, String> SOURCE_ROOT = this.GROUP.registerEvent("source.root", (EventField)EventFields.Count, (EventField)EventFields.String((String)"type", Arrays.asList("cookbooks-root", "java-resource", "java-source", "java-test-resource", "java-test", "kotlin-resource", "kotlin-source", "kotlin-test-resource", "kotlin-test")));
    private final EventId1<Integer> PACKAGE_PREFIX = this.GROUP.registerEvent("package.prefix", (EventField)EventFields.Count);
    private final EventId1<Integer> NAMED_SCOPES_TOTAL_LOCAL = this.GROUP.registerEvent("named.scopes.total.local", (EventField)EventFields.Count);
    private final EventId1<Integer> NAMED_SCOPES_TOTAL_SHARED = this.GROUP.registerEvent("named.scopes.total.shared", (EventField)EventFields.Count);
    private final EventId PROJECT_IN_WSL = this.GROUP.registerEvent("project.in.wsl");

    ProjectStructureUsageCollector() {
    }

    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            ProjectStructureUsageCollector.$$$reportNull$$$0(0);
        }
        Map typeNames = JBIterable.from((Iterable)JpsModelSerializerExtension.getExtensions()).filter(o -> PluginInfoDetectorKt.getPluginInfo(o.getClass()).isDevelopedByJetBrains()).flatMap(JpsModelSerializerExtension::getModuleSourceRootPropertiesSerializers).toMap(JpsElementPropertiesSerializer::getType, JpsElementPropertiesSerializer::getTypeId);
        int contentRoots = 0;
        int sourceRoots = 0;
        int excludedRoots = 0;
        int packagePrefix = 0;
        Object2IntOpenHashMap types = new Object2IntOpenHashMap();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Module[] modules = moduleManager.getModules();
        HashSet<List<String>> moduleGroups = new HashSet<List<String>>();
        for (Module module : modules) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            contentRoots += rootManager.getContentEntries().length;
            sourceRoots += rootManager.getSourceRoots(true).length;
            excludedRoots += rootManager.getExcludeRoots().length;
            for (ContentEntry entry : rootManager.getContentEntries()) {
                for (SourceFolder source : entry.getSourceFolders()) {
                    String key;
                    if (StringUtil.isNotEmpty((String)source.getPackagePrefix())) {
                        ++packagePrefix;
                    }
                    if ((key = (String)typeNames.get(source.getRootType())) == null) continue;
                    types.mergeInt((Object)key, 1, Math::addExact);
                }
            }
            String[] groupPath = moduleManager.getModuleGroupPath(module);
            if (groupPath == null) continue;
            moduleGroups.add(Arrays.asList(groupPath));
        }
        HashSet<MetricEvent> result = new HashSet<MetricEvent>();
        result.add(this.MODULES_TOTAL.metric((Object)modules.length));
        result.add(this.MODULE_GROUPS_TOTAL.metric((Object)moduleGroups.size()));
        result.add(this.UNLOADED_MODULES_TOTAL.metric((Object)moduleManager.getUnloadedModuleDescriptions().size()));
        result.add(this.CONTENT_ROOTS_TOTAL.metric((Object)contentRoots));
        result.add(this.SOURCE_ROOTS_TOTAL.metric((Object)sourceRoots));
        result.add(this.EXCLUDED_ROOTS_TOTAL.metric((Object)excludedRoots));
        for (Object2IntMap.Entry entry : types.object2IntEntrySet()) {
            result.add(this.SOURCE_ROOT.metric((Object)entry.getIntValue(), (Object)((String)entry.getKey())));
        }
        if (PlatformUtils.isIntelliJ()) {
            result.add(this.PACKAGE_PREFIX.metric((Object)packagePrefix));
        }
        NamedScope[] localScopes = NamedScopeManager.getInstance((Project)project).getEditableScopes();
        result.add(this.NAMED_SCOPES_TOTAL_LOCAL.metric((Object)localScopes.length));
        NamedScope[] sharedScopes = DependencyValidationManager.getInstance((Project)project).getEditableScopes();
        result.add(this.NAMED_SCOPES_TOTAL_SHARED.metric((Object)sharedScopes.length));
        String basePath = project.getBasePath();
        if (basePath != null && WslPath.isWslUncPath((String)basePath)) {
            result.add(this.PROJECT_IN_WSL.metric());
        }
        HashSet<MetricEvent> hashSet = result;
        if (hashSet == null) {
            ProjectStructureUsageCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/fileTypes/ProjectStructureUsageCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/ProjectStructureUsageCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

