/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.os;

import com.intellij.diagnostic.VMOptions;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.util.CurrentJavaVersion;
import com.intellij.util.system.CpuArch;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.JBR;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010#\u001a\u00020\u0005H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016J\u0016\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010(H\u0002J\u0016\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010(H\u0002J\b\u0010*\u001a\u00020\bH\u0002J\b\u0010+\u001a\u00020\bH\u0002J\b\u0010,\u001a\u00020\bH\u0002J\u0014\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001c0.H\u0002J\u0014\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0.H\u0002J\u0014\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120(H\u0002J\b\u00101\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0003R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0018\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u001c0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u001e0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/os/SystemRuntimeCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "COLLECTORS", "", "", "ARCHITECTURES", "VENDORS", "VM_OPTIONS", "SYSTEM_PROPERTIES", "RENDERING_PIPELINES", "OS_VMS", "getOS_VMS$annotations", "CORES", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "MEMORY_SIZE", "SWAP_SIZE", "DISK_SIZE", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "GC", "JVM", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "Lcom/intellij/openapi/util/Version;", "JVM_OPTION", "", "SYSTEM_PROPERTY", "", "DEBUG_AGENT", "AGENTS_COUNT", "RENDERING", "OS_VM", "getGroup", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "getPhysicalMemoryAndSwapSize", "Lkotlin/Pair;", "getIndexVolumeSizeAndFreeSpace", "getGcName", "getRenderingPipelineName", "getJavaVendor", "collectJvmOptions", "", "collectSystemProperties", "countAgents", "getOsVirtualization", "intellij.platform.ide.internal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSystemRuntimeCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemRuntimeCollector.kt\ncom/intellij/internal/statistic/collectors/fus/os/SystemRuntimeCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n1788#2,4:204\n1788#2,4:208\n1#3:212\n*S KotlinDebug\n*F\n+ 1 SystemRuntimeCollector.kt\ncom/intellij/internal/statistic/collectors/fus/os/SystemRuntimeCollector\n*L\n190#1:204,4\n191#1:208,4\n*E\n"})
public final class SystemRuntimeCollector
extends ApplicationUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("system.runtime", 22, null, 4, null);
    @NotNull
    private final List<String> COLLECTORS;
    @NotNull
    private final List<String> ARCHITECTURES;
    @NotNull
    private final List<String> VENDORS;
    @NotNull
    private final List<String> VM_OPTIONS;
    @NotNull
    private final List<String> SYSTEM_PROPERTIES;
    @NotNull
    private final List<String> RENDERING_PIPELINES;
    @NotNull
    private final List<String> OS_VMS;
    @NotNull
    private final EventId1<Integer> CORES;
    @NotNull
    private final EventId1<Integer> MEMORY_SIZE;
    @NotNull
    private final EventId1<Integer> SWAP_SIZE;
    @NotNull
    private final EventId2<Integer, Integer> DISK_SIZE;
    @NotNull
    private final EventId1<String> GC;
    @NotNull
    private final EventId3<Version, String, String> JVM;
    @NotNull
    private final EventId2<String, Long> JVM_OPTION;
    @NotNull
    private final EventId2<String, Boolean> SYSTEM_PROPERTY;
    @NotNull
    private final EventId1<Boolean> DEBUG_AGENT;
    @NotNull
    private final EventId2<Integer, Integer> AGENTS_COUNT;
    @NotNull
    private final EventId1<String> RENDERING;
    @NotNull
    private final EventId1<String> OS_VM;

    public SystemRuntimeCollector() {
        Object[] objectArray = new String[]{"Serial", "Parallel", "CMS", "G1", "Z", "Shenandoah", "Epsilon", "Other"};
        this.COLLECTORS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"x86", "x86_64", "arm64", "other", "unknown"};
        this.ARCHITECTURES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"JetBrains", "Apple", "Oracle", "Sun", "IBM", "Azul", "Other"};
        this.VENDORS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"Xmx", "Xms", "SoftRefLRUPolicyMSPerMB", "ReservedCodeCacheSize"};
        this.VM_OPTIONS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"splash", "nosplash"};
        this.SYSTEM_PROPERTIES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"Metal", "Vulkan", "Other"};
        this.RENDERING_PIPELINES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"none", "xen", "kvm", "vmware", "hyperv", "other", "unknown"};
        this.OS_VMS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new int[11];
        objectArray[0] = true;
        objectArray[1] = 2;
        objectArray[2] = 4;
        objectArray[3] = 6;
        objectArray[4] = 8;
        objectArray[5] = 12;
        objectArray[6] = 16;
        objectArray[7] = 20;
        objectArray[8] = 24;
        objectArray[9] = 32;
        objectArray[10] = 64;
        this.CORES = this.GROUP.registerEvent("cores", (EventField)EventFields.BoundedInt((String)"value", (int[])objectArray));
        objectArray = new int[12];
        objectArray[0] = true;
        objectArray[1] = 2;
        objectArray[2] = 4;
        objectArray[3] = 8;
        objectArray[4] = 12;
        objectArray[5] = 16;
        objectArray[6] = 24;
        objectArray[7] = 32;
        objectArray[8] = 48;
        objectArray[9] = 64;
        objectArray[10] = 128;
        objectArray[11] = 256;
        this.MEMORY_SIZE = this.GROUP.registerEvent("memory.size", (EventField)EventFields.BoundedInt((String)"gigabytes", (int[])objectArray));
        this.SWAP_SIZE = this.GROUP.registerEvent("swap.size", (EventField)EventFields.Int((String)"gigabytes"));
        this.DISK_SIZE = this.GROUP.registerEvent("disk.size", (EventField)EventFields.Int((String)"index_partition_size"), (EventField)EventFields.Int((String)"index_partition_free"));
        this.GC = this.GROUP.registerEvent("garbage.collector", (EventField)EventFields.String((String)"name", this.COLLECTORS));
        this.JVM = this.GROUP.registerEvent("jvm", (EventField)EventFields.VersionByObject, (EventField)EventFields.String((String)"arch", this.ARCHITECTURES), (EventField)EventFields.String((String)"vendor", this.VENDORS));
        this.JVM_OPTION = this.GROUP.registerEvent("jvm.option", (EventField)EventFields.String((String)"name", this.VM_OPTIONS), (EventField)EventFields.Long$default((String)"value", null, (int)2, null));
        this.SYSTEM_PROPERTY = this.GROUP.registerEvent("jvm.client.properties", (EventField)EventFields.String((String)"name", this.SYSTEM_PROPERTIES), (EventField)EventFields.Boolean((String)"value"));
        this.DEBUG_AGENT = this.GROUP.registerEvent("debug.agent", (EventField)EventFields.Enabled);
        this.AGENTS_COUNT = this.GROUP.registerEvent("agents.count", (EventField)EventFields.Int((String)"java_agents"), (EventField)EventFields.Int((String)"native_agents"));
        this.RENDERING = this.GROUP.registerEvent("rendering.pipeline", (EventField)EventFields.String((String)"name", this.RENDERING_PIPELINES));
        this.OS_VM = this.GROUP.registerEvent("os.vm", (EventField)EventFields.String((String)"name", this.OS_VMS));
    }

    private static /* synthetic */ void getOS_VMS$annotations() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        Pair<Integer, Integer> indexVolumeData;
        Set result = new LinkedHashSet();
        ((Collection)result).add(this.CORES.metric((Object)Runtime.getRuntime().availableProcessors()));
        Pair<Integer, Integer> physicalMemoryData = this.getPhysicalMemoryAndSwapSize();
        if (physicalMemoryData != null) {
            Pair<Integer, Integer> pair = physicalMemoryData;
            int physicalMemory = ((Number)pair.component1()).intValue();
            int n = ((Number)pair.component2()).intValue();
            ((Collection)result).add(this.MEMORY_SIZE.metric((Object)physicalMemory));
            ((Collection)result).add(this.SWAP_SIZE.metric((Object)n));
        }
        if ((indexVolumeData = this.getIndexVolumeSizeAndFreeSpace()) != null) {
            Pair<Integer, Integer> pair = indexVolumeData;
            int n = ((Number)pair.component1()).intValue();
            int freeSpace = ((Number)pair.component2()).intValue();
            ((Collection)result).add(this.DISK_SIZE.metric((Object)n, (Object)freeSpace));
        }
        ((Collection)result).add(this.GC.metric((Object)this.getGcName()));
        Iterator<Map.Entry<String, String>> iterator2 = result;
        Version version = new Version(1, CurrentJavaVersion.currentJavaVersion().feature, 0);
        String string = CpuArch.CURRENT.name();
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        iterator2.add((Map.Entry<String, String>)this.JVM.metric((Object)version, (Object)string2, (Object)this.getJavaVendor()));
        for (Map.Entry entry : this.collectJvmOptions().entrySet()) {
            ((Collection)result).add(this.JVM_OPTION.metric(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, String> entry : this.collectSystemProperties().entrySet()) {
            ((Collection)result).add(this.SYSTEM_PROPERTY.metric((Object)entry.getKey(), (Object)Boolean.parseBoolean(entry.getValue())));
        }
        ((Collection)result).add(this.DEBUG_AGENT.metric((Object)DebugAttachDetector.isDebugEnabled()));
        iterator2 = this.countAgents();
        int n = ((Number)iterator2.component1()).intValue();
        int nativeAgents = ((Number)iterator2.component2()).intValue();
        ((Collection)result).add(this.AGENTS_COUNT.metric((Object)n, (Object)nativeAgents));
        if (SystemInfo.isMac) {
            ((Collection)result).add(this.RENDERING.metric((Object)this.getRenderingPipelineName()));
        }
        ((Collection)result).add(this.OS_VM.metric((Object)this.getOsVirtualization()));
        return result;
    }

    private final Pair<Integer, Integer> getPhysicalMemoryAndSwapSize() {
        try {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            Intrinsics.checkNotNull((Object)operatingSystemMXBean, (String)"null cannot be cast to non-null type com.sun.management.OperatingSystemMXBean");
            com.sun.management.OperatingSystemMXBean bean = (com.sun.management.OperatingSystemMXBean)operatingSystemMXBean;
            int physicalMemory = SystemRuntimeCollector.getPhysicalMemoryAndSwapSize$GiB(bean.getTotalMemorySize());
            int swapSize = StatisticsUtil.roundToPowerOfTwo((int)Math.min(SystemRuntimeCollector.getPhysicalMemoryAndSwapSize$GiB(bean.getTotalSwapSpaceSize()), 256));
            return TuplesKt.to((Object)physicalMemory, (Object)swapSize);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private final Pair<Integer, Integer> getIndexVolumeSizeAndFreeSpace() {
        try {
            FileStore fileStore = Files.getFileStore(PathManager.getIndexRoot());
            long totalSpace = fileStore.getTotalSpace();
            if (totalSpace > 0L) {
                int size = Math.min(16384, StatisticsUtil.roundToPowerOfTwo((int)((int)(totalSpace >> 30))));
                int freeSpace = (int)((double)fileStore.getUsableSpace() * 100.0 / (double)totalSpace);
                return TuplesKt.to((Object)size, (Object)freeSpace);
            }
        }
        catch (IOException iOException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private final String getGcName() {
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (Intrinsics.areEqual((Object)gc.getName(), (Object)"MarkSweepCompact") || Intrinsics.areEqual((Object)gc.getName(), (Object)"Copy")) {
                return "Serial";
            }
            if (Intrinsics.areEqual((Object)gc.getName(), (Object)"PS MarkSweep") || Intrinsics.areEqual((Object)gc.getName(), (Object)"PS Scavenge")) {
                return "Parallel";
            }
            if (Intrinsics.areEqual((Object)gc.getName(), (Object)"ConcurrentMarkSweep") || Intrinsics.areEqual((Object)gc.getName(), (Object)"ParNew")) {
                return "CMS";
            }
            String string = gc.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.startsWith$default((String)string, (String)"G1 ", (boolean)false, (int)2, null)) {
                return "G1";
            }
            String string2 = gc.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            if (StringsKt.startsWith$default((String)string2, (String)"ZGC ", (boolean)false, (int)2, null)) {
                return "Z";
            }
            String string3 = gc.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            if (StringsKt.startsWith$default((String)string3, (String)"Shenandoah ", (boolean)false, (int)2, null)) {
                return "Shenandoah";
            }
            String string4 = gc.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            if (!StringsKt.startsWith$default((String)string4, (String)"Epsilon ", (boolean)false, (int)2, null)) continue;
            return "Epsilon";
        }
        return "Other";
    }

    private final String getRenderingPipelineName() {
        return UIUtil.isMetalRendering() ? "Metal" : (JBR.isVulkanSupported() && JBR.getVulkan().isPresentationEnabled() ? "Vulkan" : "Other");
    }

    private final String getJavaVendor() {
        return SystemInfo.isJetBrainsJvm ? "JetBrains" : (SystemInfo.isOracleJvm ? "Oracle" : (SystemInfo.isIbmJvm ? "IBM" : (SystemInfo.isAzulJvm ? "Azul" : "Other")));
    }

    private final Map<String, Long> collectJvmOptions() {
        List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getInputArguments(...)");
        return MapsKt.toMap((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), SystemRuntimeCollector::collectJvmOptions$lambda$0)));
    }

    private final Map<String, String> collectSystemProperties() {
        return MapsKt.toMap((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.SYSTEM_PROPERTIES), SystemRuntimeCollector::collectSystemProperties$lambda$0), SystemRuntimeCollector::collectSystemProperties$lambda$1));
    }

    private final Pair<Integer, Integer> countAgents() {
        int n;
        int n2;
        List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
        Intrinsics.checkNotNull(args);
        Iterable $this$count$iv = args;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String arg = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)arg);
                if (!StringsKt.startsWith$default((String)arg, (String)"-javaagent:", (boolean)false, (int)2, null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int javaAgents = n2;
        Iterable $this$count$iv2 = args;
        boolean $i$f$count2 = false;
        if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv2) {
                String arg = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)arg);
                if (!(StringsKt.startsWith$default((String)arg, (String)"-agentlib:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)arg, (String)"-agentpath:", (boolean)false, (int)2, null)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int nativeAgents = n;
        return TuplesKt.to((Object)javaAgents, (Object)nativeAgents);
    }

    private final String getOsVirtualization() {
        String vm;
        String string;
        block3: {
            block2: {
                string = System.getProperty("intellij.os.virtualization");
                if (string == null) break block2;
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                string = string2;
                if (string2 != null) break block3;
            }
            string = "unknown";
        }
        return this.OS_VMS.contains(vm = string) ? vm : "other";
    }

    private static final int getPhysicalMemoryAndSwapSize$GiB(long bytes) {
        return MathKt.roundToInt((double)((double)bytes / (double)0x40000000));
    }

    private static final Pair collectJvmOptions$lambda$0(String arg) {
        long[] lArray;
        try {
            Pair pair;
            Intrinsics.checkNotNull((Object)arg);
            if (StringsKt.startsWith$default((String)arg, (String)"-Xms", (boolean)false, (int)2, null)) {
                lArray = new long[]{64L, 128L, 256L, 512L};
                pair = TuplesKt.to((Object)"Xms", (Object)SystemRuntimeCollector.collectJvmOptions$lambda$0$roundDown(SystemRuntimeCollector.collectJvmOptions$lambda$0$parse(arg, 4), lArray));
            } else if (StringsKt.startsWith$default((String)arg, (String)"-Xmx", (boolean)false, (int)2, null)) {
                lArray = new long[]{512L, 750L, 1000L, 1024L, 1500L, 2000L, 2048L, 3000L, 4000L, 4096L, 6000L, 8000L};
                pair = TuplesKt.to((Object)"Xmx", (Object)SystemRuntimeCollector.collectJvmOptions$lambda$0$roundDown(SystemRuntimeCollector.collectJvmOptions$lambda$0$parse(arg, 4), lArray));
            } else if (StringsKt.startsWith$default((String)arg, (String)"-XX:SoftRefLRUPolicyMSPerMB=", (boolean)false, (int)2, null)) {
                lArray = new long[]{50L, 100L};
                pair = TuplesKt.to((Object)"SoftRefLRUPolicyMSPerMB", (Object)SystemRuntimeCollector.collectJvmOptions$lambda$0$roundDown(SystemRuntimeCollector.collectJvmOptions$lambda$0$parse(arg, 28), lArray));
            } else if (StringsKt.startsWith$default((String)arg, (String)"-XX:ReservedCodeCacheSize=", (boolean)false, (int)2, null)) {
                lArray = new long[]{240L, 300L, 400L, 500L};
                pair = TuplesKt.to((Object)"ReservedCodeCacheSize", (Object)SystemRuntimeCollector.collectJvmOptions$lambda$0$roundDown(SystemRuntimeCollector.collectJvmOptions$lambda$0$parse(arg, 26), lArray));
            } else {
                pair = null;
            }
            lArray = pair;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            lArray = null;
        }
        return lArray;
    }

    private static final long collectJvmOptions$lambda$0$parse(String arg, int start) {
        String string = arg.substring(start);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return VMOptions.parseMemoryOption((String)string) >> 20;
    }

    private static final long collectJvmOptions$lambda$0$roundDown(long value, long ... steps) {
        Long l;
        block2: {
            long[] lArray = steps;
            int n = lArray.length + -1;
            if (0 <= n) {
                do {
                    long l2;
                    int n2 = n--;
                    long it = l2 = lArray[n2];
                    boolean bl = false;
                    if (!(it <= value)) continue;
                    l = l2;
                    break block2;
                } while (0 <= n);
            }
            l = null;
        }
        return l != null ? l : 0L;
    }

    private static final Pair collectSystemProperties$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TuplesKt.to((Object)it, (Object)System.getProperty(it));
    }

    private static final boolean collectSystemProperties$lambda$1(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSecond() != null;
    }
}

