/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ui;

import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.ui.laf.darcula.ui.DarculaSliderUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.SplitButtonAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComboBoxPopupState;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.cellvalidators.CellComponentProvider;
import com.intellij.openapi.ui.cellvalidators.CellTooltipManager;
import com.intellij.openapi.ui.cellvalidators.StatefulValidatingCellEditor;
import com.intellij.openapi.ui.cellvalidators.ValidatingTableCellRendererWrapper;
import com.intellij.openapi.ui.cellvalidators.ValidationUtils;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.ProgressPanel;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorComboBoxEditor;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ComponentPanelTestAction
extends DumbAwareAction {
    ComponentPanelTestAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ComponentPanelTestAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ComponentPanelTestAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ComponentPanelTestAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) != null) {
            new ComponentPanelTest(project).show();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/ui/ComponentPanelTestAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/ui/ComponentPanelTestAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static final class ComponentPanelTest
    extends DialogWrapper {
        private static final Set<String> ALLOWED_VALUES = Set.of("one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "abracadabra");
        private static final String[] STRING_VALUES = new String[]{"One", "Two", "Three", "Four", "Five", "Six"};
        private static final SimpleTextAttributes WARNING_CELL_ATTRIBUTES = new SimpleTextAttributes(8, null);
        private static final ValidationInfo NULL_VALUE_ERROR = new ValidationInfo("Null value");
        private static final ValidationInfo NAN_VALUE_ERROR = new ValidationInfo("Not a number");
        private static final String LONG_TEXT2 = "It is not the way of the Wild to like movement.<p/>Life is an offence to it, for life is movement; and the Wild aims always to destroy movement.";
        private static final String GOT_IT_HEADER = "IDE features trainer";
        private static final String GOT_IT_TEXT = "Learn the most useful shortcuts <icon src=\"AllIcons.Actions.More\"/> and essential IDE features interactively. Use <icon src=\"AllIcons.Actions.Diff\" valign=\"1.0f\"/> for details.";
        private static final String GOT_IT_TEXT2 = "Some textfield that actually means nothing";
        private final Alarm myAlarm = new Alarm(this.getDisposable());
        private ProgressTimerRequest progressTimerRequest;
        private JTabbedPane pane;
        private final Project project;
        private int counter = 5;

        private ComponentPanelTest(Project project) {
            super(project);
            this.project = project;
            this.init();
            this.setTitle("Component Panel Test Action");
        }

        @NotNull
        protected JComponent createCenterPanel() {
            this.pane = new JBTabbedPane(1);
            this.pane.addTab("Component", this.createComponentPanel());
            this.pane.addTab("Progress Grid", this.createProgressGridPanel());
            this.pane.addTab("Validators", this.createValidatorsPanel());
            this.pane.addTab("Multilines", this.createMultilinePanel());
            this.pane.addTab("JSliderUI", this.createJSliderTab());
            this.pane.addTab("ComboBox", this.createComboBoxTab());
            this.pane.addChangeListener(e -> {
                if (this.pane.getSelectedIndex() == 4) {
                    this.myAlarm.addRequest((Runnable)this.progressTimerRequest, 200, ModalityState.any());
                } else {
                    this.myAlarm.cancelRequest((Runnable)this.progressTimerRequest);
                }
            });
            BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)this.pane);
            panel2.addToTop((Component)this.createToolbar(this.pane));
            JPanel southPanel = new JPanel();
            southPanel.setLayout(new BoxLayout(southPanel, 0));
            JCheckBox enabledCB = new JCheckBox("Enable TabPane", true);
            enabledCB.addActionListener(e -> this.pane.setEnabled(enabledCB.isSelected()));
            southPanel.add(enabledCB);
            southPanel.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
            ComboBox placementCombo = new ComboBox((Object[])Placement.values());
            placementCombo.setSelectedIndex(0);
            placementCombo.addActionListener(arg_0 -> this.lambda$createCenterPanel$2((JComboBox)placementCombo, arg_0));
            southPanel.add((Component)placementCombo);
            southPanel.add(new Box.Filler((Dimension)JBUI.size((int)0), (Dimension)JBUI.size((int)0), (Dimension)JBUI.size((int)Integer.MAX_VALUE, (int)0)));
            BrowserLink externalLink = new BrowserLink("External link", "http://google.com");
            southPanel.add((Component)externalLink);
            panel2.addToBottom((Component)southPanel);
            BorderLayoutPanel borderLayoutPanel = panel2;
            if (borderLayoutPanel == null) {
                ComponentPanelTest.$$$reportNull$$$0(0);
            }
            return borderLayoutPanel;
        }

        private JComponent createComponentPanel() {
            JPanel topPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, (Insets)JBInsets.create((int)5, (int)0), 0, 0);
            JTextField text1 = new JTextField();
            new ComponentValidator(this.getDisposable()).withHyperlinkListener(e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    System.out.println("Text1 link clicked. Desc = " + e.getDescription());
                }
            }).withValidator(() -> {
                String tt = text1.getText();
                if (StringUtil.isNotEmpty((String)tt)) {
                    try {
                        Integer.parseInt(tt);
                        return null;
                    }
                    catch (NumberFormatException nex) {
                        return new ValidationInfo("Warning, expecting a number.<br/>Visit the <a href=\"#link.one\">information link</a><br/>Or <a href=\"#link.two\">another link</a>", (JComponent)text1).asWarning();
                    }
                }
                return null;
            }).withFocusValidator(() -> {
                String tt = text1.getText();
                if (StringUtil.isNotEmpty((String)tt)) {
                    try {
                        int i = Integer.parseInt(tt);
                        return i == 555 ? new ValidationInfo("Wrong number", (JComponent)text1).asWarning() : null;
                    }
                    catch (NumberFormatException nex) {
                        return new ValidationInfo("Warning, expecting a number.", (JComponent)text1).asWarning();
                    }
                }
                return null;
            }).andRegisterOnDocumentListener((JTextComponent)text1).installOn((JComponent)text1);
            Dimension d = text1.getPreferredSize();
            text1.setPreferredSize(new Dimension(JBUIScale.scale((int)100), d.height));
            JTextField text2 = new JTextField();
            new ComponentValidator(this.getDisposable()).withHyperlinkListener(e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    System.out.println("Text2 link clicked. Desc = " + e.getDescription());
                }
            }).withValidator(() -> {
                String tt = text2.getText();
                return StringUtil.isEmpty((String)tt) || tt.length() < 5 ? new ValidationInfo("'" + tt + "': message is too short.<br/>Should contain at least 5 symbols. 8 is preferred <a href=\"#check.rules\">check rules.</a>", (JComponent)text2) : (tt.length() < 8 ? new ValidationInfo("'" + tt + "': message of 8 symbols is preferred", (JComponent)text2).asWarning() : null);
            }).andStartOnFocusLost().andRegisterOnDocumentListener((JTextComponent)text2).installOn((JComponent)text2);
            JCheckBox cb1 = new JCheckBox("Scroll tab layout");
            cb1.addActionListener(e -> this.pane.setTabLayoutPolicy(cb1.isSelected() ? 1 : 0));
            ++gc.gridy;
            topPanel.add((Component)UI.PanelFactory.panel((JComponent)cb1).withComment("Set tabbed pane tabs layout property to SCROLL_TAB_LAYOUT").createPanel(), gc);
            JCheckBox cb2 = new JCheckBox("Full border");
            cb2.addActionListener(e -> this.pane.putClientProperty("JTabbedPane.hasFullBorder", cb2.isSelected()));
            ++gc.gridy;
            topPanel.add((Component)UI.PanelFactory.panel((JComponent)cb2).withTooltip("Enable full border around the tabbed pane").createPanel(), gc);
            ++gc.gridy;
            JButton abracadabraButton = new JButton("Abracadabra");
            new HelpTooltip().setDescription(LONG_TEXT2).installOn((JComponent)abracadabraButton);
            topPanel.add((Component)UI.PanelFactory.panel((JComponent)abracadabraButton).resizeX(false).createPanel(), gc);
            try {
                new GotItTooltip("Abracadabda.button", GOT_IT_TEXT, (Disposable)this.project).withShowCount(3).withHeader(GOT_IT_HEADER).withIcon(AllIcons.General.BalloonInformation).withBrowserLink("Learn more", new URL("https://www.jetbrains.com/")).show((JComponent)abracadabraButton, GotItTooltip.BOTTOM_MIDDLE);
                new GotItTooltip("textfield", GOT_IT_TEXT2, (Disposable)this.project).withShowCount(5).show((JComponent)text1, GotItTooltip.BOTTOM_MIDDLE);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            JBScrollPane pane = new JBScrollPane((Component)this.createTable());
            pane.setPreferredSize((Dimension)JBUI.size((int)400, (int)300));
            pane.putClientProperty((Object)UIUtil.KEEP_BORDER_SIDES, (Object)15);
            BorderLayoutPanel mainPanel = JBUI.Panels.simplePanel((Component)UI.PanelFactory.panel((JComponent)pane).withLabel("Table label:").moveLabelOnTop().withComment("&lt;Project&gt; is content roots of all modules, all immediate descendants<br/>of the projects base directory, and .idea directory contents").resizeY(true).createPanel());
            mainPanel.addToTop((Component)topPanel);
            return mainPanel;
        }

        private JComponent createTable() {
            final String[] columns = new String[]{"First column", "Second column"};
            final String[][] data = new String[][]{{"one", "1"}, {"two", "2"}, {"three", "3"}, {"four", "4"}, {"five", "5"}, {"six", "6"}, {"seven", "7"}, {"eight", "8"}, {"nine", "9"}, {"ten", "10"}, {"eleven", "11"}, {"twelve", "12"}, {"thirteen", "13"}, {"fourteen", "14"}, {"fifteen", "15"}, {"sixteen", "16"}};
            JBTable table = new JBTable((TableModel)new DefaultTableModel(){

                @Override
                public String getColumnName(int column) {
                    return columns[column];
                }

                @Override
                public int getRowCount() {
                    return data.length;
                }

                @Override
                public int getColumnCount() {
                    return columns.length;
                }

                @Override
                public Object getValueAt(int row, int col) {
                    return col == 0 ? data[row][col] : Integer.valueOf(data[row][col]);
                }

                @Override
                public void setValueAt(Object value, int row, int col) {
                    if (col == 0 || col == 1) {
                        data[row][col] = value.toString();
                        this.fireTableCellUpdated(row, col);
                    }
                }
            });
            HyperlinkListener hyperlinkListener = e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    System.out.println("Table cell tooltip link clicked. Desc = " + e.getDescription());
                }
            };
            BiFunction<String, JComponent, ValidationInfo> validationInfoGenerator = (text, component) -> new ValidationInfo("Illegal value: " + text + " <a href=\"#check.cell.rules\">check rules.</a>", component);
            new CellTooltipManager(this.getDisposable()).withCellComponentProvider(CellComponentProvider.forTable((JTable)table)).withHyperlinkListener(hyperlinkListener).installOn((JComponent)table);
            ExtendableTextField cellEditor = new ExtendableTextField();
            ExtendableTextComponent.Extension browseExtension = ExtendableTextComponent.Extension.create((Icon)AllIcons.General.OpenDisk, (Icon)AllIcons.General.OpenDiskHover, (String)"Open file", (boolean)true, () -> System.out.println("Table browse clicked"));
            cellEditor.addExtension(browseExtension);
            cellEditor.putClientProperty((Object)"JComponent.compactHeight", (Object)Boolean.TRUE);
            new ComponentValidator(this.getDisposable()).withValidator(() -> {
                boolean isAllowed = ALLOWED_VALUES.contains(cellEditor.getText());
                ValidationUtils.setExtension((ExtendableTextComponent)cellEditor, (ExtendableTextComponent.Extension)ValidationUtils.ERROR_EXTENSION, (!isAllowed ? 1 : 0) != 0);
                return isAllowed ? null : (ValidationInfo)validationInfoGenerator.apply(cellEditor.getText(), (JComponent)cellEditor);
            }).withHyperlinkListener(hyperlinkListener).andRegisterOnDocumentListener((JTextComponent)cellEditor).installOn((JComponent)cellEditor);
            TableColumn col = table.getColumnModel().getColumn(0);
            col.setCellEditor(new DefaultCellEditor((JTextField)cellEditor));
            col.setCellRenderer((TableCellRenderer)new ValidatingTableCellRendererWrapper((TableCellRenderer)new DefaultTableCellRenderer()).bindToEditorSize(() -> cellEditor.getPreferredSize()).withCellValidator((value, row, column) -> value == null ? new ValidationInfo("Null value") : (ALLOWED_VALUES.contains(value.toString()) ? null : (ValidationInfo)validationInfoGenerator.apply(value.toString(), null))));
            ComboBox rightEditor = new ComboBox((Object[])((Integer[])Arrays.stream(data).map(i -> Integer.valueOf(i[1])).toArray(Integer[]::new)));
            col = table.getColumnModel().getColumn(1);
            col.setCellEditor((TableCellEditor)new StatefulValidatingCellEditor((JComboBox)rightEditor, this.getDisposable()));
            col.setCellRenderer((TableCellRenderer)new ValidatingTableCellRendererWrapper((TableCellRenderer)new ColoredTableCellRenderer(){
                {
                    this.setIpad((Insets)JBInsets.emptyInsets());
                }

                protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (value == null) {
                        this.append("No data", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    } else {
                        try {
                            int iv = Integer.parseInt(value.toString());
                            this.append("value ", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                            this.append(value.toString(), iv <= 8 ? SimpleTextAttributes.REGULAR_ATTRIBUTES : WARNING_CELL_ATTRIBUTES);
                        }
                        catch (NumberFormatException nfe) {
                            this.append(value.toString(), SimpleTextAttributes.ERROR_ATTRIBUTES);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$2", "customizeCellRenderer"));
                }
            }).bindToEditorSize(((JComboBox)rightEditor)::getPreferredSize).withCellValidator((value, row, column) -> {
                if (value == null) {
                    return NULL_VALUE_ERROR;
                }
                try {
                    int iv = Integer.parseInt(value.toString());
                    return iv <= 8 ? null : new ValidationInfo("Value " + String.valueOf(value) + " is not preferred").asWarning();
                }
                catch (NumberFormatException nfe) {
                    return NAN_VALUE_ERROR;
                }
            }));
            return table;
        }

        private JComponent createValidatorsPanel() {
            final TextFieldWithBrowseButton tfbb = new TextFieldWithBrowseButton(e -> System.out.println("JTextField browse button pressed"));
            new ComponentValidator(this.getDisposable()).withValidator(() -> tfbb.getText().length() < 50 ? new ValidationInfo(tfbb.getText() + " is too short. Enter at least 50 symbols", (JComponent)tfbb) : null).withOutlineProvider(ComponentValidator.CWBB_PROVIDER).andStartOnFocusLost().installOn((JComponent)tfbb);
            tfbb.getTextField().getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(this){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ComponentValidator.getInstance((JComponent)tfbb).ifPresent(ComponentValidator::revalidate);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$3", "textChanged"));
                }
            });
            EditorTextField editor = new EditorTextField();
            final ComponentWithBrowseButton etfbb = new ComponentWithBrowseButton((JComponent)editor, e -> System.out.println("JTextField browse button pressed"));
            new ComponentValidator(this.getDisposable()).withValidator(() -> {
                try {
                    new URL(((EditorTextField)etfbb.getChildComponent()).getDocument().getText());
                    return null;
                }
                catch (MalformedURLException mex) {
                    return new ValidationInfo("Enter a valid URL", (JComponent)etfbb);
                }
            }).withOutlineProvider(ComponentValidator.CWBB_PROVIDER).andStartOnFocusLost().installOn((JComponent)etfbb);
            ((EditorTextField)etfbb.getChildComponent()).getDocument().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull com.intellij.openapi.editor.event.DocumentEvent event) {
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    ComponentValidator.getInstance((JComponent)etfbb).ifPresent(ComponentValidator::revalidate);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$4", "documentChanged"));
                }
            });
            ComboBox comboBox = new ComboBox((Object[])STRING_VALUES);
            EditorComboBoxEditor cbEditor = new EditorComboBoxEditor(this.project, (FileType)FileTypes.PLAIN_TEXT);
            comboBox.setEditor((ComboBoxEditor)cbEditor);
            comboBox.addActionListener(l -> ComponentValidator.getInstance((JComponent)comboBox).ifPresent(ComponentValidator::revalidate));
            new ComponentValidator(this.getDisposable()).withValidator(() -> comboBox.getSelectedIndex() % 2 == 0 ? new ValidationInfo("Can't select odd items", (JComponent)comboBox) : null).installOn((JComponent)comboBox);
            final ExtendableTextComponent.Extension browseExtension = ExtendableTextComponent.Extension.create((Icon)AllIcons.General.OpenDisk, (Icon)AllIcons.General.OpenDiskHover, (String)"Open file", () -> System.out.println("Browse file clicked"));
            ComboBox eComboBox = new ComboBox((Object[])STRING_VALUES);
            final ComponentValidator eComboBoxValidator = new ComponentValidator(this.getDisposable()).withValidator(() -> {
                String text;
                Object item = eComboBox.getEditor().getItem();
                String string = text = item == null ? "" : item.toString();
                if (text.isBlank()) {
                    return new ValidationInfo("Blank lines are not supported", (JComponent)eComboBox);
                }
                if (text.contains("e")) {
                    return new ValidationInfo("Letter 'e' is prohibited", (JComponent)eComboBox);
                }
                return null;
            });
            eComboBoxValidator.installOn((JComponent)eComboBox);
            eComboBoxValidator.revalidate();
            eComboBox.addActionListener(event -> eComboBoxValidator.revalidate());
            eComboBox.setEditable(true);
            eComboBox.setEditor((ComboBoxEditor)new BasicComboBoxEditor(this){

                @Override
                protected JTextField createEditorComponent() {
                    ExtendableTextField ecbEditor = new ExtendableTextField();
                    ecbEditor.addExtension(browseExtension);
                    ecbEditor.setBorder(null);
                    ecbEditor.getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

                        protected void textChanged(@NotNull DocumentEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            eComboBoxValidator.revalidate();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$5$1", "textChanged"));
                        }
                    });
                    return ecbEditor;
                }
            });
            ComboBox animatedIconComboBox = new ComboBox();
            animatedIconComboBox.setEditable(true);
            animatedIconComboBox.setEditor((ComboBoxEditor)new BasicComboBoxEditor(this){

                @Override
                protected JTextField createEditorComponent() {
                    ExtendableTextField cbEditor = new ExtendableTextField();
                    cbEditor.addExtension(new ExtendableTextComponent.Extension(this){
                        private final Icon icon = new AnimatedIcon.FS();

                        public Icon getIcon(boolean hovered) {
                            return !hovered ? this.icon : AllIcons.Process.FS.Step_passive;
                        }

                        public String getTooltip() {
                            return "Refresh";
                        }
                    });
                    cbEditor.setEditable(false);
                    cbEditor.setBorder(null);
                    return cbEditor;
                }
            });
            return UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)tfbb).withLabel("Default directory:").withComment("Preselected in \"Open ...\" and \"New | Project\" dialogs")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)etfbb).withLabel("&EditorTextField:").withComment("EditorTextField with browse button")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)comboBox).withLabel("&ComboBoxEditorTextField:").withComment("EditorComboBox editor")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)eComboBox).withLabel("ComboBox &extendable:").withComment("ComboBox with ExtendableTextEditor")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)animatedIconComboBox).withLabel("&Animated combobox:").withComment("ComboBox with animated icon")).createPanel();
        }

        private JComponent createMultilinePanel() {
            JPanel panel2 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, (Insets)JBUI.insets((int)10, (int)0, (int)0, (int)4), 0, 0);
            panel2.add((Component)new JLabel("Label one:"), gc);
            ++gc.gridx;
            panel2.add((Component)new JCheckBox("<html>Multiline<br/>html<br/>checkbox</html>"), gc);
            ++gc.gridx;
            panel2.add((Component)new JCheckBox("<html>Single line html checkbox</html>"), gc);
            ++gc.gridx;
            panel2.add((Component)new JCheckBox("Single line checkbox"), gc);
            ++gc.gridx;
            panel2.add((Component)new JButton("Button 1"), gc);
            ++gc.gridy;
            gc.gridx = 0;
            panel2.add((Component)new JLabel("Label two:"), gc);
            ButtonGroup bg = new ButtonGroup();
            JRadioButton rb = new JRadioButton("<html>Multiline<br/>html<br/>radiobutton</html>");
            bg.add(rb);
            rb.setSelected(true);
            ++gc.gridx;
            panel2.add((Component)rb, gc);
            rb = new JRadioButton("<html>Single line html radiobutton</html>");
            bg.add(rb);
            ++gc.gridx;
            panel2.add((Component)rb, gc);
            rb = new JRadioButton("Single line radiobutton");
            bg.add(rb);
            ++gc.gridx;
            panel2.add((Component)rb, gc);
            ++gc.gridx;
            panel2.add((Component)new JButton("Button 2"), gc);
            ++gc.gridy;
            gc.gridx = 0;
            gc.anchor = 20;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.gridwidth = 5;
            panel2.add((Component)new JPanel(), gc);
            return JBUI.Panels.simplePanel().addToTop((Component)panel2);
        }

        private JComponent createProgressGridPanel() {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            JProgressBar pb1 = new JProgressBar(0, 100);
            JProgressBar pb2 = new JProgressBar(0, 100);
            this.progressTimerRequest = new ProgressTimerRequest(pb1);
            ProgressPanel progressPanel = ProgressPanel.getProgressPanel((JComponent)pb1);
            if (progressPanel != null) {
                progressPanel.setCommentText(Integer.toString(0));
            }
            panel2.add(UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)pb1).withLabel("Label 1.1").withCancel(() -> this.myAlarm.cancelRequest((Runnable)this.progressTimerRequest)).andCancelText("Stop")).add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)pb2).withLabel("Label 1.2").withPause(() -> System.out.println("Pause action #2")).withResume(() -> System.out.println("Resume action #2"))).resize().createPanel());
            Objects.requireNonNull(ProgressPanel.getProgressPanel((JComponent)pb1)).setCommentText("Long long long long long long long text");
            Objects.requireNonNull(ProgressPanel.getProgressPanel((JComponent)pb2)).setCommentText("Short text");
            JProgressBar pb3 = new JProgressBar(0, 100);
            JProgressBar pb4 = new JProgressBar(0, 100);
            panel2.add(UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)pb3).withLabel("Label 2.1").moveLabelLeft().withCancel(() -> System.out.println("Cancel action #3"))).add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)pb4).withTopSeparator().withLabel("Label 2.2").moveLabelLeft().withPause(() -> System.out.println("Pause action #4")).withResume(() -> System.out.println("Resume action #4"))).resize().createPanel());
            Objects.requireNonNull(ProgressPanel.getProgressPanel((JComponent)pb3)).setCommentText("Long long long long long long text");
            Objects.requireNonNull(ProgressPanel.getProgressPanel((JComponent)pb4)).setCommentText("Short text");
            panel2.add(UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)new JProgressBar(0, 100)).withTopSeparator().withoutComment().andCancelAsButton().withCancel(() -> System.out.println("Cancel action #11"))).createPanel());
            return JBUI.Panels.simplePanel().addToTop((Component)panel2);
        }

        private JComponent createToolbar(@NotNull JComponent toolbarTarget) {
            if (toolbarTarget == null) {
                ComponentPanelTest.$$$reportNull$$$0(1);
            }
            final boolean[] enabledArray = new boolean[3];
            Arrays.fill(enabledArray, true);
            AnAction[] actionsArray = new AnAction[]{new MyAction("Play", AllIcons.Actions.Execute){

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    e.getPresentation().setEnabled(enabledArray[0]);
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                    if (actionUpdateThread == null) {
                        7.$$$reportNull$$$0(1);
                    }
                    return actionUpdateThread;
                }

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        7.$$$reportNull$$$0(2);
                    }
                    if (--counter == 0) {
                        enabledArray[0] = false;
                    }
                    System.out.println(e.getPresentation().getDescription() + ", counter = " + counter);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$7";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$7";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "update";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "actionPerformed";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            }, new MyAction("Stop", AllIcons.Actions.Suspend){

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    e.getPresentation().setEnabled(enabledArray[1]);
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                    if (actionUpdateThread == null) {
                        8.$$$reportNull$$$0(1);
                    }
                    return actionUpdateThread;
                }

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        8.$$$reportNull$$$0(2);
                    }
                    counter = 5;
                    enabledArray[0] = true;
                    System.out.println(e.getPresentation().getDescription() + ", counter = " + counter);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$8";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$8";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "update";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "actionPerformed";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            }, new MyToggleAction(this, "Mute", AllIcons.Debugger.MuteBreakpoints){

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    e.getPresentation().setEnabled(enabledArray[2]);
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                    if (actionUpdateThread == null) {
                        9.$$$reportNull$$$0(1);
                    }
                    return actionUpdateThread;
                }

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        9.$$$reportNull$$$0(2);
                    }
                    boolean bl = this.selected = !this.selected;
                    if (this.selected) {
                        System.out.println("Unmute buttons");
                        enabledArray[0] = true;
                        enabledArray[1] = true;
                    } else {
                        System.out.println("Mute buttons");
                        enabledArray[0] = false;
                        enabledArray[1] = false;
                    }
                    Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)this.selected);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$9";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$9";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "update";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "actionPerformed";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            }};
            DefaultActionGroup actions = DefaultActionGroup.createFlatGroup(() -> "Simple group");
            actions.addAll(actionsArray);
            DefaultActionGroup subActions = DefaultActionGroup.createPopupGroup(() -> "Ratings");
            subActions.getTemplatePresentation().setIcon(AllIcons.Ide.Rating);
            subActions.addAll(new AnAction[]{new MyAction("Rating one", AllIcons.Ide.Rating1).withDefaultDescription(), new MyAction("Rating two", AllIcons.Ide.Rating2).withDefaultDescription(), new MyAction("Rating three", AllIcons.Ide.Rating3).withDefaultDescription(), new MyAction("Rating four", AllIcons.Ide.Rating4).withDefaultDescription()});
            actions.add((AnAction)subActions);
            DefaultActionGroup toolbarActions = new DefaultActionGroup();
            toolbarActions.add((AnAction)new SplitButtonAction((ActionGroup)actions));
            toolbarActions.add((AnAction)new MyAction("Short", AllIcons.Ide.Rating1){
                {
                    super(name, icon);
                    GotItTooltip actionGotIt = new GotItTooltip("short.action", "Short action text", (Disposable)project).withHeader("Header");
                    actionGotIt.assignTo(this.getTemplatePresentation(), GotItTooltip.BOTTOM_MIDDLE);
                }
            }.withShortCut("control K"));
            toolbarActions.add((AnAction)new MyAction("Long", AllIcons.Ide.Rating2).withShortCut("control N"));
            toolbarActions.add((AnAction)new MyAction(null, AllIcons.Ide.Rating3).withShortCut("control P"));
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("TOP", (ActionGroup)toolbarActions, true);
            toolbar.setTargetComponent(toolbarTarget);
            JComponent toolbarComponent = toolbar.getComponent();
            toolbarComponent.setBorder(IdeBorderFactory.createBorder((int)8));
            return toolbarComponent;
        }

        private JComponent createJSliderTab() {
            JPanel panel2 = new JPanel((LayoutManager)new MigLayout("fillx, ins 0, gap 10, flowy"));
            JSlider hSlider = new JSlider(0){

                @Override
                public void updateUI() {
                    this.setUI((SliderUI)DarculaSliderUI.createUI((JComponent)this));
                    this.updateLabelUIs();
                }
            };
            JSlider vSlider = new JSlider(1){

                @Override
                public void updateUI() {
                    this.setUI((SliderUI)DarculaSliderUI.createUI((JComponent)this));
                    this.updateLabelUIs();
                }
            };
            JSlider hSliderBase = new JSlider(0);
            JPanel pane1 = new JPanel((LayoutManager)new MigLayout("fillx, debug, ins 0, gap 5"));
            pane1.add((Component)new JLabel("A color key and IntelliJ: "), "baseline");
            pane1.add((Component)hSliderBase, "baseline");
            this.setupSlider(hSlider);
            this.setupSlider(vSlider);
            this.setupSlider(hSliderBase);
            panel2.add((Component)this.wrap(hSlider), "growx");
            panel2.add((Component)this.wrap(hSliderBase), "growx");
            panel2.add(this.wrap(vSlider));
            return panel2;
        }

        @NotNull
        private JComponent createComboBoxTab() {
            JPanel pane = new JPanel((LayoutManager)new MigLayout("fillx, debug, novisualpadding, ins 0, gap 5"));
            pane.add((Component)new JLabel("Shows a combobox with custom JBPopup and multiple layers of items"), "baseline, wrap");
            ImmutableList.Builder builder2 = ImmutableList.builder();
            final class Item {
                final Icon myIcon;
                final String myText;
                final List<Item> myChildren;

                Item(@NotNull ComponentPanelTest this$0, @NlsContexts.ListItem @NotNull Icon icon, String text) {
                    if (icon == null) {
                        Item.$$$reportNull$$$0(0);
                    }
                    if (text == null) {
                        Item.$$$reportNull$$$0(1);
                    }
                    this(this$0, icon, text, (List<? extends Item>)ImmutableList.of());
                }

                Item(@NotNull ComponentPanelTest this$0, @NlsContexts.ListItem @NotNull Icon icon, @NotNull String text, List<? extends Item> myChildren) {
                    if (icon == null) {
                        ? extends com_intellij_internal_ui_ComponentPanelTestAction$ComponentPanelTest$1Item.$$$reportNull$$$0(2);
                    }
                    if (text == null) {
                        ? extends com_intellij_internal_ui_ComponentPanelTestAction$ComponentPanelTest$1Item.$$$reportNull$$$0(3);
                    }
                    if (myChildren == null) {
                        ? extends com_intellij_internal_ui_ComponentPanelTestAction$ComponentPanelTest$1Item.$$$reportNull$$$0(4);
                    }
                    this.myIcon = icon;
                    this.myText = text;
                    this.myChildren = List.copyOf(myChildren);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "icon";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[0] = "text";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[0] = "myChildren";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$1Item";
                    objectArray[2] = "<init>";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
            builder2.add((Object)new Item(this, AllIcons.General.Add, "Add"));
            builder2.add((Object)new Item(this, AllIcons.General.ArrowDown, "ArrowDown"));
            builder2.add((Object)new Item(this, AllIcons.General.Balloon, "Balloon"));
            builder2.add((Object)new Item(this, AllIcons.General.Filter, "Filter"));
            builder2.add((Object)new Item(this, AllIcons.General.Remove, "Remove"));
            ImmutableList level2 = builder2.build();
            ImmutableList.Builder builder1 = ImmutableList.builder();
            builder1.add((Object)new Item(this, AllIcons.Icons.Ide.NextStep, "Next"));
            builder1.add((Object)new Item(this, AllIcons.Vcs.Patch_applied, "Patch"));
            builder1.add((Object)new Item(this, AllIcons.General.Settings, "SubList", (List<? extends Item>)level2));
            builder1.add((Object)new Item(this, AllIcons.General.Remove, "Remove"));
            final class Model
            extends DefaultComboBoxModel<Item>
            implements ComboBoxPopupState<Item> {
                Model(List<Item> items) {
                    super(items.toArray(new Item[0]));
                }

                @Nullable
                public ListModel<Item> onChosen(Item selectedValue) {
                    if (selectedValue.myChildren.isEmpty()) {
                        return null;
                    }
                    return new Model(selectedValue.myChildren);
                }

                public boolean hasSubstep(Item selectedValue) {
                    return !selectedValue.myChildren.isEmpty();
                }
            }
            ComboBox comboBox = new ComboBox((ComboBoxModel)new Model((List<Item>)builder1.build()));
            comboBox.setSwingPopup(false);
            ColoredListCellRenderer<Item> renderer = new ColoredListCellRenderer<Item>(){

                protected void customizeCellRenderer(@NotNull JList<? extends Item> list, Item value, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        13.$$$reportNull$$$0(0);
                    }
                    this.setIcon(value.myIcon);
                    this.append(value.myText);
                    this.append(" ");
                    this.append("this text is gray", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    this.append(" ");
                    this.append("error", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    if (!value.myChildren.isEmpty()) {
                        this.append(" ->");
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$13", "customizeCellRenderer"));
                }
            };
            comboBox.setRenderer((ListCellRenderer)renderer);
            pane.add((Component)new JLabel("The ComboBox:"), "baseline");
            pane.add((Component)comboBox, "baseline");
            JPanel jPanel = pane;
            if (jPanel == null) {
                ComponentPanelTest.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        private JComponent wrap(JComponent component) {
            JPanel pane = new JPanel((LayoutManager)new MigLayout("fillx, debug, novisualpadding, ins 0, gap 5", "[min!][]"));
            pane.add((Component)new JLabel("A color key and IntelliJ: "), "baseline");
            pane.add((Component)component, "baseline, growx");
            return pane;
        }

        private void setupSlider(JSlider slider) {
            slider.setMajorTickSpacing(25);
            slider.setMinorTickSpacing(5);
            slider.setPaintTicks(true);
            slider.setPaintLabels(true);
            slider.setSnapToTicks(true);
            Hashtable<Integer, JLabel> position = new Hashtable<Integer, JLabel>();
            position.put(0, new JLabel("Hashtable"));
            position.put(25, new JLabel("Hash"));
            position.put(50, new JLabel("Ha"));
            position.put(75, new JLabel("HashtableHashtable"));
            position.put(100, new JLabel("100"));
            slider.setLabelTable(position);
        }

        private /* synthetic */ void lambda$createCenterPanel$2(JComboBox placementCombo, ActionEvent e) {
            Placement p = (Placement)((Object)placementCombo.getSelectedItem());
            if (p != null) {
                this.pane.setTabPlacement(p.placement());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolbarTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCenterPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComboBoxTab";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createToolbar";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }

        private final class ProgressTimerRequest
        implements Runnable {
            private final JProgressBar myProgressBar;

            private ProgressTimerRequest(JProgressBar progressBar) {
                this.myProgressBar = progressBar;
            }

            @Override
            public void run() {
                if (this.canPlay()) {
                    int v = this.myProgressBar.getValue() + 1;
                    if (v > this.myProgressBar.getMaximum()) {
                        v = this.myProgressBar.getMinimum();
                    }
                    this.myProgressBar.setValue(v);
                    ProgressPanel progressPanel = ProgressPanel.getProgressPanel((JComponent)this.myProgressBar);
                    if (progressPanel != null) {
                        progressPanel.setCommentText(Integer.toString(v));
                    }
                    ComponentPanelTest.this.myAlarm.addRequest((Runnable)this, 200, ModalityState.any());
                }
            }

            private boolean canPlay() {
                ProgressPanel progressPanel = ProgressPanel.getProgressPanel((JComponent)this.myProgressBar);
                return progressPanel != null && progressPanel.getState() == ProgressPanel.State.PLAYING;
            }
        }
    }

    private static class MyToggleAction
    extends MyAction
    implements Toggleable {
        protected boolean selected;

        private MyToggleAction(String name, Icon icon) {
            super(name, icon);
        }
    }

    private static class MyAction
    extends DumbAwareAction {
        private MyAction(@Nullable @NlsActions.ActionText String name, @Nullable Icon icon) {
            super(name, null, icon);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAction.$$$reportNull$$$0(0);
            }
            System.out.println(e.getPresentation().getDescription());
        }

        public MyAction withDefaultDescription() {
            this.getTemplatePresentation().setDescription(this.getTemplateText() + " description");
            return this;
        }

        public MyAction withDescription(@Nullable @NlsActions.ActionDescription String description) {
            this.getTemplatePresentation().setDescription(description);
            return this;
        }

        public MyAction withShortCut(@NotNull String shortCut) {
            if (shortCut == null) {
                MyAction.$$$reportNull$$$0(1);
            }
            this.setShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{shortCut}));
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shortCut";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/ui/ComponentPanelTestAction$MyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withShortCut";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum Placement {
        Top(1, "Top"),
        Bottom(3, "Bottom"),
        Left(2, "Left"),
        Right(4, "Right");

        private final String name;
        private final int placement;

        private Placement(int placement, String name) {
            this.name = name;
            this.placement = placement;
        }

        public String toString() {
            return this.name;
        }

        public int placement() {
            return this.placement;
        }
    }
}

