/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ui;

import com.intellij.internal.statistic.eventLog.util.StringUtil;
import com.intellij.internal.ui.JEditorPaneDemoAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00058\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/ui/JEditorPaneDemoAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "PREFERENCE_KEY", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "DEFAULT_HTML", "intellij.platform.ide.internal"})
public final class JEditorPaneDemoAction
extends DumbAwareAction {
    @NotNull
    private final String PREFERENCE_KEY;
    @Language(value="HTML")
    @NotNull
    private final String DEFAULT_HTML;

    public JEditorPaneDemoAction() {
        super("HTML Rendering Playground");
        this.PREFERENCE_KEY = "HTML_RENDERING_PLAYGROUND";
        this.DEFAULT_HTML = "<html>\n<head>\n    <style type=\"text/css\">\n        body {\n            margin: 10px;\n            background: #C0C0C0;\n            color: #333333;\n        }\n\n        code {\n            background-color: #eeee11;\n            margin: 4px;\n        }\n\n        pre {\n            padding: 10px;\n        }\n    </style>\n</head>\n<body>\n<h1>This is HTML rendering demo.</h1>\nSome key features are supported:\n<ol>\n    <li>Of course <i>Italic</i> & <b>bold</b></li>\n    <li>Not so often used <sub>subscript</sub> <strike>strikethrough</strike> and <sup>superscript</sup>\n    <li>Tags <small>small</small> and <strong>strong</strong>. And <u>underlined</u> too.</li>\n    <li><a href=\"https://www.jetbrains.com/\">External links</a></li>\n    <li>This is <code>@Code</code> tag to be <code>highlighted</code></li>\n    <li>Emoji etc. if you are lucky enough to see it <span style=\"color:red;\">[&#9829;]</span>[&#128512;]</li>\n</ol>\nThe tag below is &lt;pre&gt;:\n<pre style=\"background-color:white;color:black;\">\nclass HelloWorld {\n    public static void main(String[] args) {\n        System.out.println(\"Hello World!\");\n    }\n}</pre>\n<ul>\n    <li>User-friendly link <a href=\"https://docs.oracle.com/en/java/javase/11/docs/api/java.desktop/javax/swing/text/html/CSS.html\">\n        CSS support in Java engine</a></li>\n    <li>Not so user-friendly link <a href=\"https://docs.oracle.com/en/java/javase/11/docs/api/java.desktop/javax/swing/text/html/CSS.html\">\n        https://docs.oracle.com/en/java/javase/11/docs/api/java.desktop/javax/swing/text/html/CSS.html</a></li>\n</ul>\n<p>\n<div style=\"color:white;background-color:#909090; border:solid 1px #fedcba; text-align:center;\">Outer div\n    <div style=\"background-color:#606060; width:50%; margin:20px;padding:11px; border:solid 1px orange;\">Inner div with width 50%</div>\n</div>\n</p><br>\n<p>\n    Well, we can do something with it...</p>\n</body>\n</html>";
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        DialogWrapper.IdeModalityType ideModalityType = DialogWrapper.IdeModalityType.IDE;
        new DialogWrapper(this, e, project, ideModalityType){
            private final JEditorPane myView;
            private final Editor myEditor;
            {
                EditorFactory editorFactory;
                this.myView = new JEditorPane();
                this.setTitle("HTML Rendering Playground");
                this.setResizable(true);
                this.myView.setContentType("text/html");
                this.myView.setEditable(false);
                this.myView.setEditorKit(HTMLEditorKitBuilder.Companion.simple());
                this.myView.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
                UIUtil.doNotScrollToCaret((JTextComponent)this.myView);
                String html = Preferences.userRoot().get(JEditorPaneDemoAction.access$getPREFERENCE_KEY$p($receiver), "");
                if (StringUtil.isEmpty((String)html)) {
                    html = JEditorPaneDemoAction.access$getDEFAULT_HTML$p($receiver);
                }
                EditorFactory editorFactory2 = editorFactory = EditorFactory.getInstance();
                Intrinsics.checkNotNull((Object)editorFactory2);
                Document document = editorFactory2.createDocument((CharSequence)html);
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
                Document editorDocument = document;
                FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension("html");
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByExtension(...)");
                FileType htmlFileType = fileType;
                FileDocumentManagerBase.registerDocument((Document)editorDocument, (VirtualFile)((VirtualFile)new LightVirtualFile(this.getTitle() + ".html", htmlFileType, (CharSequence)html)));
                Editor editor = editorFactory.createEditor(editorDocument, $e.getProject(), htmlFileType, false);
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"createEditor(...)");
                this.myEditor = editor;
                EditorSettings editorSettings = this.myEditor.getSettings();
                Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"getSettings(...)");
                EditorSettings settings = editorSettings;
                settings.setLineNumbersShown(false);
                settings.setWhitespacesShown(true);
                settings.setLineMarkerAreaShown(false);
                settings.setIndentGuidesShown(false);
                settings.setAdditionalColumnsCount(0);
                settings.setAdditionalLinesCount(0);
                settings.setRightMarginShown(false);
                settings.setRightMargin(60);
                settings.setGutterIconsShown(false);
                settings.setIndentGuidesShown(false);
                EditorGutterComponentEx editorGutterComponentEx = (EditorGutterComponentEx)this.myEditor.getGutter();
                Intrinsics.checkNotNull((Object)editorGutterComponentEx);
                editorGutterComponentEx.setPaintBackground(false);
                editorDocument.addDocumentListener(new DocumentListener(this, $receiver){
                    final /* synthetic */ actionPerformed.1 this$0;
                    final /* synthetic */ JEditorPaneDemoAction this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                    }

                    public void documentChanged(DocumentEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        try {
                            this.this$0.getMyView().setText(event.getDocument().getText());
                            Preferences.userRoot().put(JEditorPaneDemoAction.access$getPREFERENCE_KEY$p(this.this$1), event.getDocument().getText());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                this.myView.setText(this.myEditor.getDocument().getText());
                this.init();
            }

            public final JEditorPane getMyView() {
                return this.myView;
            }

            public final Editor getMyEditor() {
                return this.myEditor;
            }

            protected DialogWrapper.DialogStyle getStyle() {
                return DialogWrapper.DialogStyle.COMPACT;
            }

            protected String getDimensionServiceKey() {
                return "HTMLRenderingPlayground";
            }

            protected JComponent createCenterPanel() {
                OnePixelSplitter splitter = new OnePixelSplitter(false, 0.33f, 0.18f, 0.82f);
                splitter.setSplitterProportionKey("HTMLRenderingPlayground.Splitter");
                splitter.setFirstComponent((JComponent)new JBScrollPane((Component)this.myEditor.getComponent()));
                splitter.setSecondComponent((JComponent)new JBScrollPane((Component)this.myView));
                return (JComponent)splitter;
            }

            protected Action[] createActions() {
                return new Action[0];
            }
        }.show();
    }

    public static final /* synthetic */ String access$getPREFERENCE_KEY$p(JEditorPaneDemoAction $this) {
        return $this.PREFERENCE_KEY;
    }

    public static final /* synthetic */ String access$getDEFAULT_HTML$p(JEditorPaneDemoAction $this) {
        return $this.DEFAULT_HTML;
    }
}

