/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.idea.LoggerFactory;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class OpenLogAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OpenLogAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenLogAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            OpenLogAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        OpenLogAction.openLogInEditor(project);
    }

    public static void openLogInEditor(@NotNull Project project) {
        VirtualFile file;
        if (project == null) {
            OpenLogAction.$$$reportNull$$$0(3);
        }
        if ((file = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(LoggerFactory.getLogFilePath())) != null) {
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{file});
            FileEditor[] editors = FileEditorManager.getInstance((Project)project).openFile(file, true);
            if (editors.length > 0 && editors[0] instanceof TextEditor) {
                OpenLogAction.scrollToLastIDEStart((TextEditor)editors[0]);
            } else {
                PsiNavigationSupport.getInstance().createNavigatable(project, file, -1).navigate(true);
            }
        } else {
            String title = "Cannot find '" + String.valueOf(LoggerFactory.getLogFilePath()) + "'";
            Notifications.Bus.notify((Notification)new Notification("System Messages", title, "", NotificationType.INFORMATION));
        }
    }

    private static void scrollToLastIDEStart(TextEditor editor) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                byte[] bytes = editor.getFile().contentsToByteArray(true);
                String log = new String(bytes, StandardCharsets.UTF_8);
                int index = log.lastIndexOf("------------------------------------------------------ IDE STARTED ------------------------------------------------------");
                if (index != -1) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        editor.getEditor().getCaretModel().moveToOffset(index);
                        editor.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER_UP);
                    }, x -> editor.getEditor().isDisposed());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/OpenLogAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/OpenLogAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openLogInEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

