/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml;

import com.intellij.internal.ml.Feature;
import com.intellij.internal.ml.FeatureMapper;
import com.intellij.internal.ml.InconsistentMetadataException;
import com.intellij.internal.ml.UndefinedMapper;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001&BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0016J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u0019\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007H\u00c6\u0003J\u0019\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u000bH\u00c6\u0003J[\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u00072\u0018\b\u0002\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u00072\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010 \u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006'"}, d2={"Lcom/intellij/internal/ml/BinaryFeature;", "Lcom/intellij/internal/ml/Feature;", "name", "", "firstValueMapping", "Lkotlin/Pair;", "", "Lcom/intellij/internal/ml/ValueMapping;", "secondValueMapping", "defaultValue", "allowUndefined", "", "<init>", "(Ljava/lang/String;Lkotlin/Pair;Lkotlin/Pair;DZ)V", "getName", "()Ljava/lang/String;", "getFirstValueMapping", "()Lkotlin/Pair;", "getSecondValueMapping", "getDefaultValue", "()D", "getAllowUndefined", "()Z", "createMapper", "Lcom/intellij/internal/ml/FeatureMapper;", "suffix", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "BinaryMapper", "intellij.platform.ide.internal"})
public final class BinaryFeature
extends Feature {
    @NotNull
    private final String name;
    @NotNull
    private final Pair<String, Double> firstValueMapping;
    @NotNull
    private final Pair<String, Double> secondValueMapping;
    private final double defaultValue;
    private final boolean allowUndefined;

    public BinaryFeature(@NotNull String name, @NotNull Pair<String, Double> firstValueMapping, @NotNull Pair<String, Double> secondValueMapping, double defaultValue, boolean allowUndefined) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(firstValueMapping, (String)"firstValueMapping");
        Intrinsics.checkNotNullParameter(secondValueMapping, (String)"secondValueMapping");
        super(null);
        this.name = name;
        this.firstValueMapping = firstValueMapping;
        this.secondValueMapping = secondValueMapping;
        this.defaultValue = defaultValue;
        this.allowUndefined = allowUndefined;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Pair<String, Double> getFirstValueMapping() {
        return this.firstValueMapping;
    }

    @NotNull
    public final Pair<String, Double> getSecondValueMapping() {
        return this.secondValueMapping;
    }

    public final double getDefaultValue() {
        return this.defaultValue;
    }

    public final boolean getAllowUndefined() {
        return this.allowUndefined;
    }

    @Override
    @NotNull
    public FeatureMapper createMapper(@Nullable String suffix) {
        FeatureMapper featureMapper;
        String string = suffix;
        if (Intrinsics.areEqual((Object)string, (Object)"UNDEFINED")) {
            featureMapper = UndefinedMapper.Companion.checkAndCreate(this.getName(), this.allowUndefined);
        } else if (string == null) {
            featureMapper = new BinaryMapper();
        } else {
            throw new InconsistentMetadataException("Unexpected binary feature suffix: " + suffix + " (feature '" + this.getName() + "')");
        }
        return featureMapper;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Pair<String, Double> component2() {
        return this.firstValueMapping;
    }

    @NotNull
    public final Pair<String, Double> component3() {
        return this.secondValueMapping;
    }

    public final double component4() {
        return this.defaultValue;
    }

    public final boolean component5() {
        return this.allowUndefined;
    }

    @NotNull
    public final BinaryFeature copy(@NotNull String name, @NotNull Pair<String, Double> firstValueMapping, @NotNull Pair<String, Double> secondValueMapping, double defaultValue, boolean allowUndefined) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(firstValueMapping, (String)"firstValueMapping");
        Intrinsics.checkNotNullParameter(secondValueMapping, (String)"secondValueMapping");
        return new BinaryFeature(name, firstValueMapping, secondValueMapping, defaultValue, allowUndefined);
    }

    public static /* synthetic */ BinaryFeature copy$default(BinaryFeature binaryFeature, String string, Pair pair, Pair pair2, double d, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = binaryFeature.name;
        }
        if ((n & 2) != 0) {
            pair = binaryFeature.firstValueMapping;
        }
        if ((n & 4) != 0) {
            pair2 = binaryFeature.secondValueMapping;
        }
        if ((n & 8) != 0) {
            d = binaryFeature.defaultValue;
        }
        if ((n & 0x10) != 0) {
            bl = binaryFeature.allowUndefined;
        }
        return binaryFeature.copy(string, pair, pair2, d, bl);
    }

    @NotNull
    public String toString() {
        return "BinaryFeature(name=" + this.name + ", firstValueMapping=" + this.firstValueMapping + ", secondValueMapping=" + this.secondValueMapping + ", defaultValue=" + this.defaultValue + ", allowUndefined=" + this.allowUndefined + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.firstValueMapping.hashCode();
        result = result * 31 + this.secondValueMapping.hashCode();
        result = result * 31 + Double.hashCode(this.defaultValue);
        result = result * 31 + Boolean.hashCode(this.allowUndefined);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BinaryFeature)) {
            return false;
        }
        BinaryFeature binaryFeature = (BinaryFeature)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)binaryFeature.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.firstValueMapping, binaryFeature.firstValueMapping)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.secondValueMapping, binaryFeature.secondValueMapping)) {
            return false;
        }
        if (Double.compare(this.defaultValue, binaryFeature.defaultValue) != 0) {
            return false;
        }
        return this.allowUndefined == binaryFeature.allowUndefined;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u0006H\u0016J\u0012\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/ml/BinaryFeature$BinaryMapper;", "Lcom/intellij/internal/ml/FeatureMapper;", "<init>", "(Lcom/intellij/internal/ml/BinaryFeature;)V", "firstMappingLowercase", "Lkotlin/Pair;", "", "", "Lcom/intellij/internal/ml/ValueMapping;", "getFirstMappingLowercase", "()Lkotlin/Pair;", "secondMappingLowercase", "getSecondMappingLowercase", "getFeatureName", "asArrayValue", "value", "", "intellij.platform.ide.internal"})
    private final class BinaryMapper
    implements FeatureMapper {
        @NotNull
        private final Pair<String, Double> firstMappingLowercase;
        @NotNull
        private final Pair<String, Double> secondMappingLowercase;

        public BinaryMapper() {
            String string = ((String)BinaryFeature.this.getFirstValueMapping().getFirst()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            this.firstMappingLowercase = new Pair((Object)string, BinaryFeature.this.getFirstValueMapping().getSecond());
            String string2 = ((String)BinaryFeature.this.getSecondValueMapping().getFirst()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            this.secondMappingLowercase = new Pair((Object)string2, BinaryFeature.this.getSecondValueMapping().getSecond());
        }

        @NotNull
        public final Pair<String, Double> getFirstMappingLowercase() {
            return this.firstMappingLowercase;
        }

        @NotNull
        public final Pair<String, Double> getSecondMappingLowercase() {
            return this.secondMappingLowercase;
        }

        @Override
        @NotNull
        public String getFeatureName() {
            return BinaryFeature.this.getName();
        }

        @Override
        public double asArrayValue(@Nullable Object value) {
            String string = String.valueOf(value).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String string2 = string;
            return Intrinsics.areEqual((Object)string2, (Object)this.firstMappingLowercase.getFirst()) ? ((Number)this.firstMappingLowercase.getSecond()).doubleValue() : (Intrinsics.areEqual((Object)string2, (Object)this.secondMappingLowercase.getFirst()) ? ((Number)this.secondMappingLowercase.getSecond()).doubleValue() : BinaryFeature.this.getDefaultValue());
        }
    }
}

