/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml.completion;

import com.intellij.internal.ml.DecisionFunction;
import com.intellij.internal.ml.FeatureMapper;
import com.intellij.internal.ml.FeaturesInfo;
import com.intellij.internal.ml.InconsistentMetadataException;
import com.intellij.internal.ml.ModelMetadata;
import com.intellij.internal.ml.ResourcesModelMetadataReader;
import com.intellij.internal.ml.completion.RankingModelProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H$J\b\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/internal/ml/completion/JarCompletionModelProvider;", "Lcom/intellij/internal/ml/completion/RankingModelProvider;", "displayName", "", "resourceDirectory", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "lazyModel", "Lcom/intellij/internal/ml/DecisionFunction;", "getLazyModel", "()Lcom/intellij/internal/ml/DecisionFunction;", "lazyModel$delegate", "Lkotlin/Lazy;", "getModel", "getDisplayNameInSettings", "createModel", "metadata", "Lcom/intellij/internal/ml/ModelMetadata;", "assertModelMetadataConsistent", "", "intellij.platform.ide.internal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nJarCompletionModelProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JarCompletionModelProvider.kt\ncom/intellij/internal/ml/completion/JarCompletionModelProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,45:1\n1#2:46\n11561#3:47\n11896#3,3:48\n*S KotlinDebug\n*F\n+ 1 JarCompletionModelProvider.kt\ncom/intellij/internal/ml/completion/JarCompletionModelProvider\n*L\n34#1:47\n34#1:48,3\n*E\n"})
public abstract class JarCompletionModelProvider
implements RankingModelProvider {
    @NotNull
    private final String displayName;
    @NotNull
    private final String resourceDirectory;
    @NotNull
    private final Lazy lazyModel$delegate;

    public JarCompletionModelProvider(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String displayName, @NonNls @NotNull String resourceDirectory) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)resourceDirectory, (String)"resourceDirectory");
        this.displayName = displayName;
        this.resourceDirectory = resourceDirectory;
        this.lazyModel$delegate = LazyKt.lazy(() -> JarCompletionModelProvider.lazyModel_delegate$lambda$0(this));
    }

    private final DecisionFunction getLazyModel() {
        Lazy lazy = this.lazyModel$delegate;
        return (DecisionFunction)lazy.getValue();
    }

    @Override
    @NotNull
    public DecisionFunction getModel() {
        return this.getLazyModel();
    }

    @Override
    @NotNull
    public String getDisplayNameInSettings() {
        return this.displayName;
    }

    @NotNull
    protected abstract DecisionFunction createModel(@NotNull ModelMetadata var1);

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public final void assertModelMetadataConsistent() {
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            FeatureMapper[] featuresOrder;
            DecisionFunction decisionFunction = this.getModel();
            decisionFunction.version();
            List<String> list = decisionFunction.getUnknownFeatures((Collection<String>)decisionFunction.getRequiredFeatures());
            Intrinsics.checkNotNullExpressionValue(list, (String)"getUnknownFeatures(...)");
            List<String> unknownRequiredFeatures = list;
            boolean bl = unknownRequiredFeatures.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-JarCompletionModelProvider$assertModelMetadataConsistent$32 = false;
                String $i$a$-assert-JarCompletionModelProvider$assertModelMetadataConsistent$32 = "All required features should be known, but " + unknownRequiredFeatures + " unknown";
                throw new AssertionError((Object)$i$a$-assert-JarCompletionModelProvider$assertModelMetadataConsistent$32);
            }
            FeatureMapper[] featureMapperArray = decisionFunction.getFeaturesOrder();
            Intrinsics.checkNotNullExpressionValue((Object)featureMapperArray, (String)"getFeaturesOrder(...)");
            FeatureMapper[] featureMapperArray2 = featuresOrder = featureMapperArray;
            DecisionFunction decisionFunction2 = decisionFunction;
            boolean $i$f$map = false;
            void var8_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var14_20 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getFeatureName());
            }
            List<String> list2 = decisionFunction2.getUnknownFeatures(CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getUnknownFeatures(...)");
            List<String> unknownUsedFeatures = list2;
            boolean bl3 = unknownUsedFeatures.isEmpty();
            if (_Assertions.ENABLED && !bl3) {
                boolean bl4 = false;
                String string = "All used features should be known, but " + unknownUsedFeatures + " unknown";
                throw new AssertionError((Object)string);
            }
            double[] features = new double[featuresOrder.length];
            decisionFunction.predict(features);
        }
        catch (InconsistentMetadataException e) {
            throw new AssertionError("Model metadata inconsistent", e);
        }
    }

    private static final DecisionFunction lazyModel_delegate$lambda$0(JarCompletionModelProvider this$0) {
        FeaturesInfo metadata = FeaturesInfo.Companion.buildInfo(new ResourcesModelMetadataReader(this$0.getClass(), this$0.resourceDirectory));
        return this$0.createModel(metadata);
    }
}

