/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.advanced.AdvancedSettingBean;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.advanced.AdvancedSettingsImpl;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class RegistryApplicationUsagesCollector
extends ApplicationUsagesCollector {
    public static final String DISABLE_INTELLIJ_PROJECT_ANALYTICS = "ide.disable.intellij.project.analytics";
    private static final EventLogGroup GROUP = new EventLogGroup("platform.registry", 5);
    private static final StringEventField REGISTRY_KEY = EventFields.StringValidatedByCustomRule((String)"id", RegistryUtilValidator.class);
    private static final VarargEventId REGISTRY = GROUP.registerVarargEvent("registry", new EventField[]{REGISTRY_KEY, EventFields.PluginInfo});
    private static final VarargEventId EXPERIMENT = GROUP.registerVarargEvent("experiment", new EventField[]{REGISTRY_KEY, EventFields.PluginInfo});
    private static final VarargEventId ADVANCED_SETTING = GROUP.registerVarargEvent("advanced.setting", new EventField[]{REGISTRY_KEY, EventFields.PluginInfo});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        return RegistryApplicationUsagesCollector.getChangedValuesUsages();
    }

    @NotNull
    static Set<MetricEvent> getChangedValuesUsages() {
        Set registry = Registry.getAll().stream().filter(key -> key.isChangedFromDefault() && !StringUtil.equals((CharSequence)key.getKey(), (CharSequence)DISABLE_INTELLIJ_PROJECT_ANALYTICS)).map(key -> REGISTRY.metric(new EventPair[]{REGISTRY_KEY.with((Object)key.getKey())})).collect(Collectors.toSet());
        Set experiments = Experiments.EP_NAME.getExtensionList().stream().filter(f -> Experiments.getInstance().isFeatureEnabled(f.id)).map(f -> EXPERIMENT.metric(new EventPair[]{REGISTRY_KEY.with((Object)f.id)})).collect(Collectors.toSet());
        Set advancedSettings = AdvancedSettingBean.EP_NAME.getExtensionList().stream().filter(f -> ((AdvancedSettingsImpl)AdvancedSettings.getInstance()).isNonDefault(f.id)).map(f -> ADVANCED_SETTING.metric(new EventPair[]{REGISTRY_KEY.with((Object)f.id)})).collect(Collectors.toSet());
        HashSet<MetricEvent> result = new HashSet<MetricEvent>(registry);
        result.addAll(experiments);
        result.addAll(advancedSettings);
        HashSet<MetricEvent> hashSet = result;
        if (hashSet == null) {
            RegistryApplicationUsagesCollector.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/collectors/fus/RegistryApplicationUsagesCollector", "getChangedValuesUsages"));
    }

    public static final class RegistryUtilValidator
    extends CustomValidationRule {
        @NotNull
        public String getRuleId() {
            return "registry_key";
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            ExperimentalFeature feature;
            if (data == null) {
                RegistryUtilValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                RegistryUtilValidator.$$$reportNull$$$0(1);
            }
            if ((feature = RegistryUtilValidator.findFeatureById(data)) != null) {
                PluginInfo info = PluginInfoDetectorKt.getPluginInfo(feature.getClass());
                context.setPayload(PLUGIN_INFO, (Object)info);
                ValidationResultType validationResultType = info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    RegistryUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            for (AdvancedSettingBean extension : AdvancedSettingBean.EP_NAME.getExtensionList()) {
                if (!extension.id.equals(data)) continue;
                PluginDescriptor descriptor = extension.getPluginDescriptor();
                if (descriptor == null) {
                    ValidationResultType validationResultType = ValidationResultType.REJECTED;
                    if (validationResultType == null) {
                        RegistryUtilValidator.$$$reportNull$$$0(3);
                    }
                    return validationResultType;
                }
                PluginInfo info = PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)descriptor);
                context.setPayload(PLUGIN_INFO, (Object)info);
                ValidationResultType validationResultType = info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    RegistryUtilValidator.$$$reportNull$$$0(4);
                }
                return validationResultType;
            }
            PluginInfo info = RegistryUtilValidator.getPluginInfoByRegistry(Registry.get((String)data));
            context.setPayload(PLUGIN_INFO, (Object)info);
            ValidationResultType validationResultType = info.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                RegistryUtilValidator.$$$reportNull$$$0(5);
            }
            return validationResultType;
        }

        @NotNull
        private static PluginInfo getPluginInfoByRegistry(@NotNull RegistryValue value) {
            String pluginId;
            if (value == null) {
                RegistryUtilValidator.$$$reportNull$$$0(6);
            }
            PluginInfo pluginInfo = (pluginId = value.getPluginId()) != null ? PluginInfoDetectorKt.getPluginInfoById((PluginId)PluginId.getId((String)pluginId)) : PluginInfoDetectorKt.getPlatformPlugin();
            if (pluginInfo == null) {
                RegistryUtilValidator.$$$reportNull$$$0(7);
            }
            return pluginInfo;
        }

        @Nullable
        private static ExperimentalFeature findFeatureById(@NotNull String featureId) {
            if (featureId == null) {
                RegistryUtilValidator.$$$reportNull$$$0(8);
            }
            for (ExperimentalFeature feature : Experiments.EP_NAME.getExtensionList()) {
                if (!Objects.equals(feature.id, featureId)) continue;
                return feature;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/RegistryApplicationUsagesCollector$RegistryUtilValidator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "featureId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/RegistryApplicationUsagesCollector$RegistryUtilValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPluginInfoByRegistry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getPluginInfoByRegistry";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findFeatureById";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 7 -> new IllegalStateException(string);
            };
        }
    }
}

