/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/ToolkitInfoCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "<init>", "()V", "toolkitNames", "", "", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "selectedLanguage", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "getGroup", "intellij.platform.ide.internal"})
public final class ToolkitInfoCollector
extends ApplicationUsagesCollector {
    @NotNull
    private final List<String> toolkitNames;
    @NotNull
    private final EventLogGroup GROUP;
    @NotNull
    private final EventId1<String> selectedLanguage;

    public ToolkitInfoCollector() {
        Object[] objectArray = new String[]{"WLToolkit", "XToolkit", "other", "not_set"};
        this.toolkitNames = CollectionsKt.listOf((Object[])objectArray);
        this.GROUP = new EventLogGroup("toolkit.info", 1, null, 4, null);
        this.selectedLanguage = this.GROUP.registerEvent("awt.toolkit.name", (EventField)EventFields.String((String)"value", this.toolkitNames));
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        Set result = new LinkedHashSet();
        String property = System.getProperty("awt.toolkit.name");
        String value = property == null ? "not_set" : (this.toolkitNames.contains(property) ? property : "other");
        result.add(this.selectedLanguage.metric((Object)value));
        return result;
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }
}

