/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.environment;

import com.intellij.internal.statistic.collectors.fus.environment.ExternalEditorCollectionDataProvider;
import com.intellij.internal.statistic.collectors.fus.environment.ZedCollectionDataProviderKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/environment/ZedCollectionDataProvider;", "Lcom/intellij/internal/statistic/collectors/fus/environment/ExternalEditorCollectionDataProvider;", "<init>", "()V", "zedHomePath", "Ljava/nio/file/Path;", "isZedDetected", "", "getZedHomePath", "intellij.platform.ide.internal"})
@SourceDebugExtension(value={"SMAP\nZedCollectionDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZedCollectionDataProvider.kt\ncom/intellij/internal/statistic/collectors/fus/environment/ZedCollectionDataProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,65:1\n60#2,5:66\n60#2,5:71\n60#2,5:76\n60#2,5:81\n60#2,5:86\n*S KotlinDebug\n*F\n+ 1 ZedCollectionDataProvider.kt\ncom/intellij/internal/statistic/collectors/fus/environment/ZedCollectionDataProvider\n*L\n29#1:66,5\n43#1:71,5\n48#1:76,5\n58#1:81,5\n62#1:86,5\n*E\n"})
public final class ZedCollectionDataProvider
extends ExternalEditorCollectionDataProvider {
    @Nullable
    private final Path zedHomePath = this.getZedHomePath();

    public final boolean isZedDetected() {
        boolean bl;
        Path path = this.zedHomePath;
        if (path != null) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            bl = Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        } else {
            bl = false;
        }
        boolean isZedHomePathValid = bl;
        Logger $this$debug_u24default$iv = ZedCollectionDataProviderKt.access$getLogger$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl2 = false;
            logger.debug("Zed detected: " + isZedHomePathValid, e$iv);
        }
        return isZedHomePathValid;
    }

    private final Path getZedHomePath() {
        if (SystemInfo.isMac || SystemInfo.isLinux) {
            Path path;
            boolean $i$f$debug;
            Logger $this$debug_u24default$iv;
            Path zedHomePath;
            Logger logger;
            String string;
            try {
                string = System.getenv("XDG_CONFIG_HOME");
            }
            catch (SecurityException e) {
                ZedCollectionDataProviderKt.access$getLogger$p().debug((Throwable)e);
                string = null;
            }
            String xdgConfigHomeEnvValue = string;
            Logger $this$debug_u24default$iv2 = ZedCollectionDataProviderKt.access$getLogger$p();
            String[] e$iv = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl = false;
                logger.debug("XDG_CONFIG_HOME env var value: " + xdgConfigHomeEnvValue, (Throwable)e$iv);
            }
            if (xdgConfigHomeEnvValue != null) {
                try {
                    e$iv = new String[]{"zed"};
                    zedHomePath = Paths.get(xdgConfigHomeEnvValue, e$iv);
                    $this$debug_u24default$iv = ZedCollectionDataProviderKt.access$getLogger$p();
                    Throwable e$iv2 = null;
                    $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug("Zed home path: " + zedHomePath, e$iv2);
                    }
                }
                catch (InvalidPathException e) {
                    ZedCollectionDataProviderKt.access$getLogger$p().debug((Throwable)e);
                    zedHomePath = null;
                }
                return zedHomePath;
            }
            Path path2 = this.getHomeDirectory();
            if (path2 != null) {
                String[] e$iv2 = new String[]{"zed"};
                path = path2.resolve(Paths.get(".config", e$iv2));
            } else {
                path = null;
            }
            zedHomePath = path;
            $this$debug_u24default$iv = ZedCollectionDataProviderKt.access$getLogger$p();
            Throwable e$iv3 = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Zed home path: " + zedHomePath, e$iv3);
            }
            return zedHomePath;
        }
        Logger $this$debug_u24default$iv = ZedCollectionDataProviderKt.access$getLogger$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("The current OS is not supported by Zed", e$iv);
        }
        return null;
    }
}

