/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ui;

import com.intellij.icons.AllIcons;
import com.intellij.internal.ui.ModelPath;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.TreeNodeDomainModel;
import com.intellij.ui.treeStructure.TreeNodePresentation;
import com.intellij.ui.treeStructure.TreeNodePresentationBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012H\u0096@\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/ui/MyTreeNodeDomainModel;", "Lcom/intellij/ui/treeStructure/TreeNodeDomainModel;", "path", "Lcom/intellij/internal/ui/ModelPath;", "<init>", "(Lcom/intellij/internal/ui/ModelPath;)V", "getPath", "()Lcom/intellij/internal/ui/ModelPath;", "computeIsLeaf", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "computePresentation", "Lkotlinx/coroutines/flow/Flow;", "Lcom/intellij/ui/treeStructure/TreeNodePresentation;", "builder", "Lcom/intellij/ui/treeStructure/TreeNodePresentationBuilder;", "(Lcom/intellij/ui/treeStructure/TreeNodePresentationBuilder;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "computeChildren", "", "toString", "", "intellij.platform.ide.internal"})
@SourceDebugExtension(value={"SMAP\nTreeViewModelDemoAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeViewModelDemoAction.kt\ncom/intellij/internal/ui/MyTreeNodeDomainModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n1563#2:244\n1634#2,3:245\n*S KotlinDebug\n*F\n+ 1 TreeViewModelDemoAction.kt\ncom/intellij/internal/ui/MyTreeNodeDomainModel\n*L\n163#1:244\n163#1:245,3\n*E\n"})
final class MyTreeNodeDomainModel
implements TreeNodeDomainModel {
    @NotNull
    private final ModelPath path;

    public MyTreeNodeDomainModel(@NotNull ModelPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
    }

    @NotNull
    public final ModelPath getPath() {
        return this.path;
    }

    @Nullable
    public Object computeIsLeaf(@NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((!this.path.isDirectory() || this.path.isEmptyDirectory() ? 1 : 0) != 0);
    }

    @Nullable
    public Object computePresentation(@NotNull TreeNodePresentationBuilder builder, @NotNull Continuation<? super Flow<? extends TreeNodePresentation>> $completion) {
        builder.setIcon(this.path.isDirectory() ? AllIcons.Nodes.Folder : AllIcons.FileTypes.Any_type);
        String mainText = this.path.getName();
        builder.setMainText(mainText);
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
        builder.appendTextFragment(mainText, simpleTextAttributes);
        String string = " (" + this.path.getFullPath() + ")";
        SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"GRAYED_ATTRIBUTES");
        builder.appendTextFragment(string, simpleTextAttributes2);
        return FlowKt.flowOf((Object)builder.build());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object computeChildren(@NotNull Continuation<? super List<? extends TreeNodeDomainModel>> $completion) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.path.getChildren();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ModelPath modelPath = (ModelPath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new MyTreeNodeDomainModel((ModelPath)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public String toString() {
        return "node(" + this.path + ")";
    }
}

