/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkFactoryImpl;
import com.intellij.remote.ui.CreateRemoteSdkForm;
import com.intellij.remote.ui.RemoteSdkEditorContainer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class CreateRemoteSdkDialog<T extends RemoteSdkAdditionalData>
extends DialogWrapper
implements RemoteSdkEditorContainer {
    private static final Logger LOG = Logger.getInstance(CreateRemoteSdkDialog.class);
    @Nullable
    protected final Project myProject;
    private CreateRemoteSdkForm<T> myInterpreterForm;
    private Sdk mySdk;
    private final Supplier<RemoteSdkFactoryImpl<T>> sdkFactoryProvider = new SynchronizedClearableLazy(this::createRemoteSdkFactory);
    @Nullable
    private T myOriginalData;
    protected final Collection<Sdk> myExistingSdks;

    public CreateRemoteSdkDialog(@Nullable Project project, Collection<Sdk> existingSdks) {
        super(project, true);
        this.myProject = project == null || !project.isDefault() ? project : null;
        this.myExistingSdks = existingSdks;
    }

    public CreateRemoteSdkDialog(Component parentComponent, Collection<Sdk> existingSdks) {
        super(parentComponent, true);
        this.myProject = null;
        this.myExistingSdks = existingSdks;
    }

    @NotNull
    protected abstract RemoteSdkFactoryImpl<T> createRemoteSdkFactory();

    protected RemoteSdkFactoryImpl<T> getSdkFactory() {
        return this.sdkFactoryProvider.get();
    }

    @NotNull
    private CreateRemoteSdkForm<T> getInterpreterForm() {
        if (this.myInterpreterForm == null) {
            this.myInterpreterForm = this.createRemoteSdkForm();
        }
        CreateRemoteSdkForm<T> createRemoteSdkForm = this.myInterpreterForm;
        if (createRemoteSdkForm == null) {
            CreateRemoteSdkDialog.$$$reportNull$$$0(0);
        }
        return createRemoteSdkForm;
    }

    @NotNull
    protected abstract CreateRemoteSdkForm<T> createRemoteSdkForm();

    public final void onValidationPress() {
        this.initValidation();
    }

    @Override
    public void updateSize() {
        this.pack();
    }

    protected JComponent createCenterPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.add(this.getInterpreterForm(), "Center");
        return result;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getInterpreterForm().getPreferredFocusedComponent();
    }

    @NotNull
    public final Sdk getSdk() {
        assert (this.mySdk != null);
        assert (this.mySdk.getSdkAdditionalData() instanceof RemoteSdkAdditionalData);
        Sdk sdk = this.mySdk;
        if (sdk == null) {
            CreateRemoteSdkDialog.$$$reportNull$$$0(1);
        }
        return sdk;
    }

    protected void initSdk(@NotNull Sdk sdk) throws RemoteSdkException {
        if (sdk == null) {
            CreateRemoteSdkDialog.$$$reportNull$$$0(2);
        }
        this.getSdkFactory().initSdk(sdk, this.myProject, this.getContentPane());
    }

    protected abstract boolean isModified(@NotNull T var1, @NotNull T var2);

    @NotNull
    private Sdk createSdk(T remoteSdkData) throws RemoteSdkException {
        Sdk sdk = this.createRemoteSdk(remoteSdkData);
        if (sdk == null) {
            CreateRemoteSdkDialog.$$$reportNull$$$0(3);
        }
        return sdk;
    }

    private Sdk createRemoteSdk(T data) throws RemoteSdkException {
        return this.getSdkFactory().createRemoteSdk(this.myProject, data, this.getInterpreterForm().getSdkName(), this.myExistingSdks);
    }

    @Nullable
    private Sdk saveUnfinished() {
        try {
            T data = this.getInterpreterForm().createSdkData();
            return this.getSdkFactory().createUnfinished(data, this.myExistingSdks);
        }
        catch (RemoteSdkException e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    protected void doOKAction() {
        T remoteSdkData;
        String validation = this.validateInterpreterForm();
        if (validation != null) {
            this.onCreateFail(validation);
            return;
        }
        try {
            remoteSdkData = this.getInterpreterForm().createSdkData();
        }
        catch (ProcessCanceledException ignored) {
            return;
        }
        catch (RemoteSdkException e) {
            LOG.warn("Failed to create SDK data", (Throwable)e);
            this.onCreateFail(e.getMessage());
            return;
        }
        if (!this.validateRemoteSdkData(remoteSdkData)) {
            LOG.info("Validation of SDK Data failed");
            return;
        }
        try {
            this.mySdk = this.createSdk(remoteSdkData);
            SdkAdditionalData newData = this.mySdk.getSdkAdditionalData();
            assert (newData instanceof RemoteSdkAdditionalData);
            if (((RemoteSdkAdditionalData)newData).isValid() && (this.myOriginalData == null || !this.myOriginalData.isValid() || this.myOriginalData.getClass().isInstance(newData) && this.isModified(this.myOriginalData, (RemoteSdkAdditionalData)newData))) {
                this.initSdk(this.mySdk);
            }
        }
        catch (RemoteSdkException e) {
            this.mySdk = null;
            if (!ExceptionUtil.causedBy((Throwable)e, InterruptedException.class)) {
                LOG.debug("Failed to create remote SDK", (Throwable)e);
                this.onCreateFail(e.getMessage());
            }
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> super.doOKAction());
    }

    protected boolean validateRemoteSdkData(T data) {
        for (Sdk sdk : this.myExistingSdks) {
            if (!StringUtil.equals((CharSequence)sdk.getHomePath(), (CharSequence)this.getSdkFactory().generateSdkHomePath(data))) continue;
            this.validationFailed(IdeBundle.message((String)"dialog.message.there.already.same.interpreter", (Object[])new Object[]{sdk.getName()}), false);
            return false;
        }
        return true;
    }

    private void onCreateFail(@NlsContexts.DialogMessage String validation) {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            boolean saveAnyway = this.validationFailed(validation, this.getSdkFactory().canSaveUnfinished());
            if (saveAnyway) {
                this.mySdk = this.saveUnfinished();
                if (this.mySdk != null) {
                    super.doOKAction();
                }
            }
        });
    }

    public void setSdkName(String name) {
        if (name != null && !name.startsWith(this.getSdkFactory().getDefaultUnfinishedName())) {
            this.getInterpreterForm().setSdkName(name);
        }
    }

    protected boolean validationFailed(@NlsContexts.DialogMessage String validation, boolean askSaveUnfinished) {
        if (StringUtil.isEmpty((String)validation)) {
            validation = IdeBundle.message((String)"dialog.message.communication.error", (Object[])new Object[0]);
        }
        if (askSaveUnfinished) {
            if (Messages.showOkCancelDialog((String)validation, (String)IdeBundle.message((String)"dialog.title.can.t.create.0.sdk", (Object[])new Object[]{this.getSdkFactory().sdkName()}), (String)IdeBundle.message((String)"button.save.anyway", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.continue.editing", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) == 0) {
                return true;
            }
        } else {
            Messages.showErrorDialog((String)validation, (String)IdeBundle.message((String)"dialog.title.can.t.create.0.sdk", (Object[])new Object[]{this.getSdkFactory().sdkName()}));
        }
        return false;
    }

    @NlsContexts.DialogMessage
    @Nullable
    private String validateInterpreterForm() {
        return this.getInterpreterForm().validateFinal();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.getInterpreterForm().validateRemoteInterpreter();
    }

    public void setEditing(@NotNull T originalData) {
        if (originalData == null) {
            CreateRemoteSdkDialog.$$$reportNull$$$0(4);
        }
        this.getInterpreterForm().init(originalData);
        this.myOriginalData = originalData;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @TestOnly
    public CreateRemoteSdkForm<T> getRemoteSdkForm() {
        return this.myInterpreterForm;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/ui/CreateRemoteSdkDialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/ui/CreateRemoteSdkDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdk";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initSdk";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setEditing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4 -> new IllegalArgumentException(string);
        };
    }
}

