/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@com.intellij.openapi.components.State(name="RemoteMappingsManager", storages={@Storage(value="remote-mappings.xml")})
public final class RemoteMappingsManager
implements PersistentStateComponent<State> {
    private final State myState = new State();

    public static RemoteMappingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            RemoteMappingsManager.$$$reportNull$$$0(0);
        }
        return (RemoteMappingsManager)project.getService(RemoteMappingsManager.class);
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            RemoteMappingsManager.$$$reportNull$$$0(1);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            RemoteMappingsManager.$$$reportNull$$$0(2);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
    }

    public void setForServer(@NotNull Mappings mappings) {
        if (mappings == null) {
            RemoteMappingsManager.$$$reportNull$$$0(3);
        }
        List<Mappings> list = this.myState.getList();
        Iterator<Mappings> iterator = list.iterator();
        while (iterator.hasNext()) {
            Mappings current = iterator.next();
            if (!mappings.getServerId().equals(current.getServerId())) continue;
            iterator.remove();
        }
        list.add(mappings);
    }

    @Nullable
    public Mappings getForServer(@NotNull String prefix, @NotNull String serverId) {
        if (prefix == null) {
            RemoteMappingsManager.$$$reportNull$$$0(4);
        }
        if (serverId == null) {
            RemoteMappingsManager.$$$reportNull$$$0(5);
        }
        String compoundId = RemoteMappingsManager.combineWithPrefix(prefix, serverId);
        List<Mappings> list = this.myState.getList();
        for (Mappings mappings : list) {
            if (!compoundId.equals(mappings.getServerId())) continue;
            return mappings;
        }
        return null;
    }

    public Mappings create(@NotNull String prefix, @NotNull String serverId, @NotNull List<PathMappingSettings.PathMapping> settings) {
        if (prefix == null) {
            RemoteMappingsManager.$$$reportNull$$$0(6);
        }
        if (serverId == null) {
            RemoteMappingsManager.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            RemoteMappingsManager.$$$reportNull$$$0(8);
        }
        Mappings mappings = new Mappings();
        mappings.setServerId(prefix, serverId);
        mappings.setSettings(settings);
        return mappings;
    }

    @NotNull
    private static String combineWithPrefix(String prefix, String serverId) {
        String string = prefix + "@" + serverId;
        if (string == null) {
            RemoteMappingsManager.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/RemoteMappingsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/RemoteMappingsManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "combineWithPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setForServer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getForServer";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 9 -> new IllegalStateException(string);
        };
    }

    @Tag(value="state")
    public static class State {
        @Tag(value="list")
        private List<Mappings> myList = new ArrayList<Mappings>();

        public List<Mappings> getList() {
            return this.myList;
        }
    }

    @Tag(value="remote-mappings")
    public static class Mappings {
        private String myServerId;
        private List<PathMappingSettings.PathMapping> mySettings = new ArrayList<PathMappingSettings.PathMapping>();
        private Map<String, String> myDisabled = new HashMap<String, String>();

        @Attribute(value="server-id")
        public String getServerId() {
            return this.myServerId;
        }

        @Tag(value="settings")
        public List<PathMappingSettings.PathMapping> getSettings() {
            return this.mySettings;
        }

        @Tag(value="disabled")
        public Map<String, String> getDisabled() {
            return this.myDisabled;
        }

        public void setSettings(List<PathMappingSettings.PathMapping> settings) {
            this.mySettings = settings;
        }

        public void setServerId(String serverId) {
            this.myServerId = serverId;
        }

        public void setServerId(String prefix, String serverId) {
            this.myServerId = RemoteMappingsManager.combineWithPrefix(prefix, serverId);
        }

        public void setDisabled(Map<String, String> disabled) {
            this.myDisabled = disabled;
        }
    }
}

