/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkFactory;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteSdkFactoryImpl<T extends RemoteSdkAdditionalData>
implements RemoteSdkFactory<T> {
    private static final Logger LOG = Logger.getInstance(RemoteSdkFactoryImpl.class);

    @Override
    public Sdk createRemoteSdk(@Nullable Project project, @NotNull T data, @Nullable String sdkName, Collection<Sdk> existingSdks) throws RemoteSdkException {
        if (data == null) {
            RemoteSdkFactoryImpl.$$$reportNull$$$0(0);
        }
        String sdkVersion = this.getSdkVersion(project, data);
        String name = StringUtil.isNotEmpty((String)sdkName) ? sdkName : this.getSdkName(data, sdkVersion);
        SdkType sdkType = this.getSdkType(data);
        Sdk sdk = this.createSdk(existingSdks, sdkType, data, name);
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.setVersionString(sdkVersion);
        SdkAdditionalData modifiableAdditionalData = sdkModificator.getSdkAdditionalData();
        if (!(modifiableAdditionalData instanceof RemoteSdkAdditionalData)) {
            LOG.error("Expected remote additional data, got " + String.valueOf(modifiableAdditionalData) + " in " + String.valueOf(sdk));
            throw new RemoteSdkException(ExecutionBundle.message((String)"dialog.message.internal.error", (Object[])new Object[0]));
        }
        RemoteSdkAdditionalData remoteSdkAdditionalData = (RemoteSdkAdditionalData)modifiableAdditionalData;
        remoteSdkAdditionalData.setValid(true);
        Application application = ApplicationManager.getApplication();
        Runnable runnable = () -> sdkModificator.commitChanges();
        if (application.isDispatchThread()) {
            application.runWriteAction(runnable);
        } else {
            application.invokeAndWait(() -> application.runWriteAction(runnable));
        }
        return sdk;
    }

    @Override
    public String generateSdkHomePath(@NotNull T data) {
        if (data == null) {
            RemoteSdkFactoryImpl.$$$reportNull$$$0(1);
        }
        return data.getSdkId();
    }

    @NotNull
    protected abstract SdkType getSdkType(@NotNull T var1);

    @NotNull
    protected abstract String getSdkName(@NotNull T var1, @Nullable String var2) throws RemoteSdkException;

    @Nullable
    protected abstract String getSdkVersion(Project var1, @NotNull T var2) throws RemoteSdkException;

    @Override
    @NotNull
    public Sdk createUnfinished(T data, Collection<Sdk> existingSdks) {
        String name = this.getDefaultUnfinishedName();
        SdkType sdkType = this.getSdkType(data);
        Sdk sdk = this.createSdk(existingSdks, sdkType, data, name);
        data.setValid(false);
        Sdk sdk2 = sdk;
        if (sdk2 == null) {
            RemoteSdkFactoryImpl.$$$reportNull$$$0(2);
        }
        return sdk2;
    }

    @NotNull
    protected abstract Sdk createSdk(@NotNull Collection<Sdk> var1, @NotNull SdkType var2, @NotNull T var3, @Nullable String var4);

    @Override
    public abstract String getDefaultUnfinishedName();

    @Override
    public boolean canSaveUnfinished() {
        return false;
    }

    @NotNull
    @Nls
    public static String getDefaultUnfinishedInterpreterName(@NotNull String sdkName) {
        if (sdkName == null) {
            RemoteSdkFactoryImpl.$$$reportNull$$$0(3);
        }
        String string = IdeBundle.message((String)"interpreter.default.name", (Object[])new Object[]{sdkName});
        if (string == null) {
            RemoteSdkFactoryImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/RemoteSdkFactoryImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/RemoteSdkFactoryImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnfinished";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUnfinishedInterpreterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteSdk";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateSdkHomePath";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultUnfinishedInterpreterName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

