/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote.ext;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CannotLoadCredentialsException;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.remote.ext.UnknownCredentialsHolder;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

final class CredentialsManagerImpl
extends CredentialsManager {
    CredentialsManagerImpl() {
    }

    public List<CredentialsType<?>> getAllTypes() {
        return CredentialsType.EP_NAME.getExtensionList();
    }

    public void loadCredentials(String interpreterPath, @Nullable Element element, RemoteSdkAdditionalData data) {
        for (CredentialsType type : CredentialsType.EP_NAME.getExtensionList()) {
            if (!type.hasPrefix(interpreterPath)) continue;
            Object credentials = type.createCredentials();
            try {
                type.getHandler(credentials).load(element);
            }
            catch (CannotLoadCredentialsException e) {
                Logger.getInstance(CredentialsManagerImpl.class).warn((Throwable)e);
                continue;
            }
            data.setCredentials(type.getCredentialsKey(), credentials);
            return;
        }
        UnknownCredentialsHolder credentials = (UnknownCredentialsHolder)CredentialsType.UNKNOWN.createCredentials();
        credentials.setSdkId(interpreterPath);
        if (element != null) {
            credentials.load(element);
        }
        data.setCredentials(CredentialsType.UNKNOWN_CREDENTIALS, (Object)credentials);
    }
}

