/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.WebAnimationUtils$LottieImageSize$;
import java.awt.Color;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tJN\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0005J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0005J\b\u0010\u0019\u001a\u00020\u0014H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ui/WebAnimationUtils;", "", "<init>", "()V", "createLottieAnimationPage", "", "lottieJson", "lottieScript", "background", "Ljava/awt/Color;", "createVideoHtmlPageWithUrl", "videoUrl", "stubImageUrl", "autoplay", "", "loop", "injectedVideoEndedListener", "injectedVideoLoadingErrorListener", "createSingleContentHtmlPage", "body", "Lcom/intellij/openapi/util/text/HtmlChunk;", "componentId", "getSingleContentCssStyles", "getLottieImageSize", "Ljava/awt/Dimension;", "createDownloadableLottieScriptTag", "LottieImageSize", "intellij.platform.ide.ui"})
@ApiStatus.Experimental
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWebAnimationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebAnimationUtils.kt\ncom/intellij/ui/WebAnimationUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,144:1\n1#2:145\n222#3:146\n*S KotlinDebug\n*F\n+ 1 WebAnimationUtils.kt\ncom/intellij/ui/WebAnimationUtils\n*L\n127#1:146\n*E\n"})
public final class WebAnimationUtils {
    @NotNull
    public static final WebAnimationUtils INSTANCE = new WebAnimationUtils();

    private WebAnimationUtils() {
    }

    @NotNull
    public final String createLottieAnimationPage(@NotNull String lottieJson, @Nullable String lottieScript, @NotNull Color background) {
        HtmlChunk htmlChunk;
        Intrinsics.checkNotNullParameter((Object)lottieJson, (String)"lottieJson");
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        String componentId = "lottie";
        if (lottieScript != null) {
            HtmlChunk.Element element = HtmlChunk.tag((String)"script").addRaw(lottieScript);
            Intrinsics.checkNotNull((Object)element);
            htmlChunk = (HtmlChunk)element;
        } else {
            htmlChunk = this.createDownloadableLottieScriptTag();
        }
        HtmlChunk script = htmlChunk;
        HtmlChunk.Element element = HtmlChunk.body().child(script).child((HtmlChunk)HtmlChunk.div().attr("id", componentId).addRaw("")).child((HtmlChunk)HtmlChunk.tag((String)"script").addRaw(StringsKt.trimIndent((String)("\n           const animationData = " + lottieJson + ";\n           const params = {\n               container: document.getElementById('lottie'),\n               renderer: 'svg',\n               loop: true,\n               autoplay: true,\n               animationData: animationData\n           };\n           lottie.loadAnimation(params);\n           "))));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"child(...)");
        HtmlChunk.Element body = element;
        return this.createSingleContentHtmlPage((HtmlChunk)body, background, componentId);
    }

    public static /* synthetic */ String createLottieAnimationPage$default(WebAnimationUtils webAnimationUtils, String string, String string2, Color color, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return webAnimationUtils.createLottieAnimationPage(string, string2, color);
    }

    @NotNull
    public final String createVideoHtmlPageWithUrl(@NotNull String videoUrl, @NotNull Color background, @Nullable String stubImageUrl, boolean autoplay, boolean loop, @Nullable String injectedVideoEndedListener, @Nullable String injectedVideoLoadingErrorListener) {
        Intrinsics.checkNotNullParameter((Object)videoUrl, (String)"videoUrl");
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        String componentId = "video";
        String sourceId = "video-source";
        String string = injectedVideoEndedListener;
        String string2 = injectedVideoLoadingErrorListener;
        String scriptText = StringsKt.trimIndent((String)("\n        document.addEventListener(\"DOMContentLoaded\", function() {\n            let video = document.getElementById(\"" + componentId + "\");\n            let source = document.getElementById(\"" + sourceId + "\");\n\n            window.playVideo = function() {\n                video.play();\n            }\n\n            window.pauseVideo = function() {\n                video.pause();\n            }\n            \n            window.resetVideo = function() {\n              video.currentTime = 0;\n            }\n            " + (String)(string != null ? "video.addEventListener('ended', function() { " + string + " });" : "") + "\n            " + (String)(string2 != null ? "source.addEventListener('error', function() { " + string2 + " });" : "") + "\n        });\n    "));
        HtmlChunk.Element element = HtmlChunk.tag((String)"script").addRaw(scriptText);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"addRaw(...)");
        HtmlChunk.Element script = element;
        HtmlChunk.Element it = HtmlChunk.tag((String)"video").attr("id", componentId);
        boolean bl = false;
        it = autoplay ? it.attr("autoplay") : it;
        boolean bl2 = false;
        it = (loop ? it.attr("loop") : it).attr("muted");
        boolean bl3 = false;
        HtmlChunk.Element element2 = (stubImageUrl != null ? it.attr("poster", stubImageUrl) : it).child((HtmlChunk)HtmlChunk.tag((String)"source").attr("type", "video/webm").attr("src", videoUrl).attr("id", sourceId));
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"child(...)");
        HtmlChunk.Element videoTag = element2;
        HtmlChunk.Element element3 = HtmlChunk.body().child((HtmlChunk)script).child((HtmlChunk)videoTag);
        Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"child(...)");
        HtmlChunk.Element body = element3;
        return this.createSingleContentHtmlPage((HtmlChunk)body, background, componentId);
    }

    public static /* synthetic */ String createVideoHtmlPageWithUrl$default(WebAnimationUtils webAnimationUtils, String string, Color color, String string2, boolean bl, boolean bl2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        if ((n & 0x40) != 0) {
            string4 = null;
        }
        return webAnimationUtils.createVideoHtmlPageWithUrl(string, color, string2, bl, bl2, string3, string4);
    }

    private final String createSingleContentHtmlPage(HtmlChunk body, Color background, String componentId) {
        HtmlChunk.Element element = HtmlChunk.head().child(this.getSingleContentCssStyles(background, componentId));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"child(...)");
        HtmlChunk.Element head = element;
        String string = HtmlChunk.html().child((HtmlChunk)head).child(body).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final HtmlChunk getSingleContentCssStyles(Color background, String componentId) {
        HtmlChunk.Element element = HtmlChunk.tag((String)"style").addRaw(StringsKt.trimIndent((String)("\n          body {\n              background-color: #" + ColorUtil.toHex((Color)background) + ";\n              margin: 0;\n              height: 100%;\n              overflow: hidden;\n          }\n          #" + componentId + " {\n              background-color: #" + ColorUtil.toHex((Color)background) + ";\n              width: 100%;\n              height: 100%;\n              display: block;\n              overflow: hidden;\n              transform: translate3d(0,0,0);\n              text-align: center;\n              opacity: 1;\n          }\n          ")));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"addRaw(...)");
        return (HtmlChunk)element;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Dimension getLottieImageSize(@NotNull String lottieJson) throws SerializationException {
        void this_$iv;
        Json json;
        Intrinsics.checkNotNullParameter((Object)lottieJson, (String)"lottieJson");
        Json json2 = json = JsonKt.Json$default(null, WebAnimationUtils::getLottieImageSize$lambda$0, (int)1, null);
        String string$iv = lottieJson;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        LottieImageSize size = (LottieImageSize)this_$iv.decodeFromString((DeserializationStrategy)LottieImageSize.Companion.serializer(), string$iv);
        return new Dimension(size.getWidth(), size.getHeight());
    }

    private final HtmlChunk createDownloadableLottieScriptTag() {
        HtmlChunk.Element element = HtmlChunk.tag((String)"script").attr("src", "https://cdnjs.cloudflare.com/ajax/libs/bodymovin/5.5.10/lottie.min.js").attr("integrity", "sha512-WuVUWb/eEtkYLd+Uxb51tmI1PELy432HLMrKr4CI+TpmKMr/PBBpsnjH35A0aLFK4YniNOxJ5a6vc4aMbZFGSQ==").attr("crossorigin", "anonymous").attr("referrerpolicy", "no-referrer").addRaw("");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"addRaw(...)");
        return (HtmlChunk)element;
    }

    private static final Unit getLottieImageSize$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0005\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J%\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0001\u00a2\u0006\u0002\b!R\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\f\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/intellij/ui/WebAnimationUtils$LottieImageSize;", "", "width", "", "height", "<init>", "(II)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IIILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getWidth$annotations", "()V", "getWidth", "()I", "getHeight$annotations", "getHeight", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_platform_ide_ui", "$serializer", "Companion", "intellij.platform.ide.ui"})
    private static final class LottieImageSize {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int width;
        private final int height;

        public LottieImageSize(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public final int getWidth() {
            return this.width;
        }

        @SerialName(value="w")
        public static /* synthetic */ void getWidth$annotations() {
        }

        public final int getHeight() {
            return this.height;
        }

        @SerialName(value="h")
        public static /* synthetic */ void getHeight$annotations() {
        }

        public final int component1() {
            return this.width;
        }

        public final int component2() {
            return this.height;
        }

        @NotNull
        public final LottieImageSize copy(int width, int height) {
            return new LottieImageSize(width, height);
        }

        public static /* synthetic */ LottieImageSize copy$default(LottieImageSize lottieImageSize, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = lottieImageSize.width;
            }
            if ((n3 & 2) != 0) {
                n2 = lottieImageSize.height;
            }
            return lottieImageSize.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "LottieImageSize(width=" + this.width + ", height=" + this.height + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.width);
            result = result * 31 + Integer.hashCode(this.height);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LottieImageSize)) {
                return false;
            }
            LottieImageSize lottieImageSize = (LottieImageSize)other;
            if (this.width != lottieImageSize.width) {
                return false;
            }
            return this.height == lottieImageSize.height;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_platform_ide_ui(LottieImageSize self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeIntElement(serialDesc, 0, self.width);
            output.encodeIntElement(serialDesc, 1, self.height);
        }

        public /* synthetic */ LottieImageSize(int seen0, int width, int height, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)LottieImageSize$$serializer.INSTANCE.getDescriptor());
            }
            this.width = width;
            this.height = height;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ui/WebAnimationUtils$LottieImageSize$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ui/WebAnimationUtils$LottieImageSize;", "intellij.platform.ide.ui"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<LottieImageSize> serializer() {
                return (KSerializer)LottieImageSize$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

