/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.charts;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.charts.ChartWrapper;
import com.intellij.ui.charts.ChartWrapperKt;
import com.intellij.ui.charts.Coordinates;
import com.intellij.ui.charts.Grid;
import com.intellij.ui.charts.GridLine;
import com.intellij.ui.charts.MinMax;
import com.intellij.ui.charts.ValueIterable;
import com.intellij.ui.charts.XYChartComponent;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\"H\u0004J-\u0010#\u001a\u00020$2\u0016\u0010%\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u00030&2\u0006\u0010'\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010(J-\u0010)\u001a\u00020$2\u0016\u0010%\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u00030&2\u0006\u0010*\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010(J\u0014\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\"H&J)\u0010,\u001a\u00020$2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\"2\u0006\u0010'\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010-J)\u0010.\u001a\u00020$2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\"2\u0006\u0010*\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010-J0\u0010/\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$002\u0012\u00101\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030&2\u0006\u00102\u001a\u00020\u001fH\u0014R\u001e\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019\u00a8\u00063"}, d2={"Lcom/intellij/ui/charts/GridChartWrapper;", "X", "", "Y", "Lcom/intellij/ui/charts/ChartWrapper;", "Lcom/intellij/ui/charts/XYChartComponent;", "<init>", "()V", "ranges", "Lcom/intellij/ui/charts/Grid;", "getRanges", "()Lcom/intellij/ui/charts/Grid;", "grid", "getGrid", "gridWidth", "", "getGridWidth", "()I", "gridHeight", "getGridHeight", "gridColor", "Ljava/awt/Color;", "getGridColor", "()Ljava/awt/Color;", "setGridColor", "(Ljava/awt/Color;)V", "gridLabelColor", "getGridLabelColor", "setGridLabelColor", "paintGrid", "", "Ljava/awt/Graphics2D;", "chart", "xy", "Lcom/intellij/ui/charts/MinMax;", "findGridLineX", "", "gl", "Lcom/intellij/ui/charts/GridLine;", "x", "(Lcom/intellij/ui/charts/GridLine;Ljava/lang/Number;)D", "findGridLineY", "y", "findMinMax", "findX", "(Lcom/intellij/ui/charts/MinMax;Ljava/lang/Number;)D", "findY", "findGridLabelOffset", "Lcom/intellij/ui/charts/Coordinates;", "line", "g", "intellij.platform.ide.ui"})
@SourceDebugExtension(value={"SMAP\nChartWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartWrapper.kt\ncom/intellij/ui/charts/GridChartWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,403:1\n1869#2:404\n1870#2:406\n1869#2,2:407\n1#3:405\n*S KotlinDebug\n*F\n+ 1 ChartWrapper.kt\ncom/intellij/ui/charts/GridChartWrapper\n*L\n85#1:404\n85#1:406\n105#1:407,2\n*E\n"})
public abstract class GridChartWrapper<X extends Number, Y extends Number>
extends ChartWrapper
implements XYChartComponent<X, Y> {
    @NotNull
    private Color gridColor = (Color)new JBColor(new Color(0xF0F0F0), new Color(0x313335));
    @NotNull
    private Color gridLabelColor;

    public GridChartWrapper() {
        Color color = ColorUtil.withAlpha((Color)JBColor.foreground(), (double)0.6);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"withAlpha(...)");
        this.gridLabelColor = color;
    }

    @Override
    @NotNull
    public abstract Grid<X, Y> getRanges();

    @NotNull
    public final Grid<X, Y> getGrid() {
        return this.getRanges();
    }

    public final int getGridWidth() {
        return this.getWidth() - (this.getMargins().left + this.getMargins().right);
    }

    public final int getGridHeight() {
        return this.getHeight() - (this.getMargins().top + this.getMargins().bottom);
    }

    @NotNull
    public final Color getGridColor() {
        return this.gridColor;
    }

    public final void setGridColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.gridColor = color;
    }

    @NotNull
    public final Color getGridLabelColor() {
        return this.gridLabelColor;
    }

    public final void setGridLabelColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.gridLabelColor = color;
    }

    protected final void paintGrid(@NotNull Graphics2D grid, @NotNull Graphics2D chart, @NotNull MinMax<X, Y> xy) {
        double y;
        double x;
        Coordinates<Double, Double> coordinates;
        GridLine<X, Y, Number> gl;
        GridLine<X, Y, Number> p0;
        Consumer<GridLine<X, Y, Object>> consumer;
        Number it;
        Iterable<Object> $this$forEach$iv;
        Iterable<X> iterable;
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        Intrinsics.checkNotNullParameter(xy, (String)"xy");
        Color gc = new Color(this.gridColor.getRGB());
        Color gcd = gc.darker();
        Rectangle bounds = grid.getClipBounds();
        int xOrigin = this.getRanges().getXOriginInitialized() ? (int)this.findX(xy, this.getRanges().getXOrigin()) : 0;
        int yOrigin = this.getRanges().getYOriginInitialized() ? (int)this.findY(xy, this.getRanges().getYOrigin()) : this.getHeight();
        int tmp = 0;
        tmp = -1;
        ValueIterable<X> $this$paintGrid_u24lambda_u240 = iterable = this.getRanges().getXLines();
        boolean bl = false;
        $this$paintGrid_u24lambda_u240.setMin(xy.getXMin());
        $this$paintGrid_u24lambda_u240.setMax(xy.getXMax());
        iterable = iterable;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            String label;
            it = (Number)t;
            boolean bl2 = false;
            GridLine<X, Y, Number> gridLine = new GridLine<X, Y, Number>(it, xy, 1);
            consumer = this.getRanges().getXPainter();
            p0 = gridLine;
            boolean bl3 = false;
            consumer.accept(p0);
            gl = gridLine;
            int px = MathKt.roundToInt((double)this.findGridLineX(gl, it));
            if (gl.getPaintLine()) {
                if (Math.abs(tmp - px) < 1) continue;
                tmp = px;
                grid.setColor(gl.getMajorLine() ? gcd : gc);
                grid.drawLine(px, bounds.y, px, bounds.y + bounds.height);
            }
            if (gl.getLabel() == null) continue;
            boolean bl4 = false;
            chart.setColor(this.gridLabelColor);
            coordinates = this.findGridLabelOffset(gl, chart);
            x = coordinates.component1();
            y = coordinates.component2();
            chart.drawString(label, px + this.getMargins().left - (int)x, yOrigin - this.getMargins().bottom + (int)y);
        }
        tmp = -1;
        $this$forEach$iv = this.getRanges().getYLines();
        ValueIterable<Y> $this$paintGrid_u24lambda_u242 = $this$forEach$iv;
        boolean bl5 = false;
        $this$paintGrid_u24lambda_u242.setMin(xy.getYMin());
        $this$paintGrid_u24lambda_u242.setMax(xy.getYMax());
        $this$forEach$iv = $this$forEach$iv;
        $i$f$forEach = false;
        for (Object object : $this$forEach$iv) {
            String label;
            it = (Number)object;
            boolean bl6 = false;
            GridLine px = new GridLine(it, xy, 0, 4, null);
            consumer = this.getRanges().getYPainter();
            p0 = px;
            boolean bl7 = false;
            consumer.accept(p0);
            gl = px;
            int py = MathKt.roundToInt((double)this.findGridLineY(gl, it));
            if (gl.getPaintLine()) {
                if (Math.abs(tmp - py) < 1) continue;
                tmp = py;
                grid.setColor(gl.getMajorLine() ? gcd : gc);
                grid.drawLine(bounds.x, py, bounds.x + bounds.width, py);
            }
            if (gl.getLabel() == null) continue;
            boolean bl8 = false;
            chart.setColor(this.gridLabelColor);
            coordinates = this.findGridLabelOffset(gl, chart);
            x = coordinates.component1();
            y = coordinates.component2();
            chart.drawString(label, xOrigin + this.getMargins().left - (int)x, py + this.getMargins().top + (int)y);
        }
    }

    protected double findGridLineX(@NotNull GridLine<X, Y, ?> gl, @NotNull X x) {
        Intrinsics.checkNotNullParameter(gl, (String)"gl");
        Intrinsics.checkNotNullParameter(x, (String)"x");
        return this.findX(gl.getXY(), x);
    }

    protected double findGridLineY(@NotNull GridLine<X, Y, ?> gl, @NotNull Y y) {
        Intrinsics.checkNotNullParameter(gl, (String)"gl");
        Intrinsics.checkNotNullParameter(y, (String)"y");
        return this.findY(gl.getXY(), y);
    }

    @NotNull
    public abstract MinMax<X, Y> findMinMax();

    protected double findX(@NotNull MinMax<X, Y> xy, @NotNull X x) {
        Intrinsics.checkNotNullParameter(xy, (String)"xy");
        Intrinsics.checkNotNullParameter(x, (String)"x");
        int width = this.getWidth() - (this.getMargins().left + this.getMargins().right);
        double it = (double)width * (((Number)x).doubleValue() - ((Number)xy.getXMin()).doubleValue()) / (((Number)xy.getXMax()).doubleValue() - ((Number)xy.getXMin()).doubleValue());
        boolean bl = false;
        return Math.abs(it) <= Double.MAX_VALUE ? it : 0.0;
    }

    protected double findY(@NotNull MinMax<X, Y> xy, @NotNull Y y) {
        Intrinsics.checkNotNullParameter(xy, (String)"xy");
        Intrinsics.checkNotNullParameter(y, (String)"y");
        int height = this.getHeight() - (this.getMargins().top + this.getMargins().bottom);
        double it = (double)height - (double)height * (((Number)y).doubleValue() - ((Number)xy.getYMin()).doubleValue()) / (((Number)xy.getYMax()).doubleValue() - ((Number)xy.getYMin()).doubleValue());
        boolean bl = false;
        return Math.abs(it) <= Double.MAX_VALUE ? it : 0.0;
    }

    @NotNull
    protected Coordinates<Double, Double> findGridLabelOffset(@NotNull GridLine<?, ?, ?> line, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        double s = JBUI.scale((int)4);
        Rectangle2D b = g.getFontMetrics().getStringBounds(line.getLabel(), null);
        double x = switch (line.getHorizontalAlignment()) {
            case 4 -> -s;
            case 0 -> b.getWidth() / (double)2;
            case 2 -> b.getWidth() + s;
            default -> -s;
        };
        double d = b.getHeight();
        double y = d - (switch (line.getVerticalAlignment()) {
            case 1 -> b.getHeight() + s;
            case 0 -> b.getHeight() / (double)2 + s / (double)2;
            case 3 -> 0.0;
            default -> 0.0;
        });
        return ChartWrapperKt.to(x, y);
    }
}

