/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.charts;

import com.intellij.ui.JBColor;
import com.intellij.ui.charts.LineChart;
import com.intellij.ui.charts.Overlay;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00020\u0001B\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ui/charts/DragOverlay;", "Lcom/intellij/ui/charts/Overlay;", "Lcom/intellij/ui/charts/LineChart;", "onRelease", "Ljava/util/function/BiConsumer;", "Ljava/awt/Point;", "<init>", "(Ljava/util/function/BiConsumer;)V", "getOnRelease", "()Ljava/util/function/BiConsumer;", "startPoint", "afterChartInitialized", "", "paintComponent", "g", "Ljava/awt/Graphics2D;", "intellij.platform.ide.ui"})
public final class DragOverlay
extends Overlay<LineChart<?, ?, ?>> {
    @NotNull
    private final BiConsumer<Point, Point> onRelease;
    @Nullable
    private Point startPoint;

    public DragOverlay(@NotNull BiConsumer<Point, Point> onRelease) {
        Intrinsics.checkNotNullParameter(onRelease, (String)"onRelease");
        this.onRelease = onRelease;
    }

    @NotNull
    public final BiConsumer<Point, Point> getOnRelease() {
        return this.onRelease;
    }

    @Override
    public void afterChartInitialized() {
        ((LineChart)this.getChart()).getComponent().addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DragOverlay this$0;
            {
                this.this$0 = $receiver;
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point point = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                DragOverlay.access$setStartPoint$p(this.this$0, this.this$0.toChartSpace(point));
            }

            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point start = DragOverlay.access$getStartPoint$p(this.this$0);
                Point point = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                Point end = this.this$0.toChartSpace(point);
                DragOverlay.access$setStartPoint$p(this.this$0, null);
                if (start != null && end != null) {
                    this.this$0.getOnRelease().accept(start, end);
                }
            }
        });
    }

    @Override
    public void paintComponent(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Point start = this.startPoint;
        if (start == null) {
            return;
        }
        Point end = this.getMouseLocation();
        if (end == null) {
            return;
        }
        g.setColor((Color)JBColor.BLACK);
        g.drawRect(Math.min(start.x, end.x), Math.min(start.y, end.y), Math.abs(start.x - end.x), Math.abs(start.y - end.y));
    }

    public static final /* synthetic */ void access$setStartPoint$p(DragOverlay $this, Point point) {
        $this.startPoint = point;
    }

    public static final /* synthetic */ Point access$getStartPoint$p(DragOverlay $this) {
        return $this.startPoint;
    }
}

