/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.charts;

import com.intellij.ui.charts.BarChart;
import com.intellij.ui.charts.BarDataset;
import com.intellij.ui.charts.ChartWrapperKt;
import com.intellij.ui.charts.Coordinates;
import com.intellij.ui.charts.GridLine;
import com.intellij.ui.charts.MinMax;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J>\u0010\u0006\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\u000fH\u0014J(\u0010\u0010\u001a\u00020\u00112\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0014J)\u0010\u0015\u001a\u00020\u00112\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0016\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0017J0\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00132\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ui/charts/HorizontalBarChart;", "T", "", "Lcom/intellij/ui/charts/BarChart;", "<init>", "()V", "paintDataset", "", "Lcom/intellij/ui/charts/BarDataset;", "datasetIndex", "", "datasetCount", "g", "Ljava/awt/Graphics2D;", "xy", "Lcom/intellij/ui/charts/MinMax;", "findGridLineX", "", "gl", "Lcom/intellij/ui/charts/GridLine;", "x", "findY", "y", "(Lcom/intellij/ui/charts/MinMax;Ljava/lang/Number;)D", "findGridLabelOffset", "Lcom/intellij/ui/charts/Coordinates;", "line", "intellij.platform.ide.ui"})
@SourceDebugExtension(value={"SMAP\nBarChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarChart.kt\ncom/intellij/ui/charts/HorizontalBarChart\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1#2:149\n1878#3,3:150\n*S KotlinDebug\n*F\n+ 1 BarChart.kt\ncom/intellij/ui/charts/HorizontalBarChart\n*L\n87#1:150,3\n*E\n"})
public final class HorizontalBarChart<T extends Number>
extends BarChart<T> {
    /*
     * WARNING - void declaration
     */
    @Override
    protected void paintDataset(@NotNull BarDataset<T> $this$paintDataset, int datasetIndex, int datasetCount, @NotNull Graphics2D g, @NotNull MinMax<Integer, T> xy) {
        double min;
        boolean bl;
        Intrinsics.checkNotNullParameter($this$paintDataset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(xy, (String)"xy");
        boolean bl2 = bl = xy.getXMin() == 0;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-HorizontalBarChart$paintDataset$22 = false;
            String $i$a$-assert-HorizontalBarChart$paintDataset$22 = "Int value must start with 0";
            throw new AssertionError((Object)$i$a$-assert-HorizontalBarChart$paintDataset$22);
        }
        int columns = xy.getXMax() + 1;
        double max = Math.max(((Number)xy.getYMax()).doubleValue(), 0.0);
        if (max == (min = Double.min(((Number)xy.getYMin()).doubleValue(), 0.0))) {
            return;
        }
        Rectangle cb = g.getClipBounds();
        double z = (double)cb.height / (max - min);
        int axis = (int)(z * Math.abs(min));
        Iterable $this$forEachIndexed$iv = $this$paintDataset.getData();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Function1<T, String> toString;
            void value;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Number number = (Number)item$iv;
            int column = n;
            boolean bl3 = false;
            int h = 0;
            h = (int)(value.doubleValue() * z);
            int y = 0;
            y = cb.height - h - axis;
            int groupW = cb.width / columns - this.getGap();
            int groupX = column * cb.width / columns + this.getGap() / 2;
            int space = this.getSpace() < 0 ? Math.max(1, groupW / 10) : this.getSpace();
            int w = Math.max(1, (groupW - space * (datasetCount - 1)) / datasetCount);
            int x = groupX + datasetIndex * w + space * datasetIndex;
            if (h < 0) {
                y += h;
                h = Math.abs(h);
            }
            if ($this$paintDataset.getLineColor() != null) {
                boolean bl4 = false;
                g.setPaint($this$paintDataset.getLineColor());
                g.drawRect(x, y, w, h);
            }
            if ($this$paintDataset.getFillColor() != null) {
                Paint it;
                boolean bl5 = false;
                g.setPaint(it);
                g.fillRect(x, y, w, h);
            }
            if ($this$paintDataset.getStacked()) {
                Area area = new Area(g.getClip());
                area.subtract(new Area(new Rectangle(x, y, w, h)));
                g.setClip(area);
            }
            if ($this$paintDataset.getShowValues() == null) continue;
            boolean bl6 = false;
            String str = (String)toString.invoke((Object)value);
            Rectangle2D bounds = g.getFontMetrics().getStringBounds(str, g);
            g.drawString(str, x + (w - (int)bounds.getWidth()) / 2, y - 5);
        }
    }

    @Override
    protected double findGridLineX(@NotNull GridLine<Integer, T, ?> gl, int x) {
        Intrinsics.checkNotNullParameter(gl, (String)"gl");
        return (double)this.getGridWidth() * ((double)(x + 1) - (double)((Number)gl.getXY().getXMin()).intValue()) / ((double)((Number)gl.getXY().getXMax()).intValue() - (double)((Number)gl.getXY().getXMin()).intValue() + 1.0);
    }

    @Override
    protected double findY(@NotNull MinMax<Integer, T> xy, @NotNull T y) {
        Intrinsics.checkNotNullParameter(xy, (String)"xy");
        Intrinsics.checkNotNullParameter(y, (String)"y");
        boolean isRanged = ((Number)xy.getYMin()).doubleValue() <= 0.0 && 0.0 <= ((Number)xy.getYMax()).doubleValue();
        double yMin = isRanged || ((Number)xy.getYMin()).doubleValue() < 0.0 ? ((Number)xy.getYMin()).doubleValue() : 0.0;
        double yMax = isRanged || ((Number)xy.getYMax()).doubleValue() > 0.0 ? ((Number)xy.getYMax()).doubleValue() : 0.0;
        int height = this.getHeight() - (this.getMargins().top + this.getMargins().bottom);
        return (double)height - (double)height * (((Number)y).doubleValue() - yMin) / (yMax - yMin);
    }

    @Override
    @NotNull
    protected Coordinates<Double, Double> findGridLabelOffset(@NotNull GridLine<?, ?, ?> line, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Coordinates<Double, Double> onLineAlignment = super.findGridLabelOffset(line, g);
        if (line.getOrientation() == 1) {
            int width = this.getWidth() - (this.getMargins().left + this.getMargins().right);
            double columnWidth = (double)width / (((Number)line.getXY().getXMax()).doubleValue() - ((Number)line.getXY().getXMin()).doubleValue() + 1.0);
            return ChartWrapperKt.to(onLineAlignment.getX() + columnWidth / (double)2, onLineAlignment.getY());
        }
        return onLineAlignment;
    }
}

