/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.WhatsNewAction;
import com.intellij.ide.actions.WhatsNewUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.AppMode;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.InitialConfigImportState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.updateSettings.impl.IdeUpdateUsageTriggerCollector;
import com.intellij.openapi.updateSettings.impl.Product;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.ide.customization.ExternalProductResourceUrls;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.Url;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class UpdateCheckerService {
    static final String SELF_UPDATE_STARTED_FOR_BUILD_PROPERTY = "ide.self.update.started.for.build";
    static final Logger LOG = Logger.getInstance(UpdateCheckerService.class);
    private static final long CHECK_INTERVAL_MS = TimeUnit.MINUTES.toMillis(Long.getLong("ide.updates.check.interval.minutes", TimeUnit.DAYS.toMinutes(1L)));
    private static final String ERROR_LOG_FILE_NAME = "idea_updater_error.log";
    private static final String PREVIOUS_BUILD_NUMBER_PROPERTY = "ide.updates.previous.build.number";
    private volatile ScheduledFuture<?> myScheduledCheck;

    public static UpdateCheckerService getInstance() {
        return (UpdateCheckerService)ApplicationManager.getApplication().getService(UpdateCheckerService.class);
    }

    public void queueNextCheck() {
        this.queueNextCheck(CHECK_INTERVAL_MS);
    }

    public void cancelChecks() {
        ScheduledFuture<?> future = this.myScheduledCheck;
        if (future != null) {
            future.cancel(false);
        }
    }

    private void appStarted() {
        UpdateSettings settings = UpdateSettings.getInstance();
        UpdateCheckerService.updateDefaultChannel(settings);
        if (settings.isCheckNeeded() || settings.isPluginsCheckNeeded()) {
            this.scheduleFirstCheck(settings);
        }
    }

    private static void updateDefaultChannel(UpdateSettings settings) {
        ChannelStatus current = settings.getSelectedChannelStatus();
        LOG.info("channel: " + current.getCode());
        UpdateStrategyCustomization customization = UpdateStrategyCustomization.getInstance();
        ChannelStatus changedChannel = customization.changeDefaultChannel(current);
        if (changedChannel != null) {
            settings.setSelectedChannelStatus(changedChannel);
            LOG.info("channel set to '" + changedChannel.getCode() + "' by " + customization.getClass().getName());
            return;
        }
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        if (appInfo.isMajorEAP() && current != ChannelStatus.EAP && customization.forceEapUpdateChannelForEapBuilds()) {
            settings.setSelectedChannelStatus(ChannelStatus.EAP);
            LOG.info("channel forced to 'eap'");
            if (!InitialConfigImportState.isFirstSession()) {
                String title = IdeBundle.message((String)"updates.notification.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
                String message = IdeBundle.message((String)"update.channel.enforced", (Object[])new Object[]{ChannelStatus.EAP});
                UpdateChecker.getNotificationGroup().createNotification(title, message, NotificationType.INFORMATION).setDisplayId("ide.update.channel.switched").notify(null);
            }
        }
        if (!appInfo.isEAP() && !appInfo.isPreview() && current == ChannelStatus.EAP && InitialConfigImportState.isConfigImported()) {
            settings.setSelectedChannelStatus(ChannelStatus.RELEASE);
            LOG.info("channel set to 'release'");
        }
    }

    public void scheduleFirstCheck(UpdateSettings settings) {
        BuildNumber currentBuild = ApplicationInfo.getInstance().getBuild();
        BuildNumber lastBuildChecked = BuildNumber.fromString((String)settings.getLastBuildChecked());
        long timeSinceLastCheck = Math.max(System.currentTimeMillis() - settings.getLastTimeChecked(), 0L);
        if (lastBuildChecked == null || currentBuild.compareTo(lastBuildChecked) > 0 || timeSinceLastCheck >= CHECK_INTERVAL_MS) {
            this.checkUpdates();
        } else {
            this.queueNextCheck(CHECK_INTERVAL_MS - timeSinceLastCheck);
        }
    }

    private void queueNextCheck(long delay) {
        this.myScheduledCheck = AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> this.checkUpdates(), delay, TimeUnit.MILLISECONDS);
    }

    private void checkUpdates() {
        UpdateChecker.updateAndShowResult().doWhenProcessed(() -> {
            UpdateSettings settings = UpdateSettings.getInstance();
            if (settings.isCheckNeeded() || settings.isPluginsCheckNeeded()) {
                this.queueNextCheck();
            }
        });
    }

    static void checkIfPreviousUpdateFailed(BuildNumber current) {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (current.asString().equals(properties.getValue(SELF_UPDATE_STARTED_FOR_BUILD_PROPERTY)) && NioFiles.sizeIfExists((Path)Path.of(PathManager.getLogPath(), ERROR_LOG_FILE_NAME)) > 0L) {
            IdeUpdateUsageTriggerCollector.UPDATE_FAILED.log();
            LOG.info("The previous IDE update failed");
        }
        properties.unsetValue(SELF_UPDATE_STARTED_FOR_BUILD_PROPERTY);
    }

    static void showWhatsNew(Project project, BuildNumber current) {
        Url url = ExternalProductResourceUrls.getInstance().getWhatIsNewPageUrl();
        if (url != null && WhatsNewUtil.isWhatsNewAvailable() && UpdateCheckerService.shouldShowWhatsNew(current, ApplicationInfoEx.getInstanceEx().isMajorEAP())) {
            if (UpdateSettings.getInstance().isShowWhatsNewEditor()) {
                ApplicationManager.getApplication().invokeLater(() -> WhatsNewAction.openWhatsNewPage((Project)project, (String)url.toExternalForm(), (boolean)true), project.getDisposed());
                IdeUpdateUsageTriggerCollector.majorUpdateHappened(true);
            } else {
                IdeUpdateUsageTriggerCollector.majorUpdateHappened(false);
            }
        }
    }

    @VisibleForTesting
    public static boolean shouldShowWhatsNew(@NotNull BuildNumber current, boolean majorEap) {
        int lastRelease;
        Product product;
        if (current == null) {
            UpdateCheckerService.$$$reportNull$$$0(0);
        }
        if (ExperimentalUI.Companion.getForcedSwitchedUi()) {
            return false;
        }
        UpdateSettings settings = UpdateSettings.getInstance();
        int lastShownFor = settings.getWhatsNewShownFor();
        if (lastShownFor == 0) {
            settings.setWhatsNewShownFor(current.getBaselineVersion());
            return false;
        }
        if (!majorEap && lastShownFor < current.getBaselineVersion() && (product = UpdateCheckerService.loadProductData()) != null && (lastRelease = product.getChannels().stream().filter(channel -> channel.getLicensing() == UpdateChannel.Licensing.RELEASE && channel.getStatus() == ChannelStatus.RELEASE).flatMap(channel -> channel.getBuilds().stream()).mapToInt(build -> build.getNumber().getBaselineVersion()).max().orElse(0)) == current.getBaselineVersion()) {
            settings.setWhatsNewShownFor(current.getBaselineVersion());
            return true;
        }
        return false;
    }

    static void showSnapUpdateNotification(Project project, BuildNumber current) {
        if (ExternalUpdateManager.ACTUAL != ExternalUpdateManager.SNAP) {
            return;
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        BuildNumber previous = BuildNumber.fromString((String)properties.getValue(PREVIOUS_BUILD_NUMBER_PROPERTY));
        properties.setValue(PREVIOUS_BUILD_NUMBER_PROPERTY, current.asString());
        if (previous == null || current.equals((Object)previous)) {
            return;
        }
        String blogPost = null;
        Product product = UpdateCheckerService.loadProductData();
        if (product != null) {
            blogPost = product.getChannels().stream().flatMap(channel -> channel.getBuilds().stream()).filter(build -> current.equals((Object)build.getNumber())).findFirst().map(BuildInfo::getBlogPost).orElse(null);
        }
        String title = IdeBundle.message((String)"updates.notification.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        String message = IdeBundle.message((String)"update.snap.message", (Object[])new Object[0]);
        Notification notification = UpdateChecker.getNotificationGroupForIdeUpdateResults().createNotification(title, message, NotificationType.INFORMATION).setDisplayId("ide.updated.by.snap");
        if (blogPost != null) {
            String url = StringUtil.escapeXmlEntities((String)blogPost);
            notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)IdeBundle.message((String)"update.snap.blog.post.action", (Object[])new Object[0]), () -> BrowserUtil.browse((String)url)));
        }
        notification.notify(project);
    }

    @Nullable
    private static Product loadProductData() {
        try {
            return UpdateChecker.loadProductData(null);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    static void showUpdatedPluginsNotification(Project project) {
        ApplicationManager.getApplication().getMessageBus().simpleConnect().subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            public void appWillBeClosed(boolean isRestart) {
                Collection plugins2 = InstalledPluginsState.getInstance().getUpdatedPlugins();
                if (plugins2.isEmpty()) {
                    return;
                }
                Set<String> idStrings = UpdateCheckerService.getUpdatedPlugins();
                for (PluginId plugin : plugins2) {
                    idStrings.add(plugin.getIdString());
                }
                try {
                    Files.write(UpdateCheckerService.getUpdatedPluginsFile(), idStrings, new OpenOption[0]);
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
        });
        ArrayList<HtmlChunk.Element> links = new ArrayList<HtmlChunk.Element>();
        for (String id : UpdateCheckerService.getUpdatedPlugins()) {
            PluginId pluginId = PluginId.getId((String)id);
            IdeaPluginDescriptor descriptor = PluginManagerCore.getPlugin((PluginId)pluginId);
            if (descriptor == null) continue;
            links.add(HtmlChunk.link((String)id, (String)descriptor.getName()));
        }
        if (links.isEmpty()) {
            return;
        }
        String title = IdeBundle.message((String)"update.installed.notification.title", (Object[])new Object[0]);
        String text = new HtmlBuilder().appendWithSeparators(HtmlChunk.text((String)", "), links).wrapWith("html").toString();
        UpdateChecker.getNotificationGroupForPluginUpdateResults().createNotification(title, text, NotificationType.INFORMATION).setListener((__, e) -> UpdateCheckerService.showPluginConfigurable(e, project)).setDisplayId("plugins.updated.after.restart").notify(project);
    }

    private static void showPluginConfigurable(HyperlinkEvent event, Project project) {
        String id = event.getDescription();
        if (id != null) {
            PluginId pluginId = PluginId.getId((String)id);
            PluginManagerConfigurable.showPluginConfigurable((Project)project, List.of(pluginId));
        }
    }

    private static Set<String> getUpdatedPlugins() {
        try {
            Path file = UpdateCheckerService.getUpdatedPluginsFile();
            if (Files.isRegularFile(file, new LinkOption[0])) {
                List<String> list = Files.readAllLines(file);
                Files.delete(file);
                return new HashSet<String>(list);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return new HashSet<String>();
    }

    private static Path getUpdatedPluginsFile() {
        return Path.of(PathManager.getConfigPath(), ".updated_plugins_list");
    }

    static void pruneUpdateSettings() {
        BuildNumber currentBuild;
        boolean cleaned;
        List ignoredBuildNumbers;
        UpdateSettings settings = UpdateSettings.getInstance();
        if (settings.isObsoleteCustomRepositoriesCleanNeeded()) {
            boolean cleaned2 = settings.getStoredPluginHosts().removeIf(host -> host.startsWith("https://secure.feed.toolbox.app/plugins"));
            if (cleaned2) {
                LOG.info("Some obsolete TBE custom repositories have been removed");
            }
            settings.setObsoleteCustomRepositoriesCleanNeeded(false);
        }
        if (!(ignoredBuildNumbers = settings.getIgnoredBuildNumbers()).isEmpty() && (cleaned = ignoredBuildNumbers.removeIf(arg_0 -> UpdateCheckerService.lambda$pruneUpdateSettings$11(currentBuild = ApplicationInfo.getInstance().getBuild(), arg_0)))) {
            LOG.info("Some obsolete ignored versions have been removed");
        }
    }

    private static /* synthetic */ boolean lambda$pruneUpdateSettings$11(BuildNumber currentBuild, String str) {
        BuildNumber bn = BuildNumber.fromStringOrNull((String)str);
        return bn != null && currentBuild.compareTo(bn) >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/openapi/updateSettings/impl/UpdateCheckerService", "shouldShowWhatsNew"));
    }

    static final class MyAppLifecycleListener
    implements AppLifecycleListener {
        MyAppLifecycleListener() {
        }

        public void appStarted() {
            Application app = ApplicationManager.getApplication();
            if (!(app.isCommandLine() || app.isHeadlessEnvironment() || app.isUnitTestMode() || AppMode.isRemoteDevHost())) {
                UpdateCheckerService.getInstance().appStarted();
            }
        }
    }
}

