/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.WhatsNewUtil;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.ide.plugins.PluginManagementPolicy;
import com.intellij.ide.plugins.newui.PluginLogoKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.updateSettings.impl.PluginAutoUpdateListener;
import com.intellij.openapi.updateSettings.impl.PluginAutoUpdateService;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerService;
import com.intellij.openapi.updateSettings.impl.UpdateOptions;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsUIProvider;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.EmptySpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsYKt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.DateFormatUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateSettingsConfigurable;", "Lcom/intellij/openapi/options/BoundConfigurable;", "checkNowEnabled", "", "<init>", "(Z)V", "myLink", "Ljavax/swing/JComponent;", "myLastCheckedLabel", "Ljavax/swing/JEditorPane;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "selectedChannel", "Lcom/intellij/openapi/updateSettings/impl/ChannelStatus;", "value", "updateLastCheckedLabel", "", "time", "", "intellij.platform.ide.updateChecker"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nUpdateSettingsConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateSettingsConfigurable.kt\ncom/intellij/openapi/updateSettings/impl/UpdateSettingsConfigurable\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,204:1\n42#2,3:205\n42#2,3:208\n*S KotlinDebug\n*F\n+ 1 UpdateSettingsConfigurable.kt\ncom/intellij/openapi/updateSettings/impl/UpdateSettingsConfigurable\n*L\n90#1:205,3\n84#1:208,3\n*E\n"})
public final class UpdateSettingsConfigurable
extends BoundConfigurable {
    private final boolean checkNowEnabled;
    private JComponent myLink;
    private JEditorPane myLastCheckedLabel;

    @JvmOverloads
    public UpdateSettingsConfigurable(boolean checkNowEnabled) {
        String string = IdeBundle.message((String)"updates.settings.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "preferences.updates");
        this.checkNowEnabled = checkNowEnabled;
    }

    public /* synthetic */ UpdateSettingsConfigurable(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @NotNull
    public DialogPanel createPanel() {
        UpdateSettings settings = UpdateSettings.getInstance();
        ExternalUpdateManager manager = ExternalUpdateManager.ACTUAL;
        String channelSelectionLockedMessage = UpdateStrategyCustomization.Companion.getInstance().getChannelSelectionLockedMessage();
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        CollectionComboBoxModel channelModel = new CollectionComboBoxModel(settings.getActiveChannels());
        return BuilderKt.panel(arg_0 -> UpdateSettingsConfigurable.createPanel$lambda$0(appInfo, settings, manager, channelSelectionLockedMessage, channelModel, this, arg_0));
    }

    private final ChannelStatus selectedChannel(ChannelStatus value) {
        ChannelStatus channelStatus = value;
        if (channelStatus == null) {
            channelStatus = ChannelStatus.RELEASE;
        }
        return channelStatus;
    }

    private final void updateLastCheckedLabel(long time) {
        if (time > 0L) {
            JEditorPane jEditorPane = this.myLastCheckedLabel;
            if (jEditorPane == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myLastCheckedLabel");
                jEditorPane = null;
            }
            Object[] objectArray = new Object[]{DateFormatUtil.formatPrettyDateTime((long)time)};
            jEditorPane.setText(IdeBundle.message((String)"updates.settings.last.check", (Object[])objectArray));
            JEditorPane jEditorPane2 = this.myLastCheckedLabel;
            if (jEditorPane2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myLastCheckedLabel");
                jEditorPane2 = null;
            }
            jEditorPane2.setToolTipText(DateFormatUtil.formatDate((long)time) + " " + DateFormatUtil.formatTimeWithSeconds((long)time));
        } else {
            JEditorPane jEditorPane = this.myLastCheckedLabel;
            if (jEditorPane == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myLastCheckedLabel");
                jEditorPane = null;
            }
            Object[] objectArray = new Object[]{IdeBundle.message((String)"updates.last.check.never", (Object[])new Object[0])};
            jEditorPane.setText(IdeBundle.message((String)"updates.settings.last.check", (Object[])objectArray));
            JEditorPane jEditorPane3 = this.myLastCheckedLabel;
            if (jEditorPane3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myLastCheckedLabel");
                jEditorPane3 = null;
            }
            jEditorPane3.setToolTipText(null);
        }
    }

    @JvmOverloads
    public UpdateSettingsConfigurable() {
        this(false, 1, null);
    }

    private static final Unit createPanel$lambda$0(ApplicationInfo $appInfo, UpdateSettings $settings, ExternalUpdateManager $manager, String $channelSelectionLockedMessage, CollectionComboBoxModel $channelModel, UpdateSettingsConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row(IdeBundle.message((String)"updates.settings.current.version", (Object[])new Object[0]) + " " + ApplicationNamesInfo.getInstance().getFullProductName() + " " + $appInfo.getFullVersion(), arg_0 -> UpdateSettingsConfigurable.createPanel$lambda$0$0($appInfo, arg_0)).bottomGap(BottomGap.SMALL);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> UpdateSettingsConfigurable.createPanel$lambda$0$1($manager, $channelSelectionLockedMessage, $settings, $channelModel, this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> UpdateSettingsConfigurable.createPanel$lambda$0$2($settings, arg_0), (int)1, null);
        $this$panel.indent(arg_0 -> UpdateSettingsConfigurable.createPanel$lambda$0$3($settings, this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> UpdateSettingsConfigurable.createPanel$lambda$0$4(this$0, $settings, $channelSelectionLockedMessage, $channelModel, arg_0), (int)1, null).topGap(TopGap.SMALL).bottomGap(BottomGap.SMALL);
        if (WhatsNewUtil.isWhatsNewAvailable()) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> UpdateSettingsConfigurable.createPanel$lambda$0$5($settings, arg_0), (int)1, null);
        }
        List list = $settings.getIgnoredBuildNumbers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIgnoredBuildNumbers(...)");
        if (!((Collection)list).isEmpty()) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> UpdateSettingsConfigurable.createPanel$lambda$0$6(this$0, $settings, arg_0), (int)1, null);
        }
        UpdateSettingsUIProvider.Companion.getEP_NAME().forEachExtensionSafe(arg_0 -> UpdateSettingsConfigurable.createPanel$lambda$0$8(arg_0 -> UpdateSettingsConfigurable.createPanel$lambda$0$7($this$panel, arg_0), arg_0));
        if ($manager != ExternalUpdateManager.TOOLBOX && !Registry.Companion.is("ide.hide.toolbox.promo")) {
            Panel.group$default((Panel)$this$panel, null, (boolean)false, UpdateSettingsConfigurable::createPanel$lambda$0$9, (int)1, null);
        }
        Ref.BooleanRef wasEnabled = new Ref.BooleanRef();
        wasEnabled.element = $settings.isCheckNeeded() || $settings.isPluginsCheckNeeded();
        $this$panel.onApply(() -> UpdateSettingsConfigurable.createPanel$lambda$0$10($settings, wasEnabled));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(ApplicationInfo $appInfo, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comment$default((Row)$this$row, (String)($appInfo.getBuild().asString() + " " + NlsMessages.formatDateLong((Date)$appInfo.getBuildDate().getTime())), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(ExternalUpdateManager $manager, String $channelSelectionLockedMessage, UpdateSettings $settings, CollectionComboBoxModel $channelModel, UpdateSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        if ($manager != null) {
            Object[] objectArray = new Object[]{$manager.toolName};
            String string = IdeBundle.message((String)"updates.settings.external", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            v1 = Row.comment$default((Row)$this$row, (String)string, (int)0, null, (int)6, null);
        } else if ($channelSelectionLockedMessage != null) {
            String string = IdeBundle.message((String)"updates.settings.checkbox", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Cell cell = $this$row.checkBox(string);
            UpdateOptions updateOptions = $settings.getState();
            Intrinsics.checkNotNullExpressionValue((Object)updateOptions, (String)"getState(...)");
            ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(updateOptions){

                public Object get() {
                    return ((UpdateOptions)this.receiver).isCheckNeeded();
                }

                public void set(Object value) {
                    ((UpdateOptions)this.receiver).setCheckNeeded(((Boolean)value).booleanValue());
                }
            }));
            v1 = Row.comment$default((Row)$this$row, (String)$channelSelectionLockedMessage, (int)0, null, (int)6, null);
        } else {
            String string = IdeBundle.message((String)"updates.settings.checkbox.for", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Cell cell = $this$row.checkBox(string);
            UpdateOptions updateOptions = $settings.getState();
            Intrinsics.checkNotNullExpressionValue((Object)updateOptions, (String)"getState(...)");
            Cell checkBox2 = ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(updateOptions){

                public Object get() {
                    return ((UpdateOptions)this.receiver).isCheckNeeded();
                }

                public void set(Object value) {
                    ((UpdateOptions)this.receiver).setCheckNeeded(((Boolean)value).booleanValue());
                }
            })).gap(RightGap.SMALL);
            v1 = ComboBoxKt.bindItem((Cell)Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)$channelModel), null, (int)2, null), () -> UpdateSettingsConfigurable.createPanel$lambda$0$1$0($settings), arg_0 -> UpdateSettingsConfigurable.createPanel$lambda$0$1$1($settings, this$0, arg_0)).enabledIf(ButtonKt.getSelected((Cell)checkBox2));
        }
        return Unit.INSTANCE;
    }

    private static final ChannelStatus createPanel$lambda$0$1$0(UpdateSettings $settings) {
        return $settings.getSelectedActiveChannel();
    }

    private static final Unit createPanel$lambda$0$1$1(UpdateSettings $settings, UpdateSettingsConfigurable this$0, ChannelStatus it) {
        $settings.setSelectedChannelStatus(this$0.selectedChannel(it));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2(UpdateSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"updates.plugins.settings.checkbox", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        UpdateOptions updateOptions = $settings.getState();
        Intrinsics.checkNotNullExpressionValue((Object)updateOptions, (String)"getState(...)");
        ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(updateOptions){

            public Object get() {
                return ((UpdateOptions)this.receiver).isPluginsCheckNeeded();
            }

            public void set(Object value) {
                ((UpdateOptions)this.receiver).setPluginsCheckNeeded(((Boolean)value).booleanValue());
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3(UpdateSettings $settings, UpdateSettingsConfigurable this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, arg_0 -> UpdateSettingsConfigurable.createPanel$lambda$0$3$0($settings, this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3$0(UpdateSettings $settings, UpdateSettingsConfigurable this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"updates.plugins.autoupdate.settings.checkbox", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell2 = $this$row.checkBox(string);
        UpdateOptions updateOptions = $settings.getState();
        Intrinsics.checkNotNullExpressionValue((Object)updateOptions, (String)"getState(...)");
        Cell it = cell = Cell.comment$default((Cell)ButtonKt.bindSelected((Cell)cell2, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(updateOptions){

            public Object get() {
                return ((UpdateOptions)this.receiver).isPluginsAutoUpdateEnabled();
            }

            public void set(Object value) {
                ((UpdateOptions)this.receiver).setPluginsAutoUpdateEnabled(((Boolean)value).booleanValue());
            }
        })), (String)IdeBundle.message((String)"updates.plugins.autoupdate.settings.comment", (Object[])new Object[0]), (int)0, null, (int)6, null).onApply(UpdateSettingsConfigurable::createPanel$lambda$0$3$0$0);
        boolean bl = false;
        if (!PluginManagementPolicy.Companion.getInstance().isPluginAutoUpdateAllowed()) {
            if ($settings.isPluginsAutoUpdateEnabled()) {
                $settings.setPluginsAutoUpdateEnabled(false);
                boolean $i$f$service = false;
                Class<PluginAutoUpdateService> serviceClass$iv = PluginAutoUpdateService.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                ((PluginAutoUpdateService)object).onSettingsChanged();
            }
            $this$row.enabled(false);
            Icon icon = AllIcons.General.Warning;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Warning");
            $this$row.icon(icon).applyToComponent(UpdateSettingsConfigurable::createPanel$lambda$0$3$0$1$0);
        } else {
            MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
            Disposable disposable = this$0.getDisposable();
            Intrinsics.checkNotNull((Object)disposable);
            MessageBusConnection connect = messageBus.connect(disposable);
            JBCheckBox component = (JBCheckBox)it.getComponent();
            connect.subscribe(PluginAutoUpdateListener.Companion.getTOPIC(), (Object)new PluginAutoUpdateListener(component, $settings){
                final /* synthetic */ JBCheckBox $component;
                final /* synthetic */ UpdateSettings $settings;
                {
                    this.$component = $component;
                    this.$settings = $settings;
                }

                public void settingsChanged() {
                    UpdateOptions updateOptions = this.$settings.getState();
                    Intrinsics.checkNotNullExpressionValue((Object)updateOptions, (String)"getState(...)");
                    this.$component.setSelected(((Boolean)((KMutableProperty0)new MutablePropertyReference0Impl(updateOptions){

                        public Object get() {
                            return ((UpdateOptions)this.receiver).isPluginsAutoUpdateEnabled();
                        }

                        public void set(Object value) {
                            ((UpdateOptions)this.receiver).setPluginsAutoUpdateEnabled(((Boolean)value).booleanValue());
                        }
                    }).get()).booleanValue());
                }
            });
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3$0$0() {
        boolean $i$f$service = false;
        Class<PluginAutoUpdateService> serviceClass$iv = PluginAutoUpdateService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((PluginAutoUpdateService)object).onSettingsChanged();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3$0$1$0(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setToolTipText(IdeBundle.message((String)"updates.plugins.autoupdate.settings.prohibited.by.policy.comment", (Object[])new Object[0]));
        $this$applyToComponent.setEnabled(true);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$4(UpdateSettingsConfigurable this$0, UpdateSettings $settings, String $channelSelectionLockedMessage, CollectionComboBoxModel $channelModel, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        if (this$0.checkNowEnabled) {
            String string = IdeBundle.message((String)"updates.settings.check.now.button", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$row.button(string, arg_0 -> UpdateSettingsConfigurable.createPanel$lambda$0$4$0(this$0, $settings, $channelSelectionLockedMessage, $channelModel, arg_0));
        }
        this$0.myLastCheckedLabel = (JEditorPane)Row.comment$default((Row)$this$row, (String)"", (int)0, null, (int)6, null).getComponent();
        this$0.updateLastCheckedLabel($settings.getLastTimeChecked());
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$4$0(UpdateSettingsConfigurable this$0, UpdateSettings $settings, String $channelSelectionLockedMessage, CollectionComboBoxModel $channelModel, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DataManager dataManager = DataManager.getInstance();
        JEditorPane jEditorPane = this$0.myLastCheckedLabel;
        if (jEditorPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myLastCheckedLabel");
            jEditorPane = null;
        }
        DataContext dataContext = dataManager.getDataContext((Component)jEditorPane);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        UpdateSettings settingsCopy = new UpdateSettings();
        UpdateOptions updateOptions = settingsCopy.getState();
        Intrinsics.checkNotNullExpressionValue((Object)updateOptions, (String)"getState(...)");
        BaseState baseState = (BaseState)updateOptions;
        UpdateOptions updateOptions2 = $settings.getState();
        Intrinsics.checkNotNullExpressionValue((Object)updateOptions2, (String)"getState(...)");
        BaseState.copyFrom$default((BaseState)baseState, (BaseState)((BaseState)updateOptions2), (boolean)false, (int)2, null);
        settingsCopy.setCheckNeeded(true);
        settingsCopy.setPluginsCheckNeeded(true);
        if ($channelSelectionLockedMessage == null) {
            settingsCopy.setSelectedChannelStatus(this$0.selectedChannel((ChannelStatus)$channelModel.getSelected()));
        }
        UpdateChecker.updateAndShowResult(project, settingsCopy);
        this$0.updateLastCheckedLabel($settings.getLastTimeChecked());
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$5(UpdateSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"updates.settings.show.editor", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        UpdateOptions updateOptions = $settings.getState();
        Intrinsics.checkNotNullExpressionValue((Object)updateOptions, (String)"getState(...)");
        ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(updateOptions){

            public Object get() {
                return ((UpdateOptions)this.receiver).isShowWhatsNewEditor();
            }

            public void set(Object value) {
                ((UpdateOptions)this.receiver).setShowWhatsNewEditor(((Boolean)value).booleanValue());
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$6(UpdateSettingsConfigurable this$0, UpdateSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"updates.settings.ignored", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.myLink = $this$row.link(string, arg_0 -> UpdateSettingsConfigurable.createPanel$lambda$0$6$0($settings, this$0, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$6$0(UpdateSettings $settings, UpdateSettingsConfigurable this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List list = $settings.getIgnoredBuildNumbers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIgnoredBuildNumbers(...)");
        String text = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        DataManager dataManager = DataManager.getInstance();
        JComponent jComponent = this$0.myLink;
        if (jComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myLink");
            jComponent = null;
        }
        DataContext dataContext = dataManager.getDataContext((Component)jComponent);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        String result = Messages.showMultilineInputDialog((Project)project, null, (String)IdeBundle.message((String)"updates.settings.ignored.title", (Object[])new Object[0]), (String)text, null, null);
        if (result != null) {
            $settings.getIgnoredBuildNumbers().clear();
            char[] cArray = new char[]{'\n'};
            $settings.getIgnoredBuildNumbers().addAll(StringsKt.split$default((CharSequence)result, (char[])cArray, (boolean)false, (int)0, (int)6, null));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$7(Panel $this_panel, UpdateSettingsUIProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.init($this_panel);
        return Unit.INSTANCE;
    }

    private static final void createPanel$lambda$0$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createPanel$lambda$0$9(Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        $this$group.customizeSpacingConfiguration((SpacingConfiguration)new EmptySpacingConfiguration(), UpdateSettingsConfigurable::createPanel$lambda$0$9$0);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$9$0(Panel $this$customizeSpacingConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$customizeSpacingConfiguration, (String)"$this$customizeSpacingConfiguration");
        Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, UpdateSettingsConfigurable::createPanel$lambda$0$9$0$0, (int)1, null).customize(UnscaledGapsYKt.UnscaledGapsY$default((int)12, (int)0, (int)2, null));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$9$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon = AllIcons.Nodes.Toolbox;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Toolbox");
        $this$row.icon(PluginLogoKt.reloadPluginIcon((Icon)icon, (int)40, (int)40)).align((Align)AlignY.TOP.INSTANCE).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)0, (int)0, (int)10, (int)7, null));
        $this$row.panel(UpdateSettingsConfigurable::createPanel$lambda$0$9$0$0$0);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$9$0$0$0(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, UpdateSettingsConfigurable::createPanel$lambda$0$9$0$0$0$0, (int)1, null);
        Panel.row$default((Panel)$this$panel, null, UpdateSettingsConfigurable::createPanel$lambda$0$9$0$0$0$1, (int)1, null).customize(UnscaledGapsYKt.UnscaledGapsY$default((int)3, (int)0, (int)2, null));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$9$0$0$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{"https://www.jetbrains.com/toolbox-app/?utm_source=product&utm_medium=link&utm_campaign=toolbox_app_in_IDE_updatewindow&utm_content=we_recommend", ExternalUpdateManager.TOOLBOX.toolName};
        String string = IdeBundle.message((String)"updates.settings.recommend.toolbox", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.text$default((Row)$this$row, (String)string, (int)0, null, (int)6, null).bold();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$9$0$0$0$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"updates.settings.recommend.toolbox.multiline.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.text$default((Row)$this$row, (String)string, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$10(UpdateSettings $settings, Ref.BooleanRef $wasEnabled) {
        boolean isEnabled;
        boolean bl = isEnabled = $settings.isCheckNeeded() || $settings.isPluginsCheckNeeded();
        if (isEnabled != $wasEnabled.element) {
            UpdateCheckerService updateCheckerService;
            UpdateCheckerService $this$createPanel_u24lambda_u240_u2410_u240 = updateCheckerService = UpdateCheckerService.getInstance();
            boolean bl2 = false;
            if (isEnabled) {
                $this$createPanel_u24lambda_u240_u2410_u240.queueNextCheck();
            } else {
                $this$createPanel_u24lambda_u240_u2410_u240.cancelChecks();
            }
            $wasEnabled.element = isEnabled;
        }
        return Unit.INSTANCE;
    }
}

