/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.SettingsEntryPointAction;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.PluginStateManager;
import com.intellij.ide.plugins.newui.PluginModelAsyncOperationsExecutor;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.InternalPluginResults;
import com.intellij.openapi.updateSettings.impl.PlatformUpdateDialog;
import com.intellij.openapi.updateSettings.impl.PlatformUpdates;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateDialog;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UpdateSettingsEntryPointActionProvider
implements SettingsEntryPointAction.ActionProvider {
    private static final String NEXT_RUN_KEY_BUILD = "NextRunPlatformUpdateBuild";
    private static final String NEXT_RUN_KEY_VERSION = "NextRunPlatformUpdateVersion";
    private static final String NEXT_RUN_KEY_SELF_BUILD = "NextRunPlatformUpdateSelfBuild";
    private static boolean myNewPlatformUpdate;
    @Nullable
    private static String myNextRunPlatformUpdateVersion;
    @Nullable
    private static PlatformUpdates.Loaded myPlatformUpdateInfo;
    @Nullable
    private static List<String> myIncompatiblePluginNames;
    @Nullable
    private static Set<String> myAlreadyShownPluginUpdates;
    @Nullable
    private static Collection<PluginDownloader> myUpdatesForPlugins;
    @Nullable
    private static Collection<PluginUiModel> myCustomRepositoryPlugins;
    private static PluginUpdatesService myUpdatesService;
    private static PluginStateListener myPluginStateListener;
    private static boolean myEnableUpdateAction;

    UpdateSettingsEntryPointActionProvider() {
    }

    private static void preparePrevPlatformUpdate() {
        BuildNumber newBuildForUpdateSelfBuild;
        BuildNumber newBuildForUpdate;
        if (!UpdateSettings.getInstance().isCheckNeeded()) {
            return;
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        try {
            newBuildForUpdate = BuildNumber.fromString((String)properties.getValue(NEXT_RUN_KEY_BUILD));
            newBuildForUpdateSelfBuild = BuildNumber.fromString((String)properties.getValue(NEXT_RUN_KEY_SELF_BUILD));
        }
        catch (Exception ignore) {
            return;
        }
        if (newBuildForUpdate != null && newBuildForUpdateSelfBuild != null) {
            if (newBuildForUpdate.compareTo(ApplicationInfo.getInstance().getBuild()) > 0 && newBuildForUpdateSelfBuild.compareTo(ApplicationInfo.getInstance().getBuild()) == 0) {
                myNextRunPlatformUpdateVersion = properties.getValue(NEXT_RUN_KEY_VERSION);
                if (myNextRunPlatformUpdateVersion != null) {
                    myNewPlatformUpdate = true;
                    SettingsEntryPointAction.updateState();
                } else {
                    properties.unsetValue(NEXT_RUN_KEY_BUILD);
                    properties.unsetValue(NEXT_RUN_KEY_VERSION);
                    properties.unsetValue(NEXT_RUN_KEY_SELF_BUILD);
                }
            } else {
                properties.unsetValue(NEXT_RUN_KEY_BUILD);
                properties.unsetValue(NEXT_RUN_KEY_VERSION);
                properties.unsetValue(NEXT_RUN_KEY_SELF_BUILD);
            }
        }
    }

    private static void initPluginsListeners() {
        if (myUpdatesService == null) {
            myUpdatesService = PluginUpdatesService.connectWithUpdates(updateResult -> {
                if (updateResult == null) {
                    UpdateSettingsEntryPointActionProvider.newUpdatesForPlugins(null);
                    myCustomRepositoryPlugins = null;
                    return;
                }
                if (!UpdateSettings.getInstance().isPluginsCheckNeeded()) {
                    return;
                }
                UpdateSettingsEntryPointActionProvider.newUpdatesForPlugins(updateResult.getPluginUpdates().getAll());
                myCustomRepositoryPlugins = updateResult.getPluginNods();
            });
        }
        if (myPluginStateListener == null) {
            myPluginStateListener = new PluginStateListener(){

                public void install(@NotNull IdeaPluginDescriptor descriptor) {
                    if (descriptor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    UpdateSettingsEntryPointActionProvider.removePluginsUpdate(List.of(descriptor));
                }

                public void uninstall(@NotNull IdeaPluginDescriptor descriptor) {
                    if (descriptor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.install(descriptor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "descriptor";
                    objectArray2[1] = "com/intellij/openapi/updateSettings/impl/UpdateSettingsEntryPointActionProvider$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "install";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "uninstall";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            PluginStateManager.addStateListener((PluginStateListener)myPluginStateListener);
        }
    }

    private static void clearUpdatesInfo() {
        UpdateSettingsEntryPointActionProvider.setPlatformUpdateInfo(null);
        UpdateSettingsEntryPointActionProvider.newPlatformUpdate(null, null, (String)null);
        SettingsEntryPointAction.updateState();
    }

    public static void newPlatformUpdate(@NotNull PlatformUpdates.Loaded platformUpdateInfo, @NotNull List<PluginDownloader> updatesForPlugins, @NotNull List<String> incompatiblePluginNames) {
        UpdateSettings settings;
        if (platformUpdateInfo == null) {
            UpdateSettingsEntryPointActionProvider.$$$reportNull$$$0(0);
        }
        if (updatesForPlugins == null) {
            UpdateSettingsEntryPointActionProvider.$$$reportNull$$$0(1);
        }
        if (incompatiblePluginNames == null) {
            UpdateSettingsEntryPointActionProvider.$$$reportNull$$$0(2);
        }
        if ((settings = UpdateSettings.getInstance()).isCheckNeeded()) {
            UpdateSettingsEntryPointActionProvider.setPlatformUpdateInfo(platformUpdateInfo);
        } else {
            UpdateSettingsEntryPointActionProvider.setPlatformUpdateInfo(null);
        }
        if (settings.isPluginsCheckNeeded()) {
            UpdateSettingsEntryPointActionProvider.newPlatformUpdate(updatesForPlugins, incompatiblePluginNames, null);
        } else {
            UpdateSettingsEntryPointActionProvider.newPlatformUpdate(null, null, (String)null);
        }
        SettingsEntryPointAction.updateState();
    }

    private static void setPlatformUpdateInfo(@Nullable PlatformUpdates.Loaded platformUpdateInfo) {
        myPlatformUpdateInfo = platformUpdateInfo;
        myNewPlatformUpdate = platformUpdateInfo != null;
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (platformUpdateInfo == null) {
            properties.unsetValue(NEXT_RUN_KEY_BUILD);
            properties.unsetValue(NEXT_RUN_KEY_VERSION);
            properties.unsetValue(NEXT_RUN_KEY_SELF_BUILD);
        } else {
            BuildInfo build = platformUpdateInfo.getNewBuild();
            properties.setValue(NEXT_RUN_KEY_BUILD, build.getNumber().toString());
            properties.setValue(NEXT_RUN_KEY_VERSION, build.getVersion());
            properties.setValue(NEXT_RUN_KEY_SELF_BUILD, ApplicationInfo.getInstance().getBuild().asString());
        }
    }

    private static void newPlatformUpdate(@Nullable List<PluginDownloader> updatesForPlugins, @Nullable List<String> incompatiblePluginNames, @Nullable String nextRunPlatformUpdateVersion) {
        myUpdatesForPlugins = updatesForPlugins;
        myIncompatiblePluginNames = incompatiblePluginNames;
        myNextRunPlatformUpdateVersion = nextRunPlatformUpdateVersion;
    }

    public static void newPluginUpdates(@NotNull Collection<PluginDownloader> updatesForPlugins, @NotNull Collection<PluginUiModel> customRepositoryPlugins) {
        if (updatesForPlugins == null) {
            UpdateSettingsEntryPointActionProvider.$$$reportNull$$$0(3);
        }
        if (customRepositoryPlugins == null) {
            UpdateSettingsEntryPointActionProvider.$$$reportNull$$$0(4);
        }
        if (UpdateSettings.getInstance().isPluginsCheckNeeded()) {
            myUpdatesForPlugins = updatesForPlugins;
            myCustomRepositoryPlugins = customRepositoryPlugins;
        } else {
            myUpdatesForPlugins = null;
            myCustomRepositoryPlugins = null;
        }
        SettingsEntryPointAction.updateState();
    }

    @Nullable
    public static Collection<PluginDownloader> getPendingUpdates() {
        return myUpdatesForPlugins;
    }

    private static void newUpdatesForPlugins(@Nullable Collection<PluginDownloader> updatesForPlugins) {
        myUpdatesForPlugins = ContainerUtil.isEmpty(updatesForPlugins) ? null : updatesForPlugins;
        SettingsEntryPointAction.updateState();
    }

    static void removePluginsUpdate(@NotNull List<? extends IdeaPluginDescriptor> descriptors) {
        if (descriptors == null) {
            UpdateSettingsEntryPointActionProvider.$$$reportNull$$$0(5);
        }
        if (myAlreadyShownPluginUpdates != null) {
            myAlreadyShownPluginUpdates.removeIf(name -> descriptors.stream().anyMatch(descriptor -> name.equals(descriptor.getName())));
        }
        if (myUpdatesForPlugins != null) {
            Set pluginIds = ContainerUtil.map2Set(descriptors, PluginDescriptor::getPluginId);
            List updatesForPlugins = ContainerUtil.filter(myUpdatesForPlugins, downloader -> !pluginIds.contains(downloader.getId()));
            if (myUpdatesForPlugins.size() != updatesForPlugins.size()) {
                UpdateSettingsEntryPointActionProvider.newUpdatesForPlugins(updatesForPlugins);
            }
        }
    }

    private static boolean isAlreadyShownPluginUpdates() {
        return myUpdatesForPlugins == null || ContainerUtil.isEmpty(myAlreadyShownPluginUpdates) || myUpdatesForPlugins.stream().anyMatch(plugin -> !myAlreadyShownPluginUpdates.contains(plugin.getPluginName()));
    }

    private static void updateAlreadyShownPluginUpdates() {
        if (myUpdatesForPlugins != null) {
            if (myAlreadyShownPluginUpdates == null) {
                myAlreadyShownPluginUpdates = new HashSet<String>();
            }
            myUpdatesForPlugins.forEach(plugin -> myAlreadyShownPluginUpdates.add(plugin.getPluginName()));
        }
    }

    private static void setEnableUpdateAction(boolean value) {
        myEnableUpdateAction = value;
    }

    @NotNull
    public Collection<SettingsEntryPointAction.UpdateAction> getUpdateActions(@NotNull DataContext context) {
        if (context == null) {
            UpdateSettingsEntryPointActionProvider.$$$reportNull$$$0(6);
        }
        ArrayList<SettingsEntryPointAction.UpdateAction> actions = new ArrayList<SettingsEntryPointAction.UpdateAction>();
        if (myNextRunPlatformUpdateVersion != null) {
            actions.add(new IdeUpdateAction(this, myNextRunPlatformUpdateVersion){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Project project = e.getProject();
                    Pair result = (Pair)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<Pair<PlatformUpdates, InternalPluginResults>, RuntimeException>(this, project, IdeBundle.message((String)"find.ide.update.title", (Object[])new Object[0]), true){

                        @NotNull
                        protected @NotNull Pair<@NotNull PlatformUpdates, @Nullable InternalPluginResults> compute(@NotNull ProgressIndicator indicator) {
                            PlatformUpdates platformUpdates;
                            if (indicator == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            InternalPluginResults pluginResults = (platformUpdates = UpdateChecker.getPlatformUpdates(UpdateSettings.getInstance(), indicator)) instanceof PlatformUpdates.Loaded ? 1.getInternalPluginUpdates((PlatformUpdates.Loaded)platformUpdates, indicator) : null;
                            Pair pair = Pair.create((Object)platformUpdates, (Object)pluginResults);
                            if (pair == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return pair;
                        }

                        @NotNull
                        private static InternalPluginResults getInternalPluginUpdates(@NotNull PlatformUpdates.Loaded loadedResult, @NotNull ProgressIndicator indicator) {
                            if (loadedResult == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            if (indicator == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            InternalPluginResults internalPluginResults = UpdateChecker.getInternalPluginUpdates(loadedResult.getNewBuild().getApiVersion(), indicator);
                            if (internalPluginResults == null) {
                                1.$$$reportNull$$$0(4);
                            }
                            return internalPluginResults;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[switch (n) {
                                default -> 3;
                                case 1, 4 -> 2;
                            }];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "indicator";
                                    break;
                                }
                                case 1: 
                                case 4: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/openapi/updateSettings/impl/UpdateSettingsEntryPointActionProvider$2$1";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "loadedResult";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/openapi/updateSettings/impl/UpdateSettingsEntryPointActionProvider$2$1";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "compute";
                                    break;
                                }
                                case 4: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getInternalPluginUpdates";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "compute";
                                    break;
                                }
                                case 1: 
                                case 4: {
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    objectArray = objectArray;
                                    objectArray[2] = "getInternalPluginUpdates";
                                    break;
                                }
                            }
                            String string = String.format(v0, objectArray);
                            throw switch (n) {
                                default -> new IllegalArgumentException(string);
                                case 1, 4 -> new IllegalStateException(string);
                            };
                        }
                    });
                    PlatformUpdates platformUpdateInfo = (PlatformUpdates)result.getFirst();
                    InternalPluginResults pluginResults = (InternalPluginResults)result.getSecond();
                    if (platformUpdateInfo instanceof PlatformUpdates.Loaded && pluginResults != null) {
                        UpdateSettingsEntryPointActionProvider.setPlatformUpdateInfo((PlatformUpdates.Loaded)platformUpdateInfo);
                        UpdateSettingsEntryPointActionProvider.newPlatformUpdate(pluginResults.getPluginUpdates().getAllEnabled().stream().toList(), ContainerUtil.map((Collection)pluginResults.getPluginUpdates().getIncompatible(), PluginDescriptor::getName), null);
                        super.actionPerformed(e);
                    } else if (platformUpdateInfo instanceof PlatformUpdates.ConnectionError) {
                        String errorMessage = ((PlatformUpdates.ConnectionError)platformUpdateInfo).getError().getMessage();
                        Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"updates.error.connection.failed", (Object[])new Object[]{errorMessage}), (String)IdeBundle.message((String)"find.ide.update.title", (Object[])new Object[0]));
                    } else {
                        Messages.showInfoMessage((Project)project, (String)IdeBundle.message((String)"updates.no.updates.notification", (Object[])new Object[0]), (String)IdeBundle.message((String)"find.ide.update.title", (Object[])new Object[0]));
                        UpdateSettingsEntryPointActionProvider.clearUpdatesInfo();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/updateSettings/impl/UpdateSettingsEntryPointActionProvider$2", "actionPerformed"));
                }
            });
        } else if (myPlatformUpdateInfo != null) {
            actions.add(new IdeUpdateAction(myPlatformUpdateInfo.getNewBuild().getVersion()));
        } else if (myUpdatesForPlugins != null && !myUpdatesForPlugins.isEmpty()) {
            int size = myUpdatesForPlugins.size();
            actions.add(new SettingsEntryPointAction.UpdateAction(this, size == 1 ? IdeBundle.message((String)"settings.entry.point.update.plugin.action", (Object[])new Object[]{myUpdatesForPlugins.iterator().next().getPluginName()}) : IdeBundle.message((String)"settings.entry.point.update.plugins.action", (Object[])new Object[]{size})){

                public boolean isPluginUpdate() {
                    return true;
                }

                public boolean isNewAction() {
                    return UpdateSettingsEntryPointActionProvider.isAlreadyShownPluginUpdates();
                }

                public void markAsRead() {
                    UpdateSettingsEntryPointActionProvider.updateAlreadyShownPluginUpdates();
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    e.getPresentation().setEnabled(myEnableUpdateAction);
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                    if (actionUpdateThread == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return actionUpdateThread;
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    PluginModelAsyncOperationsExecutor.INSTANCE.findPlugins(myUpdatesForPlugins, plugins2 -> {
                        PluginUpdateDialog dialog = new PluginUpdateDialog(e.getProject(), plugins2.values(), myCustomRepositoryPlugins, plugins2);
                        dialog.setFinishCallback(() -> UpdateSettingsEntryPointActionProvider.setEnableUpdateAction(true));
                        UpdateSettingsEntryPointActionProvider.setEnableUpdateAction(false);
                        if (!PluginUpdateDialog.showDialogAndUpdate(myUpdatesForPlugins, (PluginUpdateDialog)dialog)) {
                            UpdateSettingsEntryPointActionProvider.setEnableUpdateAction(true);
                        }
                        return Unit.INSTANCE;
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/updateSettings/impl/UpdateSettingsEntryPointActionProvider$3";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/updateSettings/impl/UpdateSettingsEntryPointActionProvider$3";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "update";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "actionPerformed";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            });
        }
        ArrayList<SettingsEntryPointAction.UpdateAction> arrayList = actions;
        if (arrayList == null) {
            UpdateSettingsEntryPointActionProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    static {
        myEnableUpdateAction = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformUpdateInfo";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatesForPlugins";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompatiblePluginNames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customRepositoryPlugins";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/UpdateSettingsEntryPointActionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/UpdateSettingsEntryPointActionProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newPlatformUpdate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newPluginUpdates";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removePluginsUpdate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateActions";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    private static class IdeUpdateAction
    extends SettingsEntryPointAction.UpdateAction {
        protected IdeUpdateAction(@NotNull String version) {
            if (version == null) {
                IdeUpdateAction.$$$reportNull$$$0(0);
            }
            super(IdeBundle.message((String)"settings.entry.point.update.ide.action", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), version}));
        }

        public boolean isIdeUpdate() {
            return true;
        }

        public boolean isNewAction() {
            return myNewPlatformUpdate;
        }

        public void markAsRead() {
            myNewPlatformUpdate = false;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PlatformUpdateDialog dialog;
            if (e == null) {
                IdeUpdateAction.$$$reportNull$$$0(1);
            }
            if ((dialog = new PlatformUpdateDialog(e.getProject(), Objects.requireNonNull(myPlatformUpdateInfo), true, myUpdatesForPlugins, myIncompatiblePluginNames)).showAndGet()) {
                UpdateSettingsEntryPointActionProvider.clearUpdatesInfo();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/updateSettings/impl/UpdateSettingsEntryPointActionProvider$IdeUpdateAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class LifecycleListener
    implements AppLifecycleListener {
        LifecycleListener() {
        }

        public void appStarted() {
            UpdateSettingsEntryPointActionProvider.preparePrevPlatformUpdate();
            UpdateSettingsEntryPointActionProvider.initPluginsListeners();
        }
    }
}

