/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.updateSettings.impl.UpdateChain;
import java.util.List;
import org.jetbrains.annotations.Nullable;

final class IdeUpdateUsageTriggerCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("ide.self.update", 4);
    private static final EventId1<String> DIALOG_SHOWN = GROUP.registerEvent("dialog.shown", (EventField)EventFields.String((String)"patches", List.of("not.available", "manual", "auto")));
    private static final EventId1<Boolean> UPDATE_WHATS_NEW = GROUP.registerEvent("update.whats.new", (EventField)EventFields.Boolean((String)"show_in_editor"));
    static final EventId NOTIFICATION_SHOWN = GROUP.registerEvent("notification.shown");
    static final EventId NOTIFICATION_CLICKED = GROUP.registerEvent("notification.clicked");
    static final EventId UPDATE_FAILED = GROUP.registerEvent("update.failed");
    static final EventId UPDATE_STARTED = GROUP.registerEvent("dialog.update.started");
    static final EventId MANUAL_PATCH_PREPARED = GROUP.registerEvent("dialog.manual.patch.prepared");

    IdeUpdateUsageTriggerCollector() {
    }

    static void triggerUpdateDialog(@Nullable UpdateChain patches, boolean isRestartCapable) {
        String patchesValue = patches == null ? "not.available" : (!isRestartCapable ? "manual" : "auto");
        DIALOG_SHOWN.log((Object)patchesValue);
    }

    static void majorUpdateHappened(boolean showInEditor) {
        UPDATE_WHATS_NEW.log((Object)showInEditor);
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }
}

