/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class UpdateInfoStatsCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("ide.update.dialog", 2);
    private static final EventId1<String> CLICK = GROUP.registerEvent("link.clicked", (EventField)EventFields.StringValidatedByCustomRule((String)"url", UrlValidationRule.class));

    UpdateInfoStatsCollector() {
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    static void click(@NotNull String url) {
        if (url == null) {
            UpdateInfoStatsCollector.$$$reportNull$$$0(0);
        }
        CLICK.log((Object)url);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/updateSettings/impl/UpdateInfoStatsCollector", "click"));
    }

    public static final class UrlValidationRule
    extends CustomValidationRule {
        private static final String ID = "update_dialog_rule_id";
        private static final List<String> JB_DOMAINS = Arrays.asList("jetbrains.com", "intellij.net", "intellij.com", "kotlinlang.org", "jb.gg");

        @NotNull
        public String getRuleId() {
            return ID;
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            block6: {
                ValidationResultType validationResultType;
                if (data == null) {
                    UrlValidationRule.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    UrlValidationRule.$$$reportNull$$$0(1);
                }
                try {
                    String host = URI.create(data).getHost();
                    if (!JB_DOMAINS.stream().anyMatch(domain -> host.endsWith((String)domain))) break block6;
                    validationResultType = ValidationResultType.ACCEPTED;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (validationResultType == null) {
                    UrlValidationRule.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                UrlValidationRule.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/updateSettings/impl/UpdateInfoStatsCollector$UrlValidationRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/updateSettings/impl/UpdateInfoStatsCollector$UrlValidationRule";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

