/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u001a\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0013\u001a\n\u0010\u0017\u001a\u00020\u000b*\u00020\u0013\u001a*\u0010\u0018\u001a\u00020\u000b*\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007\u001a\u0012\u0010\u001d\u001a\u00020\u000f*\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a\u001a\n\u0010\u001e\u001a\u00020\u000b*\u00020\u0013\u001a\u001a\u0010\u0018\u001a\u00020\u000b*\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u000f\u001a\"\u0010\u0002\u001a\u00020\u0013*\u00020\r2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0001\u001a8\u0010\u0018\u001a\u00020\u000b*\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007\u001a8\u0010!\u001a\u00020\u000b*\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007\u001a0\u0010\"\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010#\u001a\u00020\u000fH\u0007\"\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"SERVER_HEADER_VALUE", "", "response", "Lio/netty/handler/codec/http/FullHttpResponse;", "contentType", "content", "Lio/netty/buffer/ByteBuf;", "", "charset", "Ljava/nio/charset/Charset;", "responseStatus", "", "status", "Lio/netty/handler/codec/http/HttpResponseStatus;", "keepAlive", "", "channel", "Lio/netty/channel/Channel;", "addNoCache", "Lio/netty/handler/codec/http/HttpResponse;", "serverHeaderValue", "getServerHeaderValue", "()Ljava/lang/String;", "addServer", "send", "request", "Lio/netty/handler/codec/http/HttpRequest;", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "addKeepAliveIfNeeded", "addCommonHeaders", "close", "description", "sendPlainText", "createStatusResponse", "usePlainText", "intellij.platform.ide.util.netty"})
@JvmName(name="Responses")
public final class Responses {
    @Nullable
    private static String SERVER_HEADER_VALUE;

    @NotNull
    public static final FullHttpResponse response(@Nullable String contentType, @Nullable ByteBuf content) {
        DefaultFullHttpResponse response;
        DefaultFullHttpResponse defaultFullHttpResponse = response = content == null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
        if (contentType != null) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        }
        return (FullHttpResponse)response;
    }

    @NotNull
    public static final FullHttpResponse response(@NotNull CharSequence content, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)content, (Charset)charset));
    }

    public static /* synthetic */ FullHttpResponse response$default(CharSequence charSequence, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            Charset charset2 = CharsetUtil.US_ASCII;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"US_ASCII");
            charset = charset2;
        }
        return Responses.response(charSequence, charset);
    }

    public static final void responseStatus(@NotNull HttpResponseStatus status, boolean keepAlive, @NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)0L);
        Responses.addCommonHeaders((HttpResponse)response);
        Responses.addNoCache((HttpResponse)response);
        if (keepAlive) {
            HttpUtil.setKeepAlive((HttpMessage)((HttpMessage)response), (boolean)true);
        }
        response.headers().set("X-Frame-Options", (Object)"Deny");
        Responses.send((HttpResponse)response, channel, !keepAlive);
    }

    @NotNull
    public static final HttpResponse addNoCache(@NotNull HttpResponse $this$addNoCache) {
        Intrinsics.checkNotNullParameter((Object)$this$addNoCache, (String)"<this>");
        $this$addNoCache.headers().add((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"no-cache, no-store, must-revalidate, max-age=0");
        $this$addNoCache.headers().add((CharSequence)HttpHeaderNames.PRAGMA, (Object)"no-cache");
        return $this$addNoCache;
    }

    @Nullable
    public static final String getServerHeaderValue() {
        Application app;
        if (SERVER_HEADER_VALUE == null && (app = ApplicationManager.getApplication()) != null && !app.isDisposed()) {
            SERVER_HEADER_VALUE = ApplicationInfo.getInstance().getFullApplicationName();
        }
        return SERVER_HEADER_VALUE;
    }

    public static final void addServer(@NotNull HttpResponse $this$addServer) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$addServer, (String)"<this>");
            String string = Responses.getServerHeaderValue();
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            $this$addServer.headers().add((CharSequence)HttpHeaderNames.SERVER, (Object)it);
        }
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponse $this$send, @NotNull Channel channel, @Nullable HttpRequest request, @Nullable HttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)$this$send, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        if (!Intrinsics.areEqual((Object)$this$send.status(), (Object)HttpResponseStatus.NOT_MODIFIED) && !HttpUtil.isContentLengthSet((HttpMessage)((HttpMessage)$this$send))) {
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)$this$send), (long)($this$send instanceof FullHttpResponse ? ((FullHttpResponse)$this$send).content().readableBytes() : 0));
        }
        Responses.addCommonHeaders($this$send);
        HttpHeaders httpHeaders = extraHeaders;
        if (httpHeaders != null) {
            HttpHeaders it = httpHeaders;
            boolean bl = false;
            $this$send.headers().add(it);
        }
        Responses.send($this$send, channel, request != null && !Responses.addKeepAliveIfNeeded($this$send, request));
    }

    public static /* synthetic */ void send$default(HttpResponse httpResponse, Channel channel, HttpRequest httpRequest, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 4) != 0) {
            httpHeaders = null;
        }
        Responses.send(httpResponse, channel, httpRequest, httpHeaders);
    }

    public static final boolean addKeepAliveIfNeeded(@NotNull HttpResponse $this$addKeepAliveIfNeeded, @NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)$this$addKeepAliveIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (HttpUtil.isKeepAlive((HttpMessage)((HttpMessage)request))) {
            HttpUtil.setKeepAlive((HttpMessage)((HttpMessage)$this$addKeepAliveIfNeeded), (boolean)true);
            return true;
        }
        return false;
    }

    public static final void addCommonHeaders(@NotNull HttpResponse $this$addCommonHeaders) {
        Intrinsics.checkNotNullParameter((Object)$this$addCommonHeaders, (String)"<this>");
        Responses.addServer($this$addCommonHeaders);
        if (!$this$addCommonHeaders.headers().contains((CharSequence)HttpHeaderNames.DATE)) {
            $this$addCommonHeaders.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)Calendar.getInstance().getTime());
        }
        if (!$this$addCommonHeaders.headers().contains((CharSequence)HttpHeaderNames.X_FRAME_OPTIONS)) {
            $this$addCommonHeaders.headers().set((CharSequence)HttpHeaderNames.X_FRAME_OPTIONS, (Object)"SameOrigin");
        }
        $this$addCommonHeaders.headers().set("X-Content-Type-Options", (Object)"nosniff");
        $this$addCommonHeaders.headers().set("x-xss-protection", (Object)"1; mode=block");
        if ($this$addCommonHeaders.status().compareTo(HttpResponseStatus.MULTIPLE_CHOICES) < 0) {
            $this$addCommonHeaders.headers().set((CharSequence)HttpHeaderNames.ACCEPT_RANGES, (Object)"bytes");
        }
    }

    public static final void send(@NotNull HttpResponse $this$send, @NotNull Channel channel, boolean close) {
        Intrinsics.checkNotNullParameter((Object)$this$send, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        if (!channel.isActive()) {
            return;
        }
        ChannelFuture future = channel.write((Object)$this$send);
        if (!($this$send instanceof FullHttpResponse)) {
            channel.write((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        }
        channel.flush();
        if (close) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    @NotNull
    public static final HttpResponse response(@NotNull HttpResponseStatus $this$response, @Nullable HttpRequest request, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)$this$response, (String)"<this>");
        return Responses.createStatusResponse$default($this$response, request, description, false, 8, null);
    }

    public static /* synthetic */ HttpResponse response$default(HttpResponseStatus httpResponseStatus, HttpRequest httpRequest, String string, int n, Object object) {
        if ((n & 1) != 0) {
            httpRequest = null;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return Responses.response(httpResponseStatus, httpRequest, string);
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponseStatus $this$send, @NotNull Channel channel, @Nullable HttpRequest request, @Nullable String description, @Nullable HttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)$this$send, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Responses.send(Responses.createStatusResponse$default($this$send, request, description, false, 8, null), channel, request, extraHeaders);
    }

    public static /* synthetic */ void send$default(HttpResponseStatus httpResponseStatus, Channel channel, HttpRequest httpRequest, String string, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 2) != 0) {
            httpRequest = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            httpHeaders = null;
        }
        Responses.send(httpResponseStatus, channel, httpRequest, string, httpHeaders);
    }

    @JvmOverloads
    public static final void sendPlainText(@NotNull HttpResponseStatus $this$sendPlainText, @NotNull Channel channel, @Nullable HttpRequest request, @Nullable String description, @Nullable HttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)$this$sendPlainText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Responses.send(Responses.createStatusResponse($this$sendPlainText, request, description, true), channel, request, extraHeaders);
    }

    public static /* synthetic */ void sendPlainText$default(HttpResponseStatus httpResponseStatus, Channel channel, HttpRequest httpRequest, String string, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 2) != 0) {
            httpRequest = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            httpHeaders = null;
        }
        Responses.sendPlainText(httpResponseStatus, channel, httpRequest, string, httpHeaders);
    }

    @ApiStatus.Internal
    @NotNull
    public static final HttpResponse createStatusResponse(@NotNull HttpResponseStatus responseStatus, @Nullable HttpRequest request, @Nullable String description, boolean usePlainText) {
        Intrinsics.checkNotNullParameter((Object)responseStatus, (String)"responseStatus");
        if (request != null && Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD)) {
            return (HttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, Unpooled.EMPTY_BUFFER);
        }
        String string = responseStatus.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String message = string;
        StringBuilder builder = new StringBuilder();
        if (usePlainText) {
            builder.append(message);
            if (description != null) {
                builder.append("\n").append(description);
            }
        } else {
            builder.append("<!doctype html><title>").append(message).append("</title>").append("<h1 style=\"text-align: center\">").append(message).append("</h1>");
            if (description != null) {
                builder.append("<p>").append(description).append("</p>");
            }
        }
        ByteBuf content = ByteBufUtil.encodeString((ByteBufAllocator)ByteBufAllocator.DEFAULT, (CharBuffer)CharBuffer.wrap(builder), (Charset)Charsets.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, content);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)(usePlainText ? HttpHeaderValues.TEXT_PLAIN : HttpHeaderValues.TEXT_HTML));
        return (HttpResponse)response;
    }

    public static /* synthetic */ HttpResponse createStatusResponse$default(HttpResponseStatus httpResponseStatus, HttpRequest httpRequest, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return Responses.createStatusResponse(httpResponseStatus, httpRequest, string, bl);
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponse $this$send, @NotNull Channel channel, @Nullable HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)$this$send, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Responses.send$default($this$send, channel, request, null, 4, null);
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponseStatus $this$send, @NotNull Channel channel, @Nullable HttpRequest request, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)$this$send, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Responses.send$default($this$send, channel, request, description, null, 8, null);
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponseStatus $this$send, @NotNull Channel channel, @Nullable HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)$this$send, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Responses.send$default($this$send, channel, request, null, null, 12, null);
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponseStatus $this$send, @NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)$this$send, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Responses.send$default($this$send, channel, null, null, null, 14, null);
    }

    @JvmOverloads
    public static final void sendPlainText(@NotNull HttpResponseStatus $this$sendPlainText, @NotNull Channel channel, @Nullable HttpRequest request, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)$this$sendPlainText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Responses.sendPlainText$default($this$sendPlainText, channel, request, description, null, 8, null);
    }

    @JvmOverloads
    public static final void sendPlainText(@NotNull HttpResponseStatus $this$sendPlainText, @NotNull Channel channel, @Nullable HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)$this$sendPlainText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Responses.sendPlainText$default($this$sendPlainText, channel, request, null, null, 12, null);
    }

    @JvmOverloads
    public static final void sendPlainText(@NotNull HttpResponseStatus $this$sendPlainText, @NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)$this$sendPlainText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Responses.sendPlainText$default($this$sendPlainText, channel, null, null, null, 14, null);
    }
}

