/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.TreeNodePresentationImpl;
import com.intellij.ui.treeStructure.TreeNodeTextFragment;
import com.intellij.ui.treeStructure.TreeNodeViewModel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Insets;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeRenderer
extends ColoredTreeCellRenderer {
    @Override
    protected int getMinHeight() {
        Insets padding = this.getIpad();
        Border border = this.getMyBorder();
        int additionalHeight = padding.top + padding.bottom;
        if (border != null) {
            Insets borderInsets = border.getBorderInsets(this);
            additionalHeight += borderInsets.top + borderInsets.bottom;
        }
        return JBUI.CurrentTheme.Tree.rowHeight() - additionalHeight;
    }

    protected Icon fixIconIfNeeded(Icon icon, boolean selected2, boolean hasFocus) {
        return NodeRenderer.adjustIconInTree(icon, selected2, hasFocus);
    }

    @ApiStatus.Internal
    public static Icon adjustIconInTree(Icon icon, boolean selected2, boolean hasFocus) {
        boolean dark = icon != null && !StartupUiUtil.INSTANCE.isDarkTheme() && Registry.is((String)"ide.project.view.change.icon.on.selection", (boolean)true) && selected2 && hasFocus;
        return dark ? IconLoader.getDarkIcon((Icon)icon, (boolean)true) : icon;
    }

    @Override
    public void customizeCellRenderer(@NotNull JTree tree, @NlsSafe Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            NodeRenderer.$$$reportNull$$$0(0);
        }
        if (value2 instanceof TreeNodeViewModel) {
            TreeNodeViewModel vm = (TreeNodeViewModel)value2;
            this.customizeViewModelRenderer((TreeNodePresentationImpl)vm.stateSnapshot().getPresentation(), selected2, hasFocus);
        } else {
            this.customizeLegacyRenderer(tree, value2, selected2, expanded, leaf, row, hasFocus);
        }
    }

    private void customizeViewModelRenderer(TreeNodePresentationImpl presentation, boolean selected2, boolean hasFocus) {
        this.setIcon(this.fixIconIfNeeded(presentation.getIcon(), selected2, hasFocus));
        boolean isMain = true;
        for (TreeNodeTextFragment fragment : presentation.getFullText()) {
            SimpleTextAttributes simpleTextAttributes = fragment.getAttributes();
            isMain = isMain && !Comparing.equal((Object)simpleTextAttributes.getFgColor(), (Object)SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor());
            String text = fragment.getText();
            this.append(text, simpleTextAttributes, isMain);
        }
        String toolTip = presentation.getToolTip();
        this.setToolTipText(toolTip);
    }

    private void customizeLegacyRenderer(JTree tree, Object v, boolean selected2, boolean expanded, boolean leaf, int row, boolean focused) {
        ItemPresentation itemPresentation;
        Object node = TreeUtil.getUserObject(v);
        if (node instanceof NodeDescriptor) {
            NodeDescriptor descriptor2 = (NodeDescriptor)node;
            this.setIcon(this.fixIconIfNeeded(descriptor2.getIcon(), selected2, focused));
        }
        if ((itemPresentation = this.getPresentation(node)) instanceof PresentationData) {
            PresentationData presentation = (PresentationData)itemPresentation;
            Color color = node instanceof NodeDescriptor ? ((NodeDescriptor)node).getColor() : null;
            this.setIcon(this.fixIconIfNeeded(presentation.getIcon(false), selected2, focused));
            List coloredText = presentation.getColoredText();
            Color forcedForeground = presentation.getForcedTextForeground();
            if (coloredText.isEmpty()) {
                String text = presentation.getPresentableText();
                if (StringUtil.isEmpty((String)text)) {
                    String valueSting;
                    text = valueSting = v.toString();
                }
                text = tree.convertValueToText(text, selected2, expanded, leaf, row, focused);
                SimpleTextAttributes simpleTextAttributes = this.getSimpleTextAttributes(presentation, forcedForeground != null ? forcedForeground : color, node);
                this.append(text, simpleTextAttributes);
                String location = presentation.getLocationString();
                if (!StringUtil.isEmpty((String)location)) {
                    SimpleTextAttributes attributes = SimpleTextAttributes.merge((SimpleTextAttributes)simpleTextAttributes, (SimpleTextAttributes)SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    this.append(presentation.getLocationPrefix() + location + presentation.getLocationSuffix(), attributes, false);
                }
            } else {
                boolean first = true;
                boolean isMain = true;
                for (PresentableNodeDescriptor.ColoredFragment each : coloredText) {
                    SimpleTextAttributes simpleTextAttributes = each.getAttributes();
                    if (each.getAttributes().getFgColor() == null && forcedForeground != null) {
                        simpleTextAttributes = NodeRenderer.addColorToSimpleTextAttributes(each.getAttributes(), forcedForeground);
                    }
                    if (first) {
                        TextAttributes forcedAttributes;
                        TextAttributesKey textAttributesKey = presentation.getTextAttributesKey();
                        if (textAttributesKey != null && (forcedAttributes = NodeRenderer.getScheme().getAttributes(textAttributesKey)) != null) {
                            simpleTextAttributes = SimpleTextAttributes.merge((SimpleTextAttributes)simpleTextAttributes, (SimpleTextAttributes)SimpleTextAttributes.fromTextAttributes((TextAttributes)forcedAttributes));
                        }
                        first = false;
                    }
                    isMain = isMain && !Comparing.equal((Object)simpleTextAttributes.getFgColor(), (Object)SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor());
                    this.append(each.getText(), simpleTextAttributes, isMain);
                }
                String location = presentation.getLocationString();
                if (!StringUtil.isEmpty((String)location)) {
                    this.append(presentation.getLocationPrefix() + (String)location + presentation.getLocationSuffix(), SimpleTextAttributes.GRAYED_ATTRIBUTES, false);
                }
            }
            this.setToolTipText(presentation.getTooltip());
        } else if (v != null) {
            String text = v.toString();
            if (node instanceof NodeDescriptor) {
                text = node.toString();
            }
            if ((text = tree.convertValueToText(text, selected2, expanded, leaf, row, focused)) == null) {
                text = "";
            }
            this.append(text);
            this.setToolTipText(null);
        }
    }

    @Contract(value="null->null")
    @Nullable
    protected ItemPresentation getPresentation(Object node) {
        PresentationData presentationData;
        if (node instanceof PresentableNodeDescriptor) {
            PresentableNodeDescriptor pnd = (PresentableNodeDescriptor)node;
            presentationData = pnd.getPresentation();
        } else if (node instanceof NavigationItem) {
            NavigationItem ni = (NavigationItem)node;
            presentationData = ni.getPresentation();
        } else {
            presentationData = null;
        }
        return presentationData;
    }

    private static EditorColorsScheme getScheme() {
        return EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
    }

    @NotNull
    protected SimpleTextAttributes getSimpleTextAttributes(@NotNull PresentationData presentation, Color color, @NotNull Object node) {
        if (presentation == null) {
            NodeRenderer.$$$reportNull$$$0(1);
        }
        if (node == null) {
            NodeRenderer.$$$reportNull$$$0(2);
        }
        SimpleTextAttributes simpleTextAttributes = NodeRenderer.getSimpleTextAttributes((ItemPresentation)presentation, NodeRenderer.getScheme());
        SimpleTextAttributes simpleTextAttributes2 = NodeRenderer.addColorToSimpleTextAttributes(simpleTextAttributes, color);
        if (simpleTextAttributes2 == null) {
            NodeRenderer.$$$reportNull$$$0(3);
        }
        return simpleTextAttributes2;
    }

    private static SimpleTextAttributes addColorToSimpleTextAttributes(SimpleTextAttributes simpleTextAttributes, Color color) {
        if (color != null) {
            TextAttributes textAttributes = simpleTextAttributes.toTextAttributes();
            if (simpleTextAttributes.useFaded()) {
                color = ColorUtil.faded((Color)color);
            }
            textAttributes.setForegroundColor(color);
            simpleTextAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
        }
        return simpleTextAttributes;
    }

    public static SimpleTextAttributes getSimpleTextAttributes(@Nullable ItemPresentation presentation) {
        return NodeRenderer.getSimpleTextAttributes(presentation, NodeRenderer.getScheme());
    }

    private static SimpleTextAttributes getSimpleTextAttributes(@Nullable ItemPresentation presentation, EditorColorsScheme colorsScheme) {
        TextAttributes textAttributes;
        ColoredItemPresentation cip;
        TextAttributesKey textAttributesKey;
        if (presentation instanceof ColoredItemPresentation && (textAttributesKey = (cip = (ColoredItemPresentation)presentation).getTextAttributesKey()) != null && (textAttributes = colorsScheme.getAttributes(textAttributesKey)) != null) {
            return SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
        }
        return SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/NodeRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/NodeRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleTextAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRenderer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleTextAttributes";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

