/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.KeyboardGestureAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import java.util.Objects;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class KeyboardModifierGestureShortcut
extends Shortcut {
    private final KeyStroke myStroke;
    private final KeyboardGestureAction.ModifierType myType;

    @NotNull
    public static Shortcut newInstance(KeyboardGestureAction.ModifierType type, KeyStroke stroke) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case KeyboardGestureAction.ModifierType.dblClick -> new DblClick(stroke);
            case KeyboardGestureAction.ModifierType.hold -> new Hold(stroke);
        };
    }

    protected KeyboardModifierGestureShortcut(KeyStroke stroke, KeyboardGestureAction.ModifierType type) {
        this.myStroke = stroke;
        this.myType = type;
    }

    public KeyStroke getStroke() {
        return this.myStroke;
    }

    public KeyboardGestureAction.ModifierType getType() {
        return this.myType;
    }

    public boolean isKeyboard() {
        return true;
    }

    public boolean startsWith(@NotNull Shortcut shortcut) {
        if (shortcut == null) {
            KeyboardModifierGestureShortcut.$$$reportNull$$$0(0);
        }
        if (!(shortcut instanceof KeyboardModifierGestureShortcut)) {
            return false;
        }
        KeyboardModifierGestureShortcut other = (KeyboardModifierGestureShortcut)shortcut;
        if (this.myType.equals((Object)other.myType)) {
            if (this.myStroke.getModifiers() != other.myStroke.getModifiers()) {
                return false;
            }
            return other.myStroke.getKeyCode() != -1 || other.myStroke.getKeyCode() == this.myStroke.getKeyCode();
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KeyboardModifierGestureShortcut that = (KeyboardModifierGestureShortcut)((Object)o);
        if (!Objects.equals(this.myStroke, that.myStroke)) {
            return false;
        }
        return this.myType == that.myType;
    }

    public int hashCode() {
        int result2 = this.myStroke != null ? this.myStroke.hashCode() : 0;
        result2 = 31 * result2 + (this.myType != null ? this.myType.hashCode() : 0);
        return result2;
    }

    public String toString() {
        Object s = this.getType() == KeyboardGestureAction.ModifierType.dblClick ? "Press, release and hold " : "Hold ";
        s = (String)s + KeymapUtil.getKeystrokeText(this.getStroke());
        return s;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcut", "com/intellij/openapi/actionSystem/KeyboardModifierGestureShortcut", "startsWith"));
    }

    public static class DblClick
    extends KeyboardModifierGestureShortcut {
        public DblClick(KeyStroke stroke) {
            super(stroke, KeyboardGestureAction.ModifierType.dblClick);
        }
    }

    public static final class Hold
    extends KeyboardModifierGestureShortcut {
        public Hold(KeyStroke stroke) {
            super(stroke, KeyboardGestureAction.ModifierType.hold);
        }
    }
}

