/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorActionHandler {
    static final String HANDLER_LOG_CATEGORY = "#com.intellij.openapi.editor.actionSystem.EditorActionHandler";
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.actionSystem.EditorActionHandler");
    private final boolean myRunForEachCaret;
    private boolean myWorksInInjected;
    private boolean inExecution;
    private boolean inCheck;

    protected EditorActionHandler() {
        this(false);
    }

    protected EditorActionHandler(boolean runForEachCaret) {
        this.myRunForEachCaret = runForEachCaret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean isEnabled(Editor editor, DataContext dataContext) {
        if (this.inCheck) {
            return true;
        }
        this.inCheck = true;
        try {
            Editor hostEditor;
            if (editor == null) {
                boolean bl = false;
                return bl;
            }
            Editor editor2 = hostEditor = dataContext == null ? null : (Editor)CommonDataKeys.HOST_EDITOR.getData(dataContext);
            if (hostEditor == null) {
                hostEditor = editor;
            }
            boolean[] result2 = new boolean[1];
            CaretTask check = (___, __) -> {
                result2[0] = true;
            };
            if (this.myRunForEachCaret) {
                hostEditor.getCaretModel().runForEachCaret(caret -> this.doIfEnabled(caret, dataContext, check), this.reverseCaretOrder());
            } else {
                this.doIfEnabled(hostEditor.getCaretModel().getCurrentCaret(), dataContext, check);
            }
            boolean bl = result2[0];
            return bl;
        }
        finally {
            this.inCheck = false;
        }
    }

    private void doIfEnabled(@NotNull Caret hostCaret, @Nullable DataContext context, @NotNull CaretTask task) {
        DataContext injectedCaretContext;
        Caret injectedCaret;
        if (hostCaret == null) {
            EditorActionHandler.$$$reportNull$$$0(0);
        }
        if (task == null) {
            EditorActionHandler.$$$reportNull$$$0(1);
        }
        DataContext caretContext = context == null ? null : EditorActionHandler.caretDataContext(context, hostCaret);
        Editor editor = hostCaret.getEditor();
        if (this.myWorksInInjected && caretContext != null && (injectedCaret = (Caret)CommonDataKeys.CARET.getData(injectedCaretContext = AnActionEvent.getInjectedDataContext((DataContext)caretContext))) != null && injectedCaret != hostCaret && this.isEnabledForCaret(injectedCaret.getEditor(), injectedCaret, injectedCaretContext)) {
            task.perform(injectedCaret, injectedCaretContext);
            return;
        }
        if (this.isEnabledForCaret(editor, hostCaret, caretContext)) {
            task.perform(hostCaret, caretContext);
        }
    }

    static boolean ensureInjectionUpToDate(@NotNull Caret hostCaret) {
        Editor editor;
        Project project;
        if (hostCaret == null) {
            EditorActionHandler.$$$reportNull$$$0(2);
        }
        if ((project = (editor = hostCaret.getEditor()).getProject()) != null && InjectedLanguageManager.getInstance((Project)project).mightHaveInjectedFragmentAtOffset(editor.getDocument(), hostCaret.getOffset())) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            EditorActionHandler.$$$reportNull$$$0(3);
        }
        if (caret == null) {
            EditorActionHandler.$$$reportNull$$$0(4);
        }
        if (this.inCheck) {
            return true;
        }
        this.inCheck = true;
        try {
            boolean bl = this.isEnabled(editor, dataContext);
            return bl;
        }
        finally {
            this.inCheck = false;
        }
    }

    public final boolean isEnabled(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (editor == null) {
            EditorActionHandler.$$$reportNull$$$0(5);
        }
        return caret == null ? this.isEnabled(editor, dataContext) : this.isEnabledForCaret(editor, caret, dataContext);
    }

    @Deprecated
    public void execute(@NotNull Editor editor, @Nullable DataContext dataContext) {
        if (editor == null) {
            EditorActionHandler.$$$reportNull$$$0(6);
        }
        if (this.inExecution) {
            return;
        }
        try {
            this.inExecution = true;
            this.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
        }
        finally {
            this.inExecution = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (editor == null) {
            EditorActionHandler.$$$reportNull$$$0(7);
        }
        if (this.inExecution) {
            return;
        }
        try {
            this.inExecution = true;
            this.execute(editor, dataContext);
        }
        finally {
            this.inExecution = false;
        }
    }

    public boolean executeInCommand(@NotNull Editor editor, DataContext dataContext) {
        if (editor == null) {
            EditorActionHandler.$$$reportNull$$$0(8);
        }
        return true;
    }

    public boolean runForAllCarets() {
        return this.myRunForEachCaret;
    }

    public boolean reverseCaretOrder() {
        return false;
    }

    public final void execute(@NotNull Editor editor, @Nullable Caret contextCaret, @Nullable DataContext dataContext) {
        Editor hostEditor;
        if (editor == null) {
            EditorActionHandler.$$$reportNull$$$0(9);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoked handler " + String.valueOf(this) + " in " + String.valueOf(editor) + " for the caret " + String.valueOf(contextCaret), LOG.isTraceEnabled() ? new Throwable() : null);
        }
        Editor editor2 = hostEditor = dataContext == null ? null : (Editor)CommonDataKeys.HOST_EDITOR.getData(dataContext);
        if (hostEditor == null) {
            hostEditor = editor;
        }
        if (contextCaret == null && this.runForAllCarets()) {
            hostEditor.getCaretModel().runForEachCaret(caret -> {
                DataContext refreshed = this.commitAndRefreshDataContextIfNeeded(dataContext, caret);
                this.doIfEnabled(caret, refreshed, (c, dc) -> this.doExecute(c.getEditor(), c, dc));
            }, this.reverseCaretOrder());
        } else if (contextCaret == null) {
            Caret caret2 = hostEditor.getCaretModel().getCurrentCaret();
            DataContext refreshed = this.commitAndRefreshDataContextIfNeeded(dataContext, caret2);
            this.doIfEnabled(caret2, refreshed, (c, dc) -> this.doExecute(c.getEditor(), null, dc));
        } else {
            this.doExecute(editor, contextCaret, dataContext);
        }
    }

    @Nullable
    private DataContext commitAndRefreshDataContextIfNeeded(@Nullable DataContext dataContext, Caret caret) {
        return this.myWorksInInjected && EditorActionHandler.ensureInjectionUpToDate(caret) && dataContext != null ? EditorActionHandler.freshCaretDataContext(dataContext, caret) : dataContext;
    }

    void setWorksInInjected(boolean worksInInjected) {
        this.myWorksInInjected = worksInInjected;
    }

    public DocCommandGroupId getCommandGroupId(@NotNull Editor editor) {
        if (editor == null) {
            EditorActionHandler.$$$reportNull$$$0(10);
        }
        return DocCommandGroupId.noneGroupId((Document)editor.getDocument());
    }

    @Nullable
    <T> T getHandlerOfType(@NotNull Class<T> type) {
        if (type == null) {
            EditorActionHandler.$$$reportNull$$$0(11);
        }
        return type.isInstance(this) ? (T)type.cast(this) : null;
    }

    @NotNull
    public static DataContext caretDataContext(@NotNull DataContext context, @NotNull Caret caret) {
        if (context == null) {
            EditorActionHandler.$$$reportNull$$$0(12);
        }
        if (caret == null) {
            EditorActionHandler.$$$reportNull$$$0(13);
        }
        if (CommonDataKeys.CARET.getData(context) == caret) {
            DataContext dataContext = context;
            if (dataContext == null) {
                EditorActionHandler.$$$reportNull$$$0(14);
            }
            return dataContext;
        }
        return EditorActionHandler.freshCaretDataContext(context, caret);
    }

    @ApiStatus.Internal
    @NotNull
    public static DataContext freshCaretDataContext(@NotNull DataContext context, @NotNull Caret caret) {
        if (context == null) {
            EditorActionHandler.$$$reportNull$$$0(15);
        }
        if (caret == null) {
            EditorActionHandler.$$$reportNull$$$0(16);
        }
        DataContext dataContext = CustomizedDataContext.withSnapshot((DataContext)context, sink -> sink.set(CommonDataKeys.CARET, (Object)caret));
        if (dataContext == null) {
            EditorActionHandler.$$$reportNull$$$0(17);
        }
        return dataContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostCaret";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actionSystem/EditorActionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actionSystem/EditorActionHandler";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "caretDataContext";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "freshCaretDataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doIfEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "ensureInjectionUpToDate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledForCaret";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeInCommand";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCommandGroupId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getHandlerOfType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "caretDataContext";
                break;
            }
            case 14: 
            case 17: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "freshCaretDataContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 17 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    private static interface CaretTask {
        public void perform(@NotNull Caret var1, @Nullable DataContext var2);
    }

    public static abstract class ForEachCaret
    extends EditorActionHandler {
        protected ForEachCaret() {
            super(true);
        }

        @Override
        protected abstract void doExecute(@NotNull Editor var1, @NotNull Caret var2, DataContext var3);
    }
}

