/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapTextContext;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KeymapUtil {
    private static final KeymapTextContext ourDefaultKeymapTextContext = new KeymapTextContext();
    private static final Set<Integer> ourTooltipKeys = new HashSet<Integer>();
    private static final Set<Integer> ourOtherTooltipKeys = new HashSet<Integer>();
    private static RegistryValue ourTooltipKeysProperty;

    private KeymapUtil() {
    }

    @NotNull
    @NlsSafe
    public static String getShortcutText(@NotNull ShortcutSet set) {
        String keyboardShortcut;
        if (set == null) {
            KeymapUtil.$$$reportNull$$$0(0);
        }
        if (!(keyboardShortcut = KeymapUtil.getFirstKeyboardShortcutText(set)).isEmpty()) {
            String string = keyboardShortcut;
            if (string == null) {
                KeymapUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        Shortcut firstShortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])set.getShortcuts());
        if (firstShortcut != null) {
            return KeymapUtil.getShortcutText(firstShortcut);
        }
        return "";
    }

    @NlsSafe
    @NotNull
    public static String getShortcutText(@NotNull @NonNls String actionId) {
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(2);
        }
        String string = ourDefaultKeymapTextContext.getShortcutText(actionId);
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NlsSafe
    @Nullable
    public static String getShortcutTextOrNull(@NotNull @NonNls String actionId) {
        KeyboardShortcut shortcut;
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(4);
        }
        if ((shortcut = ActionManager.getInstance().getKeyboardShortcut(actionId)) == null) {
            return null;
        }
        return KeymapUtil.getShortcutText((Shortcut)shortcut);
    }

    @NotNull
    @NlsSafe
    public static String getShortcutText(@NotNull Shortcut shortcut) {
        if (shortcut == null) {
            KeymapUtil.$$$reportNull$$$0(5);
        }
        String string = ourDefaultKeymapTextContext.getShortcutText(shortcut);
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String getMouseShortcutText(@NotNull MouseShortcut shortcut) {
        if (shortcut == null) {
            KeymapUtil.$$$reportNull$$$0(7);
        }
        String string = ourDefaultKeymapTextContext.getMouseShortcutText(shortcut);
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String getKeystrokeText(KeyStroke accelerator) {
        String string = ourDefaultKeymapTextContext.getKeystrokeText(accelerator);
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String getKeyText(int code) {
        String string = ourDefaultKeymapTextContext.getKeyText(code);
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static boolean isSimplifiedMacShortcuts() {
        return ourDefaultKeymapTextContext.isSimplifiedMacShortcuts();
    }

    @NotNull
    public static ShortcutSet getActiveKeymapShortcuts(@Nullable @NonNls String actionId) {
        ActionManager actionManager;
        KeymapManager keymapManager;
        if (actionId != null && (keymapManager = KeymapManager.getInstance()) != null && (actionManager = (ActionManager)ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class)) != null) {
            return KeymapUtil.getActiveKeymapShortcuts(actionId, keymapManager);
        }
        return new CustomShortcutSet(Shortcut.EMPTY_ARRAY);
    }

    @ApiStatus.Internal
    @NotNull
    public static ShortcutSet getActiveKeymapShortcuts(@NotNull @NonNls String actionId, @NotNull KeymapManager keymapManager) {
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(11);
        }
        if (keymapManager == null) {
            KeymapUtil.$$$reportNull$$$0(12);
        }
        return new CustomShortcutSet(keymapManager.getActiveKeymap().getShortcuts(actionId));
    }

    @Nullable
    public static Shortcut getPrimaryShortcut(@Nullable @NonNls String actionId) {
        KeymapManager keymapManager = KeymapManager.getInstance();
        if (keymapManager == null || actionId == null) {
            return null;
        }
        return (Shortcut)ArrayUtil.getFirstElement((Object[])keymapManager.getActiveKeymap().getShortcuts(actionId));
    }

    @NotNull
    @NlsSafe
    public static String getFirstKeyboardShortcutText(@NotNull @NonNls String actionId) {
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(13);
        }
        for (Shortcut shortcut : KeymapUtil.getActiveKeymapShortcuts(actionId).getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            return KeymapUtil.getShortcutText(shortcut);
        }
        return "";
    }

    @NotNull
    @NlsSafe
    public static String getFirstMouseShortcutText(@NotNull @NonNls String actionId) {
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(14);
        }
        for (Shortcut shortcut : KeymapUtil.getActiveKeymapShortcuts(actionId).getShortcuts()) {
            if (!(shortcut instanceof MouseShortcut)) continue;
            return KeymapUtil.getShortcutText(shortcut);
        }
        return "";
    }

    public static boolean isEventForAction(@NotNull KeyEvent keyEvent, @NotNull @NonNls String actionId) {
        if (keyEvent == null) {
            KeymapUtil.$$$reportNull$$$0(15);
        }
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(16);
        }
        for (Shortcut shortcut : KeymapUtil.getActiveKeymapShortcuts(actionId).getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut) || AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent) != ((KeyboardShortcut)shortcut).getFirstKeyStroke()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @NlsSafe
    public static String getFirstKeyboardShortcutText(@NotNull AnAction action) {
        if (action == null) {
            KeymapUtil.$$$reportNull$$$0(17);
        }
        return KeymapUtil.getFirstKeyboardShortcutText(action.getShortcutSet());
    }

    @NotNull
    @NlsSafe
    public static String getFirstKeyboardShortcutText(@NotNull ShortcutSet set) {
        Object[] shortcuts;
        KeyboardShortcut shortcut;
        if (set == null) {
            KeymapUtil.$$$reportNull$$$0(18);
        }
        return (shortcut = (KeyboardShortcut)ContainerUtil.findInstance((Object[])(shortcuts = set.getShortcuts()), KeyboardShortcut.class)) == null ? "" : KeymapUtil.getShortcutText((Shortcut)shortcut);
    }

    @NotNull
    @NlsSafe
    public static String getPreferredShortcutText(Shortcut @NotNull [] shortcuts) {
        KeyboardShortcut shortcut;
        if (shortcuts == null) {
            KeymapUtil.$$$reportNull$$$0(19);
        }
        return (shortcut = (KeyboardShortcut)ContainerUtil.findInstance((Object[])shortcuts, KeyboardShortcut.class)) != null ? KeymapUtil.getShortcutText((Shortcut)shortcut) : (shortcuts.length > 0 ? KeymapUtil.getShortcutText(shortcuts[0]) : "");
    }

    @NotNull
    @NlsSafe
    public static String getShortcutsText(Shortcut @NotNull [] shortcuts) {
        if (shortcuts == null) {
            KeymapUtil.$$$reportNull$$$0(20);
        }
        if (shortcuts.length == 0) {
            return "";
        }
        String string = Arrays.stream(shortcuts).map(KeymapUtil::getShortcutText).collect(Collectors.joining(" "));
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static MouseShortcut parseMouseShortcut(@NotNull String keystrokeString) throws InvalidDataException {
        if (keystrokeString == null) {
            KeymapUtil.$$$reportNull$$$0(22);
        }
        MouseShortcut mouseShortcut = ourDefaultKeymapTextContext.parseMouseShortcut(keystrokeString);
        if (mouseShortcut == null) {
            KeymapUtil.$$$reportNull$$$0(23);
        }
        return mouseShortcut;
    }

    @Nullable
    public static KeyStroke getKeyStroke(@NotNull String s) {
        if (s == null) {
            KeymapUtil.$$$reportNull$$$0(24);
        }
        KeyStroke result2 = null;
        if (((String)s).length() >= 2 && ((String)s).charAt(((String)s).length() - 2) == ' ' && Character.isLowerCase(((String)s).charAt(((String)s).length() - 1))) {
            s = ((String)s).substring(0, ((String)s).length() - 1) + Character.toUpperCase(((String)s).charAt(((String)s).length() - 1));
        }
        try {
            result2 = KeyStroke.getKeyStroke((String)s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result2 == null && ((String)s).length() >= 2 && ((String)s).charAt(((String)s).length() - 2) == ' ') {
            try {
                String s1 = ((String)s).substring(0, ((String)s).length() - 1) + Character.toUpperCase(((String)s).charAt(((String)s).length() - 1));
                result2 = KeyStroke.getKeyStroke(s1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result2;
    }

    @NotNull
    public static String getMouseShortcutString(@NotNull MouseShortcut shortcut) {
        if (shortcut == null) {
            KeymapUtil.$$$reportNull$$$0(25);
        }
        String string = ourDefaultKeymapTextContext.getMouseShortcutString(shortcut);
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    public static boolean isTooltipRequest(@NotNull KeyEvent keyEvent) {
        if (keyEvent == null) {
            KeymapUtil.$$$reportNull$$$0(27);
        }
        if (ourTooltipKeysProperty == null) {
            ourTooltipKeysProperty = Registry.get((String)"ide.forcedShowTooltip");
            ourTooltipKeysProperty.addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value2) {
                    if (value2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    KeymapUtil.updateTooltipRequestKey(value2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/keymap/KeymapUtil$1", "afterValueChanged"));
                }
            }, (Disposable)ApplicationManager.getApplication());
            KeymapUtil.updateTooltipRequestKey(ourTooltipKeysProperty);
        }
        if (keyEvent.getID() != 401) {
            return false;
        }
        for (Integer each : ourTooltipKeys) {
            if ((keyEvent.getModifiers() & each) != 0) continue;
            return false;
        }
        for (Integer each : ourOtherTooltipKeys) {
            if ((keyEvent.getModifiers() & each) <= 0) continue;
            return false;
        }
        int code = keyEvent.getKeyCode();
        return code == 157 || code == 17 || code == 16 || code == 18;
    }

    private static void updateTooltipRequestKey(@NotNull RegistryValue value2) {
        if (value2 == null) {
            KeymapUtil.$$$reportNull$$$0(28);
        }
        String text = value2.asString();
        ourTooltipKeys.clear();
        ourOtherTooltipKeys.clear();
        KeymapUtil.processKey(text.contains("meta"), 4);
        KeymapUtil.processKey(text.contains("control") || text.contains("ctrl"), 2);
        KeymapUtil.processKey(text.contains("shift"), 1);
        KeymapUtil.processKey(text.contains("alt"), 8);
    }

    private static void processKey(boolean condition, int value2) {
        if (condition) {
            ourTooltipKeys.add(value2);
        } else {
            ourOtherTooltipKeys.add(value2);
        }
    }

    public static boolean isEmacsKeymap() {
        return KeymapUtil.isEmacsKeymap(KeymapManager.getInstance().getActiveKeymap());
    }

    public static boolean isEmacsKeymap(@Nullable Keymap keymap) {
        while (keymap != null) {
            if ("Emacs".equalsIgnoreCase(keymap.getName())) {
                return true;
            }
            keymap = keymap.getParent();
        }
        return false;
    }

    @Nullable
    public static KeyStroke getKeyStroke(@NotNull ShortcutSet shortcutSet) {
        Shortcut shortcut;
        Shortcut[] shortcuts;
        if (shortcutSet == null) {
            KeymapUtil.$$$reportNull$$$0(29);
        }
        if ((shortcuts = shortcutSet.getShortcuts()).length == 0 || !((shortcut = shortcuts[0]) instanceof KeyboardShortcut)) {
            return null;
        }
        KeyboardShortcut shortcut2 = (KeyboardShortcut)shortcut;
        if (shortcut2.getSecondKeyStroke() != null) {
            return null;
        }
        return shortcut2.getFirstKeyStroke();
    }

    @NotNull
    public static Collection<KeyStroke> getKeyStrokes(@NotNull ShortcutSet shortcutSet) {
        Shortcut[] shortcuts;
        if (shortcutSet == null) {
            KeymapUtil.$$$reportNull$$$0(30);
        }
        if ((shortcuts = shortcutSet.getShortcuts()).length == 0) {
            Set<KeyStroke> set = Collections.emptySet();
            if (set == null) {
                KeymapUtil.$$$reportNull$$$0(31);
            }
            return set;
        }
        HashSet result2 = new HashSet();
        for (Shortcut shortcut : shortcuts) {
            KeyboardShortcut kbShortcut;
            if (!(shortcut instanceof KeyboardShortcut) || (kbShortcut = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
            result2.add(kbShortcut.getFirstKeyStroke());
        }
        Set<KeyStroke> set = result2.isEmpty() ? Collections.emptySet() : result2;
        if (set == null) {
            KeymapUtil.$$$reportNull$$$0(32);
        }
        return set;
    }

    @NlsContexts.Tooltip
    @NotNull
    public static String createTooltipText(@NlsContexts.Tooltip @NotNull String name, @NotNull @NonNls String actionId) {
        String text;
        if (name == null) {
            KeymapUtil.$$$reportNull$$$0(33);
        }
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(34);
        }
        Object object = (text = KeymapUtil.getFirstKeyboardShortcutText(actionId)).isEmpty() ? name : name + " (" + text + ")";
        if (object == null) {
            KeymapUtil.$$$reportNull$$$0(35);
        }
        return object;
    }

    @NotNull
    @NlsSafe
    public static String createTooltipText(@Nullable String name, @NotNull AnAction action) {
        Object toolTipText;
        if (action == null) {
            KeymapUtil.$$$reportNull$$$0(36);
        }
        Object object = toolTipText = name == null ? "" : name;
        while (StringUtil.endsWithChar((CharSequence)toolTipText, (char)'.')) {
            toolTipText = ((String)toolTipText).substring(0, ((String)toolTipText).length() - 1);
        }
        String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText(action);
        if (!shortcutsText.isEmpty()) {
            toolTipText = (String)toolTipText + " (" + shortcutsText + ")";
        }
        String string = toolTipText;
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    public static String getModifiersText(@JdkConstants.InputEventMask int modifiers) {
        String string = ourDefaultKeymapTextContext.getModifiersText(KeymapTextContext.mapNewModifiers(modifiers), false);
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(38);
        }
        return string;
    }

    public static boolean matchActionMouseShortcutsModifiers(@NotNull Keymap activeKeymap, @JdkConstants.InputEventMask int modifiers, @NotNull @NonNls String actionId) {
        if (activeKeymap == null) {
            KeymapUtil.$$$reportNull$$$0(39);
        }
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(40);
        }
        MouseShortcut syntheticShortcut = new MouseShortcut(1, modifiers, 1);
        for (Shortcut shortcut : activeKeymap.getShortcuts(actionId)) {
            MouseShortcut mouseShortcut;
            if (!(shortcut instanceof MouseShortcut) || (mouseShortcut = (MouseShortcut)shortcut).getModifiers() != syntheticShortcut.getModifiers()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static MouseShortcut createMouseShortcut(@NotNull MouseEvent e) {
        if (e == null) {
            KeymapUtil.$$$reportNull$$$0(41);
        }
        int button2 = MouseShortcut.getButton(e);
        int modifiers = e.getModifiersEx();
        if (button2 == 0 && e.getID() == 506) {
            if ((modifiers & 0x400) != 0) {
                button2 = 1;
            } else if ((modifiers & 0x800) != 0) {
                button2 = 2;
            }
        }
        return new MouseShortcut(button2, modifiers, 1);
    }

    public static boolean reassignAction(@NotNull JComponent component, @NotNull KeyStroke oldKeyStroke, @Nullable KeyStroke newKeyStroke, int condition) {
        if (component == null) {
            KeymapUtil.$$$reportNull$$$0(42);
        }
        if (oldKeyStroke == null) {
            KeymapUtil.$$$reportNull$$$0(43);
        }
        return KeymapUtil.reassignAction(component, oldKeyStroke, newKeyStroke, condition, true);
    }

    public static boolean reassignAction(@NotNull JComponent component, @NotNull KeyStroke oldKeyStroke, @Nullable KeyStroke newKeyStroke, int condition, boolean muteOldKeystroke) {
        ActionListener action;
        if (component == null) {
            KeymapUtil.$$$reportNull$$$0(44);
        }
        if (oldKeyStroke == null) {
            KeymapUtil.$$$reportNull$$$0(45);
        }
        if ((action = component.getActionForKeyStroke(oldKeyStroke)) == null) {
            return false;
        }
        if (newKeyStroke != null) {
            component.registerKeyboardAction(action, newKeyStroke, condition);
        }
        if (muteOldKeystroke) {
            component.registerKeyboardAction(new RedispatchEventAction(component), oldKeyStroke, condition);
        }
        return true;
    }

    @Nullable
    public static ShortcutSet filterKeyStrokes(@NotNull ShortcutSet source, KeyStroke ... toLeaveOut) {
        if (source == null) {
            KeymapUtil.$$$reportNull$$$0(46);
        }
        ArrayList<Shortcut> filtered = new ArrayList<Shortcut>(Arrays.asList(source.getShortcuts()));
        for (Shortcut shortcut : source.getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut) || ArrayUtil.find((Object[])toLeaveOut, (Object)((KeyboardShortcut)shortcut).getFirstKeyStroke()) == -1) continue;
            filtered.remove(shortcut);
        }
        return filtered.isEmpty() ? null : new CustomShortcutSet(filtered.toArray(Shortcut.EMPTY_ARRAY));
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static CustomShortcutSet getMnemonicAsShortcut(int mnemonic) {
        return KeymapUtil.getShortcutsForMnemonicCode(mnemonic);
    }

    @Nullable
    public static CustomShortcutSet getShortcutsForMnemonicChar(char mnemonic) {
        return KeymapUtil.getShortcutsForMnemonicCode(KeyEvent.getExtendedKeyCodeForChar(mnemonic));
    }

    @Nullable
    public static CustomShortcutSet getShortcutsForMnemonicCode(int mnemonic) {
        if (mnemonic != 0) {
            KeyboardShortcut ctrlAltShortcut = new KeyboardShortcut(KeyStroke.getKeyStroke(mnemonic, 640), null);
            KeyboardShortcut altShortcut = new KeyboardShortcut(KeyStroke.getKeyStroke(mnemonic, 512), null);
            CustomShortcutSet shortcutSet = SystemInfo.isMac ? (Registry.is((String)"ide.mac.alt.mnemonic.without.ctrl") ? new CustomShortcutSet(new Shortcut[]{ctrlAltShortcut, altShortcut}) : new CustomShortcutSet(new Shortcut[]{ctrlAltShortcut})) : new CustomShortcutSet(new Shortcut[]{altShortcut});
            return shortcutSet;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6, 8, 9, 10, 21, 23, 26, 31, 32, 35, 37, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 21: 
            case 23: 
            case 26: 
            case 31: 
            case 32: 
            case 35: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/KeymapUtil";
                break;
            }
            case 2: 
            case 4: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 5: 
            case 7: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcut";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymapManager";
                break;
            }
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyEvent";
                break;
            }
            case 17: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcuts";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keystrokeString";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutSet";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeKeymap";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldKeyStroke";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/KeymapUtil";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMouseShortcutText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeystrokeText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyText";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutsText";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMouseShortcut";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getMouseShortcutString";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyStrokes";
                break;
            }
            case 35: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltipText";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiersText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getShortcutText";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 21: 
            case 23: 
            case 26: 
            case 31: 
            case 32: 
            case 35: 
            case 37: 
            case 38: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getShortcutTextOrNull";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMouseShortcutText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getActiveKeymapShortcuts";
                break;
            }
            case 13: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFirstKeyboardShortcutText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFirstMouseShortcutText";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isEventForAction";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredShortcutText";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getShortcutsText";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseMouseShortcut";
                break;
            }
            case 24: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getKeyStroke";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMouseShortcutString";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isTooltipRequest";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updateTooltipRequestKey";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getKeyStrokes";
                break;
            }
            case 33: 
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createTooltipText";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "matchActionMouseShortcutsModifiers";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createMouseShortcut";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "reassignAction";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "filterKeyStrokes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6, 8, 9, 10, 21, 23, 26, 31, 32, 35, 37, 38 -> new IllegalStateException(string);
        };
    }

    private static final class RedispatchEventAction
    extends AbstractAction {
        private final Component myComponent;

        RedispatchEventAction(@NotNull Component component) {
            if (component == null) {
                RedispatchEventAction.$$$reportNull$$$0(0);
            }
            this.myComponent = component;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Container parent;
            AWTEvent event = EventQueue.getCurrentEvent();
            if (event instanceof KeyEvent && event.getSource() == this.myComponent && (parent = this.myComponent.getParent()) != null) {
                KeyEvent keyEvent = (KeyEvent)event;
                parent.dispatchEvent(new KeyEvent(parent, event.getID(), ((KeyEvent)event).getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/keymap/KeymapUtil$RedispatchEventAction", "<init>"));
        }
    }
}

