/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.UiSwitcher;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.validation.DialogValidation;
import com.intellij.openapi.ui.validation.DialogValidationRequestor;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0001\u0018\u00002\u00020\u0001:\u0001-B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J(\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J2\u0010\u001e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\f2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u001fj\u0002` H\u0002J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\r2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\rH\u0002J\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000eJ\u001c\u0010'\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\b\u0010)\u001a\u00020\u0011H\u0002J(\u0010*\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010+\u001a\u00020\u0011H\u0002J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/openapi/ui/DialogPanelValidator;", "", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/ui/DialogPanel;Lcom/intellij/openapi/Disposable;)V", "panels", "Lcom/intellij/util/containers/DisposableWrapperList;", "validationStatus", "", "Ljavax/swing/JComponent;", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/openapi/ui/ValidationStatus;", "validationListeners", "Lkotlin/Function0;", "", "applyValidationRequestor", "Lcom/intellij/openapi/ui/DialogPanelValidator$ApplyValidationRequestor;", "registerPanel", "registerIntegratedPanels", "parent", "registerIntegratedPanel", "child", "registerValidators", "registerValidator", "validator", "Lcom/intellij/openapi/ui/ComponentValidator;", "component", "applyValidations", "", "Lcom/intellij/openapi/ui/MutableValidationStatus;", "validations", "", "Lcom/intellij/openapi/ui/validation/DialogValidation;", "logValidationInfoInHeadlessMode", "info", "getValidationStatus", "whenValidationStatusChanged", "listener", "fireValidationStatusChanged", "registerValidationRequestors", "showComponentWithInvalidData", "validateAll", "ApplyValidationRequestor", "intellij.platform.ide"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDialogPanelValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogPanelValidator.kt\ncom/intellij/openapi/ui/DialogPanelValidator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n13#2:195\n1374#3:196\n1460#3,5:197\n1193#3,2:202\n1267#3,4:204\n1869#3,2:208\n1740#3,3:210\n*S KotlinDebug\n*F\n+ 1 DialogPanelValidator.kt\ncom/intellij/openapi/ui/DialogPanelValidator\n*L\n111#1:195\n117#1:196\n117#1:197,5\n118#1:202,2\n118#1:204,4\n126#1:208,2\n150#1:210,3\n*E\n"})
public final class DialogPanelValidator {
    @NotNull
    private final DialogPanel panel;
    @NotNull
    private final DisposableWrapperList<DialogPanel> panels;
    @NotNull
    private final DisposableWrapperList<Map<JComponent, ValidationInfo>> validationStatus;
    @NotNull
    private final DisposableWrapperList<Function0<Unit>> validationListeners;
    @NotNull
    private final ApplyValidationRequestor applyValidationRequestor;

    public DialogPanelValidator(@NotNull DialogPanel panel2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)((Object)panel2), (String)"panel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.panel = panel2;
        this.panels = new DisposableWrapperList();
        this.validationStatus = new DisposableWrapperList();
        this.validationListeners = new DisposableWrapperList();
        this.applyValidationRequestor = new ApplyValidationRequestor();
        this.registerPanel(this.panel, parentDisposable);
    }

    private final void registerPanel(DialogPanel panel2, Disposable parentDisposable) {
        this.panels.add((Object)panel2, parentDisposable);
        this.registerIntegratedPanels(panel2, parentDisposable);
        this.registerValidators(panel2, parentDisposable);
    }

    private final void registerIntegratedPanels(DialogPanel parent, Disposable parentDisposable) {
        for (DialogPanel child : parent.getIntegratedPanels()) {
            this.registerIntegratedPanel(parent, child, parentDisposable);
        }
        parent.whenIntegratedPanelRegistered(parentDisposable, (Function1<? super DialogPanel, Unit>)((Function1)arg_0 -> DialogPanelValidator.registerIntegratedPanels$lambda$0(this, parent, parentDisposable, arg_0)));
    }

    private final void registerIntegratedPanel(DialogPanel parent, DialogPanel child, Disposable parentDisposable) {
        Disposable disposable = Disposer.newDisposable((Disposable)parentDisposable, (String)("Integrated panel disposable for " + child));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        parent.whenIntegratedPanelUnregistered(parentDisposable, (Function1<? super DialogPanel, Unit>)((Function1)arg_0 -> DialogPanelValidator.registerIntegratedPanel$lambda$0(child, disposable2, arg_0)));
        this.registerPanel(child, disposable2);
    }

    private final void registerValidators(DialogPanel panel2, Disposable parentDisposable) {
        Set components = SetsKt.plus(panel2.getValidationsOnInput().keySet(), (Iterable)panel2.getValidationsOnApply().keySet());
        for (JComponent component : components) {
            ComponentValidator validator = new ComponentValidator(parentDisposable);
            this.registerValidator(validator, panel2, component, parentDisposable);
            this.registerValidationRequestors(panel2, component, validator, parentDisposable);
            validator.installOn(component);
        }
    }

    private final void registerValidator(ComponentValidator validator, DialogPanel panel2, JComponent component, Disposable parentDisposable) {
        LinkedHashMap validationStatus = new LinkedHashMap();
        this.validationStatus.add(validationStatus, parentDisposable);
        validator.withValidator(() -> DialogPanelValidator.registerValidator$lambda$0(this, panel2, component, validationStatus));
    }

    private final ValidationInfo applyValidations(DialogPanel panel2, JComponent component, Map<JComponent, ValidationInfo> validationStatus) {
        List list;
        if (this.applyValidationRequestor.isActive()) {
            list = panel2.getValidationsOnApply().get(component);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
        } else {
            list = panel2.getValidationsOnInput().get(component);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
        }
        List validations = list;
        ValidationInfo validationInfo = this.applyValidations(validations);
        if (!Intrinsics.areEqual((Object)validationStatus.get(component), (Object)validationInfo)) {
            if (validationInfo != null) {
                validationStatus.put(component, validationInfo);
                this.logValidationInfoInHeadlessMode(validationInfo);
            } else {
                validationStatus.remove(component);
            }
            this.fireValidationStatusChanged();
        }
        return validationInfo;
    }

    private final ValidationInfo applyValidations(List<? extends DialogValidation> validations) {
        ValidationInfo result2 = null;
        for (DialogValidation dialogValidation : validations) {
            ValidationInfo validationInfo = dialogValidation.validate();
            if (validationInfo == null) continue;
            if (!validationInfo.okEnabled) {
                return validationInfo;
            }
            if (result2 != null && validationInfo.warning) continue;
            result2 = validationInfo;
        }
        return result2;
    }

    private final void logValidationInfoInHeadlessMode(ValidationInfo info) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(DialogPanel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(info.message);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<JComponent, ValidationInfo> getValidationStatus() {
        void $this$associateTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = (Iterable)this.validationStatus;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Map it = (Map)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.entrySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getKey(), it.getValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    public final void whenValidationStatusChanged(@NotNull Disposable parentDisposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.validationListeners.add(listener2, parentDisposable);
    }

    private final void fireValidationStatusChanged() {
        Iterable $this$forEach$iv = (Iterable)this.validationListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    private final void registerValidationRequestors(DialogPanel panel2, JComponent component, ComponentValidator validator, Disposable parentDisposable) {
        List validationRequestors;
        List list = panel2.getValidationRequestors().get(component);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if ((validationRequestors = list).isEmpty() && component instanceof JTextComponent) {
            validator.andRegisterOnDocumentListener((JTextComponent)component);
        }
        for (DialogValidationRequestor validationRequestor : validationRequestors) {
            validationRequestor.subscribe(parentDisposable, (Function0<Unit>)((Function0)new Function0<Unit>((Object)validator){

                public final void invoke() {
                    ((ComponentValidator)this.receiver).revalidate();
                }
            }));
        }
        this.applyValidationRequestor.subscribe(parentDisposable, (Function0<Unit>)((Function0)new Function0<Unit>((Object)validator){

            public final void invoke() {
                ((ComponentValidator)this.receiver).revalidate();
            }
        }));
    }

    private final void showComponentWithInvalidData() {
        boolean bl;
        List components;
        block5: {
            components = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getValidationStatus().entrySet()), DialogPanelValidator::showComponentWithInvalidData$lambda$0), DialogPanelValidator::showComponentWithInvalidData$lambda$1));
            Iterable $this$all$iv = components;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    JComponent it = (JComponent)element$iv;
                    boolean bl2 = false;
                    if (!it.isShowing()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            for (JComponent component : components) {
                UiSwitcher.Companion.show(component);
            }
        }
        this.panel.setPreferredFocusedComponent((JComponent)CollectionsKt.firstOrNull((List)components));
    }

    @NotNull
    public final List<ValidationInfo> validateAll() {
        this.applyValidationRequestor.validateAll();
        Sequence validationInfoList = SequencesKt.mapNotNull((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)this.panels)), DialogPanelValidator::validateAll$lambda$0), DialogPanelValidator::validateAll$lambda$1);
        this.showComponentWithInvalidData();
        return CollectionsKt.plus(this.getValidationStatus().values(), (Sequence)validationInfoList);
    }

    private static final Unit registerIntegratedPanels$lambda$0(DialogPanelValidator this$0, DialogPanel $parent, Disposable $parentDisposable, DialogPanel it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        this$0.registerIntegratedPanel($parent, it, $parentDisposable);
        return Unit.INSTANCE;
    }

    private static final Unit registerIntegratedPanel$lambda$0(DialogPanel $child, Disposable $disposable, DialogPanel it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        if (it == $child) {
            Disposer.dispose((Disposable)$disposable);
        }
        return Unit.INSTANCE;
    }

    private static final ValidationInfo registerValidator$lambda$0(DialogPanelValidator this$0, DialogPanel $panel, JComponent $component, LinkedHashMap $validationStatus) {
        return this$0.applyValidations($panel, $component, $validationStatus);
    }

    private static final boolean showComponentWithInvalidData$lambda$0(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !((ValidationInfo)it.getValue()).okEnabled;
    }

    private static final JComponent showComponentWithInvalidData$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (JComponent)it.getKey();
    }

    private static final Iterable validateAll$lambda$0(DialogPanel it) {
        return it.get_validateCallbacks$intellij_platform_ide();
    }

    private static final ValidationInfo validateAll$lambda$1(DialogValidation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.validate();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\u0007J \u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/ui/DialogPanelValidator$ApplyValidationRequestor;", "Lcom/intellij/openapi/ui/validation/DialogValidationRequestor;", "<init>", "()V", "validators", "Lcom/intellij/util/containers/DisposableWrapperList;", "Lkotlin/Function0;", "", "value", "", "isActive", "()Z", "validateAll", "subscribe", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "validate", "intellij.platform.ide"})
    @SourceDebugExtension(value={"SMAP\nDialogPanelValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogPanelValidator.kt\ncom/intellij/openapi/ui/DialogPanelValidator$ApplyValidationRequestor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n1869#2,2:195\n*S KotlinDebug\n*F\n+ 1 DialogPanelValidator.kt\ncom/intellij/openapi/ui/DialogPanelValidator$ApplyValidationRequestor\n*L\n178#1:195,2\n*E\n"})
    private static final class ApplyValidationRequestor
    implements DialogValidationRequestor {
        @NotNull
        private final DisposableWrapperList<Function0<Unit>> validators = new DisposableWrapperList();
        private boolean isActive;

        public final boolean isActive() {
            return this.isActive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void validateAll() {
            this.isActive = true;
            try {
                Iterable $this$forEach$iv = (Iterable)this.validators;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function0 it = (Function0)element$iv;
                    boolean bl = false;
                    it.invoke();
                }
            }
            finally {
                this.isActive = false;
            }
        }

        @Override
        public void subscribe(@Nullable Disposable parentDisposable, @NotNull Function0<Unit> validate) {
            Intrinsics.checkNotNullParameter(validate, (String)"validate");
            if (parentDisposable == null) {
                this.validators.add(validate);
            } else {
                Disposable disposable = this.validators.add(validate, parentDisposable);
                Intrinsics.checkNotNull((Object)disposable);
            }
        }
    }
}

