/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.cellvalidators;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.cellvalidators.TableCellValidator;
import com.intellij.ui.CellRendererPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ValidatingTableCellRendererWrapper
extends CellRendererPanel
implements TableCellRenderer {
    public static final String CELL_VALIDATION_PROPERTY = "CellRenderer.validationInfo";
    private final TableCellRenderer delegate;
    private final JLabel iconLabel = new JLabel();
    private Supplier<? extends Dimension> editorSizeSupplier = () -> JBUI.emptySize();
    private TableCellValidator cellValidator;

    @ApiStatus.Experimental
    public ValidatingTableCellRendererWrapper(TableCellRenderer delegate) {
        this.delegate = delegate;
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.iconLabel, "East");
        this.iconLabel.setOpaque(false);
        this.setName("Table.cellRenderer");
    }

    @ApiStatus.Experimental
    public ValidatingTableCellRendererWrapper bindToEditorSize(@NotNull Supplier<? extends Dimension> editorSizeSupplier) {
        if (editorSizeSupplier == null) {
            ValidatingTableCellRendererWrapper.$$$reportNull$$$0(0);
        }
        this.editorSizeSupplier = editorSizeSupplier;
        return this;
    }

    @ApiStatus.Experimental
    public ValidatingTableCellRendererWrapper withCellValidator(@NotNull TableCellValidator cellValidator) {
        if (cellValidator == null) {
            ValidatingTableCellRendererWrapper.$$$reportNull$$$0(1);
        }
        this.cellValidator = cellValidator;
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = Math.max(size.height, this.editorSizeSupplier.get().height);
        return size;
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent delegateRenderer = (JComponent)this.delegate.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
        if (this.cellValidator != null) {
            ValidationInfo result2 = this.cellValidator.validate(value2, row, column);
            this.iconLabel.setIcon(result2 == null ? null : (result2.warning ? AllIcons.General.BalloonWarning : AllIcons.General.BalloonError));
            this.iconLabel.setBorder(result2 == null ? null : ValidatingTableCellRendererWrapper.iconBorder());
            this.putClientProperty(CELL_VALIDATION_PROPERTY, result2);
        }
        this.add((Component)delegateRenderer, "Center");
        this.setToolTipText(delegateRenderer.getToolTipText());
        this.setBorder(delegateRenderer.getBorder());
        delegateRenderer.setBorder(null);
        this.setBackground(delegateRenderer.getBackground());
        return this;
    }

    private static Border iconBorder() {
        return JBUI.Borders.emptyRight((int)(UIUtil.isUnderWin10LookAndFeel() ? 4 : 3));
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorSizeSupplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellValidator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/ui/cellvalidators/ValidatingTableCellRendererWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "bindToEditorSize";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "withCellValidator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

