/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.Behavior;
import com.intellij.ui.components.DefaultScrollBarUI;
import com.intellij.ui.components.DefaultScrollbarUiInstalledState;
import com.intellij.ui.components.MacScrollBarAnimationBehavior;
import com.intellij.ui.components.MacScrollBarUI;
import com.intellij.ui.components.MacScrollBarUIKt;
import com.intellij.ui.components.MacScrollbarNative;
import com.intellij.ui.components.MacScrollbarStyle;
import com.intellij.ui.components.ScrollBarAnimationBehavior;
import com.intellij.ui.components.TwoWayAnimator;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.sun.jna.Pointer;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.plaf.ScrollBarUI;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \"2\u00020\u0001:\u0001\"B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J%\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\u001cJ\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010!H\u0014R\u0014\u0010\u0013\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/intellij/ui/components/MacScrollBarUI;", "Lcom/intellij/ui/components/DefaultScrollBarUI;", "thickness", "", "thicknessMax", "thicknessMin", "<init>", "(III)V", "()V", "createBaseAnimationBehavior", "Lcom/intellij/ui/components/ScrollBarAnimationBehavior;", "state", "Lcom/intellij/ui/components/DefaultScrollbarUiInstalledState;", "createBaseAnimationBehavior$intellij_platform_ide", "isAbsolutePositioning", "", "event", "Ljava/awt/event/MouseEvent;", "isTrackClickable", "isTrackExpandable", "()Z", "paintTrack", "", "g", "Ljava/awt/Graphics2D;", "c", "Ljavax/swing/JComponent;", "paintThumb", "paintThumb$intellij_platform_ide", "installUI", "uninstallUI", "updateStyle", "style", "Lcom/intellij/ui/components/MacScrollbarStyle;", "Companion", "intellij.platform.ide"})
public class MacScrollBarUI
extends DefaultScrollBarUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Companion.CURRENT_STYLE.1 CURRENT_STYLE = new MacScrollbarNative<MacScrollbarStyle>(){

        public void run() {
            MacScrollbarStyle newStyle;
            if (!SystemInfoRt.isMac) {
                return;
            }
            MacScrollbarStyle oldStyle = this.invoke();
            if (!Registry.Companion.is("ide.mac.disableMacScrollbars", false)) {
                super.run();
            }
            if ((newStyle = this.invoke()) != oldStyle) {
                ArrayList<E> list = new ArrayList<E>();
                MacScrollBarUIKt.access$processReferences(null, null, list);
                Iterator<E> iterator = list.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator<E> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    E e = iterator2.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    MacScrollBarUI ui = (MacScrollBarUI)e;
                    ui.updateStyle(newStyle);
                }
            }
        }

        public MacScrollbarStyle invoke() {
            ID iD = Foundation.invoke((ID)Foundation.getObjcClass((String)"NSScroller"), (String)"preferredScrollerStyle", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"invoke(...)");
            ID style = iD;
            MacScrollbarStyle value2 = 1 == style.intValue() ? MacScrollbarStyle.Overlay : MacScrollbarStyle.Legacy;
            Object[] objectArray = new Object[]{value2, " from ", style};
            Logger.getInstance(MacScrollBarUI.class).debug("scroll bar style ", objectArray);
            return value2;
        }

        public String toString() {
            return "scroll bar style";
        }

        public ID initialize() {
            if (!SystemInfoRt.isMac) {
                ID iD = ID.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"NIL");
                return iD;
            }
            ID iD = Foundation.invoke((String)"NSNotificationCenter", (String)"defaultCenter", (Object[])new Object[0]);
            Object[] objectArray = new Object[4];
            Pointer pointer = Foundation.createSelector((String)"handleScrollerStyleChanged:");
            Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"createSelector(...)");
            objectArray[0] = MacScrollBarUIKt.access$createDelegate("JBScrollBarStyleObserver", pointer, this);
            objectArray[1] = Foundation.createSelector((String)"handleScrollerStyleChanged:");
            objectArray[2] = Foundation.nsString((String)"NSPreferredScrollerStyleDidChangeNotification");
            objectArray[3] = ID.NIL;
            ID iD2 = Foundation.invoke((ID)iD, (String)"addObserver:selector:name:object:", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)iD2, (String)"invoke(...)");
            return iD2;
        }
    };
    @NotNull
    private static final AtomicReference<AWTEventListener> MOVEMENT_LISTENER = new AtomicReference<Companion.MOVEMENT_LISTENER.1>(new AWTEventListener(){

        public void eventDispatched(AWTEvent event) {
            JScrollPane pane;
            Object source;
            if (event != null && 503 == event.getID() && (source = event.getSource()) instanceof Component && (pane = (JScrollPane)ComponentUtil.getParentOfType(JScrollPane.class, (Component)((Component)source))) != null) {
                this.pauseThumbAnimation(pane.getHorizontalScrollBar());
                this.pauseThumbAnimation(pane.getVerticalScrollBar());
            }
        }

        private final void pauseThumbAnimation(JScrollBar bar) {
            ScrollBarUI ui;
            JScrollBar jScrollBar = bar;
            ScrollBarUI scrollBarUI = ui = jScrollBar != null ? jScrollBar.getUI() : null;
            if (ui instanceof MacScrollBarUI) {
                DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = ((MacScrollBarUI)ui).getInstalledState$intellij_platform_ide();
                Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
                ScrollBarAnimationBehavior animationBehavior = defaultScrollbarUiInstalledState.animationBehavior;
                if (0.0f < animationBehavior.getThumbFrame()) {
                    animationBehavior.onThumbMove();
                }
            }
        }
    });

    public MacScrollBarUI(int thickness, int thicknessMax, int thicknessMin) {
        super(thickness, thicknessMax, thicknessMin);
    }

    public MacScrollBarUI() {
        super(14, 14, 11);
    }

    @Override
    @NotNull
    public ScrollBarAnimationBehavior createBaseAnimationBehavior$intellij_platform_ide(@NotNull DefaultScrollbarUiInstalledState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!SystemInfoRt.isMac) {
            return super.createBaseAnimationBehavior$intellij_platform_ide(state);
        }
        CoroutineScope coroutineScope = state.coroutineScope;
        Function0 function0 = () -> MacScrollBarUI.createBaseAnimationBehavior$lambda$0(state);
        TwoWayAnimator twoWayAnimator = state.track.animator;
        Intrinsics.checkNotNullExpressionValue((Object)twoWayAnimator, (String)"animator");
        TwoWayAnimator twoWayAnimator2 = state.thumb.animator;
        Intrinsics.checkNotNullExpressionValue((Object)twoWayAnimator2, (String)"animator");
        return new MacScrollBarAnimationBehavior(coroutineScope, (Function0<? extends JScrollBar>)function0, twoWayAnimator, twoWayAnimator2);
    }

    @Override
    public boolean isAbsolutePositioning(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!SystemInfoRt.isMac) {
            return super.isAbsolutePositioning(event);
        }
        return Behavior.JumpToSpot == Behavior.Companion.getCURRENT_BEHAVIOR().invoke();
    }

    @Override
    public boolean isTrackClickable() {
        if (!SystemInfoRt.isMac) {
            return super.isTrackClickable();
        }
        DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = this.getInstalledState$intellij_platform_ide();
        if (defaultScrollbarUiInstalledState == null) {
            return false;
        }
        DefaultScrollbarUiInstalledState state = defaultScrollbarUiInstalledState;
        return DefaultScrollBarUI.Companion.isOpaque(state.scrollBar) || state.animationBehavior.getTrackFrame() > 0.0f && state.animationBehavior.getThumbFrame() > 0.0f;
    }

    @Override
    public boolean isTrackExpandable() {
        if (!SystemInfoRt.isMac) {
            return super.isTrackExpandable();
        }
        DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = this.getInstalledState$intellij_platform_ide();
        Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
        return !DefaultScrollBarUI.Companion.isOpaque(defaultScrollbarUiInstalledState.scrollBar);
    }

    @Override
    protected void paintTrack(@NotNull Graphics2D g, @NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        DefaultScrollbarUiInstalledState defaultScrollbarUiInstalledState = this.getInstalledState$intellij_platform_ide();
        Intrinsics.checkNotNull((Object)defaultScrollbarUiInstalledState);
        ScrollBarAnimationBehavior animationBehavior = defaultScrollbarUiInstalledState.animationBehavior;
        if (animationBehavior.getTrackFrame() > 0.0f && animationBehavior.getThumbFrame() > 0.0f || DefaultScrollBarUI.Companion.isOpaque(c) || !SystemInfoRt.isMac) {
            super.paintTrack(g, c);
        }
    }

    @Override
    public void paintThumb$intellij_platform_ide(@NotNull Graphics2D g, @NotNull JComponent c, @NotNull DefaultScrollbarUiInstalledState state) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!SystemInfoRt.isMac) {
            super.paintThumb$intellij_platform_ide(g, c, state);
        } else if (DefaultScrollBarUI.Companion.isOpaque(c)) {
            this.paint(state.thumb, g, c, true);
        } else if (state.animationBehavior.getThumbFrame() > 0.0f) {
            this.paint(state.thumb, g, c, false);
        }
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        super.installUI(c);
        if (SystemInfoRt.isMac) {
            this.updateStyle(CURRENT_STYLE.invoke());
        } else {
            this.updateStyle(MacScrollbarStyle.Overlay);
        }
        MacScrollBarUIKt.access$processReferences(this, null, null);
        AWTEventListener listener2 = MOVEMENT_LISTENER.getAndSet(null);
        if (listener2 != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(listener2, 32L);
        }
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        MacScrollBarUIKt.access$processReferences(null, this, null);
        super.uninstallUI(c);
    }

    protected void updateStyle(@Nullable MacScrollbarStyle style) {
        DefaultScrollbarUiInstalledState state = this.getInstalledState$intellij_platform_ide();
        Object object = state;
        if (object == null || (object = ((DefaultScrollbarUiInstalledState)object).scrollBar) == null) {
            return;
        }
        Object scrollBar = object;
        ((JComponent)scrollBar).setOpaque(style != MacScrollbarStyle.Overlay);
        ((JComponent)scrollBar).revalidate();
        ((Component)scrollBar).repaint();
        state.animationBehavior.onThumbMove();
    }

    private static final JScrollBar createBaseAnimationBehavior$lambda$0(DefaultScrollbarUiInstalledState $state) {
        return $state.scrollBar;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ui/components/MacScrollBarUI$Companion;", "", "<init>", "()V", "CURRENT_STYLE", "com/intellij/ui/components/MacScrollBarUI$Companion$CURRENT_STYLE$1", "Lcom/intellij/ui/components/MacScrollBarUI$Companion$CURRENT_STYLE$1;", "MOVEMENT_LISTENER", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/awt/event/AWTEventListener;", "intellij.platform.ide"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

