/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.valueEditors.IntegerValueEditor;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegerField
extends JBTextField {
    private final IntegerValueEditor myValueEditor;

    public IntegerField() {
        this(null, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerField(@Nullable String valueName, int minValue, int maxValue) {
        this.myValueEditor = new IntegerValueEditor((JTextField)this, valueName, minValue);
        this.myValueEditor.setMinValue(minValue);
        this.myValueEditor.setMaxValue(maxValue);
    }

    public int getMinValue() {
        return this.myValueEditor.getMinValue();
    }

    public int getMaxValue() {
        return this.myValueEditor.getMaxValue();
    }

    public void setMinValue(int minValue) {
        this.myValueEditor.setMinValue(minValue);
    }

    public void setMaxValue(int maxValue) {
        this.myValueEditor.setMaxValue(maxValue);
    }

    public boolean isCanBeEmpty() {
        return this.myValueEditor.isCanBeEmpty();
    }

    public void setCanBeEmpty(boolean canBeEmpty) {
        this.myValueEditor.setCanBeEmpty(canBeEmpty);
    }

    @NotNull
    public Integer getValue() {
        Integer n = (Integer)this.myValueEditor.getValue();
        if (n == null) {
            IntegerField.$$$reportNull$$$0(0);
        }
        return n;
    }

    public void setValue(@NotNull Integer newValue) {
        if (newValue == null) {
            IntegerField.$$$reportNull$$$0(1);
        }
        this.myValueEditor.setValue(newValue);
    }

    public void setValueName(@Nullable String valueName) {
        this.myValueEditor.setValueName(valueName);
    }

    @Nullable
    public String getValueName() {
        return this.myValueEditor.getValueName();
    }

    public void validateContent() throws ConfigurationException {
        this.myValueEditor.validateContent();
    }

    public void setDefaultValueText(@NlsContexts.StatusText @NotNull String text) {
        if (text == null) {
            IntegerField.$$$reportNull$$$0(2);
        }
        this.getEmptyText().setText(text);
    }

    public void setDefaultValue(@NotNull Integer defaultValue) {
        if (defaultValue == null) {
            IntegerField.$$$reportNull$$$0(3);
        }
        this.myValueEditor.setDefaultValue(defaultValue);
    }

    @NotNull
    public Integer getDefaultValue() {
        Integer n = (Integer)this.myValueEditor.getDefaultValue();
        if (n == null) {
            IntegerField.$$$reportNull$$$0(4);
        }
        return n;
    }

    public void resetToDefault() {
        this.myValueEditor.setValue((Integer)this.myValueEditor.getDefaultValue());
    }

    public IntegerValueEditor getValueEditor() {
        return this.myValueEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/fields/IntegerField";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/fields/IntegerField";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultValueText";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

