/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.gridLayout.impl;

import com.intellij.ui.dsl.UiDslException;
import com.intellij.ui.dsl.gridLayout.impl.ColumnsSizeCalculator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u000e\b\u0007\u0018\u00002\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J'\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u000b\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\tJ\u0006\u0010\u0013\u001a\u00020\u0007JL\u0010\u0014\u001a\u00020\t2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0002J/\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u001b\u001a\u00020\u00072\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0015H\u0002\u00a2\u0006\u0002\u0010\u001dJ1\u0010\u001e\u001a\u00020\t2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\u0007H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ui/dsl/gridLayout/impl/ColumnsSizeCalculator;", "", "<init>", "()V", "sizes", "", "Lcom/intellij/ui/dsl/gridLayout/impl/ColumnsSizeCalculator$ColumnInfo;", "", "addConstraint", "", "x", "width", "size", "calculateCoords", "", "resizableColumns", "", "(ILjava/util/Set;)[Ljava/lang/Integer;", "reset", "calculatePreferredSize", "removeFirstColumn", "", "sizesFirstColumn", "sizesWithoutFirstColumn", "firstColumnMinWidth", "getVisibleColumns", "calculateMinCoords", "dimension", "columnsInfo", "(ILjava/util/Map;)[Ljava/lang/Integer;", "resizeCoords", "coordinates", "([Ljava/lang/Integer;Ljava/util/Set;I)V", "getDimension", "ColumnInfo", "intellij.platform.ide"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nColumnsSizeCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnsSizeCalculator.kt\ncom/intellij/ui/dsl/gridLayout/impl/ColumnsSizeCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n774#2:178\n865#2,2:179\n1788#2,4:182\n1#3:181\n*S KotlinDebug\n*F\n+ 1 ColumnsSizeCalculator.kt\ncom/intellij/ui/dsl/gridLayout/impl/ColumnsSizeCalculator\n*L\n83#1:178\n83#1:179,2\n156#1:182,4\n*E\n"})
public final class ColumnsSizeCalculator {
    @NotNull
    private final Map<ColumnInfo, Integer> sizes = new LinkedHashMap();

    public final void addConstraint(int x, int width, int size) {
        ColumnInfo key = new ColumnInfo(x, width);
        Integer n = this.sizes.get(key);
        int existingSize = n != null ? n : 0;
        this.sizes.put(key, Math.max(size, existingSize));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Integer[] calculateCoords(int width, @NotNull Set<Integer> resizableColumns) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(resizableColumns, (String)"resizableColumns");
        if (this.sizes.isEmpty()) {
            Integer[] integerArray = new Integer[]{0};
            return integerArray;
        }
        int dimension = this.getDimension();
        Set<Integer> visibleColumns = this.getVisibleColumns();
        int n = 0;
        int n2 = dimension + 1;
        Integer[] integerArray = new Integer[n2];
        while (n < n2) {
            int n3 = n++;
            integerArray[n3] = 0;
        }
        Integer[] result2 = integerArray;
        Map remainedSizes = MapsKt.toMap(this.sizes);
        Set remainedResizableColumns = CollectionsKt.toMutableSet((Iterable)CollectionsKt.intersect((Iterable)resizableColumns, (Iterable)visibleColumns));
        for (int i = 0; i < dimension; ++i) {
            if (visibleColumns.contains(i)) {
                Object[] minCoords = this.calculateMinCoords(dimension - i, remainedSizes);
                int firstColumnMinWidth = minCoords[1];
                Map sizesFirstColumn = new LinkedHashMap();
                Map sizesWithoutFirstColumn = new LinkedHashMap();
                this.removeFirstColumn(remainedSizes, sizesFirstColumn, sizesWithoutFirstColumn, firstColumnMinWidth);
                Object[] nextMinCoords = this.calculateMinCoords(dimension - i - 1, sizesWithoutFirstColumn);
                int firstColumnMaxWidth = ((Number)ArraysKt.last((Object[])minCoords)).intValue() - ((Number)ArraysKt.last((Object[])nextMinCoords)).intValue();
                int columnWidthCorrection = remainedResizableColumns.remove(i) ? (firstColumnMaxWidth - firstColumnMinWidth) / (remainedResizableColumns.size() + 1) : 0;
                for (Map.Entry entry : sizesFirstColumn.entrySet()) {
                    ColumnInfo columnInfo = (ColumnInfo)entry.getKey();
                    int size = ((Number)entry.getValue()).intValue();
                    Map map = sizesWithoutFirstColumn;
                    Integer n4 = (Integer)sizesWithoutFirstColumn.get(columnInfo);
                    int n5 = n4 != null ? n4 : 0;
                    int n6 = size - columnWidthCorrection;
                    Integer n7 = Math.max(n5, n6);
                    map.put(columnInfo, n7);
                }
                remainedSizes = sizesWithoutFirstColumn;
                result2[i + 1] = result2[i] + firstColumnMinWidth + columnWidthCorrection;
                continue;
            }
            Map sizesFirstColumn = new LinkedHashMap();
            Map sizesWithoutFirstColumn = new LinkedHashMap();
            this.removeFirstColumn(remainedSizes, sizesFirstColumn, sizesWithoutFirstColumn, 0);
            if (!sizesFirstColumn.isEmpty()) {
                throw new UiDslException(null, null, 3, null);
            }
            remainedSizes = sizesWithoutFirstColumn;
            result2[i + 1] = result2[i];
        }
        if (!remainedSizes.isEmpty()) {
            throw new UiDslException(null, null, 3, null);
        }
        if (!((Collection)remainedResizableColumns).isEmpty()) {
            throw new UiDslException(null, null, 3, null);
        }
        Iterable i = resizableColumns;
        Integer[] integerArray2 = result2;
        ColumnsSizeCalculator columnsSizeCalculator = this;
        boolean $i$f$filter = false;
        void sizesWithoutFirstColumn = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!visibleColumns.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        columnsSizeCalculator.resizeCoords(integerArray2, CollectionsKt.toSet((Iterable)list), width);
        return result2;
    }

    public final void reset() {
        this.sizes.clear();
    }

    public final int calculatePreferredSize() {
        if (this.sizes.isEmpty()) {
            return 0;
        }
        Object[] minCoords = this.calculateMinCoords(this.getDimension(), this.sizes);
        return ((Number)ArraysKt.last((Object[])minCoords)).intValue();
    }

    private final void removeFirstColumn(Map<ColumnInfo, Integer> sizes, Map<ColumnInfo, Integer> sizesFirstColumn, Map<ColumnInfo, Integer> sizesWithoutFirstColumn, int firstColumnMinWidth) {
        for (Map.Entry<ColumnInfo, Integer> entry : sizes.entrySet()) {
            Integer n;
            Map<ColumnInfo, Integer> map;
            ColumnInfo index;
            ColumnInfo columnInfo = entry.getKey();
            int size = ((Number)entry.getValue()).intValue();
            if (columnInfo.getX() == 0) {
                if (columnInfo.getWidth() <= 1) continue;
                index = new ColumnInfo(0, columnInfo.getWidth() - 1);
                map = sizesFirstColumn;
                Integer n2 = sizesFirstColumn.get(index);
                int n3 = n2 != null ? n2 : 0;
                int n4 = size - firstColumnMinWidth;
                n = Math.max(n3, n4);
                map.put(index, n);
                continue;
            }
            index = new ColumnInfo(columnInfo.getX() - 1, columnInfo.getWidth());
            map = sizesWithoutFirstColumn;
            Integer n5 = sizesWithoutFirstColumn.get(index);
            n = Math.max(n5 != null ? n5 : 0, size);
            map.put(index, n);
        }
    }

    private final Set<Integer> getVisibleColumns() {
        Set result2 = new LinkedHashSet();
        for (ColumnInfo columnInfo : this.sizes.keySet()) {
            CollectionsKt.addAll((Collection)result2, (Iterable)((Iterable)RangesKt.until((int)columnInfo.getX(), (int)(columnInfo.getX() + columnInfo.getWidth()))));
        }
        return result2;
    }

    private final Integer[] calculateMinCoords(int dimension, Map<ColumnInfo, Integer> columnsInfo) {
        int n = 0;
        int n2 = dimension + 1;
        Object[] object2 = new Integer[n2];
        while (n < n2) {
            int n3 = n++;
            object2[n3] = 0;
        }
        Object[] result2 = object2;
        Comparator<Object> comparator = Comparator.comparingInt(arg_0 -> ColumnsSizeCalculator.calculateMinCoords$lambda$0((Function1)calculateMinCoords.sortedSizes.1.INSTANCE, arg_0)).thenComparingInt(arg_0 -> ColumnsSizeCalculator.calculateMinCoords$lambda$1((Function1)calculateMinCoords.sortedSizes.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"thenComparingInt(...)");
        SortedMap sortedSizes2 = MapsKt.toSortedMap(columnsInfo, comparator);
        for (Map.Entry entry : ((Map)sortedSizes2).entrySet()) {
            ColumnInfo columnInfo = (ColumnInfo)entry.getKey();
            Integer size = (Integer)entry.getValue();
            if (result2[columnInfo.getX()] == 0) {
                Object v1;
                block5: {
                    Iterable iterable = (Iterable)RangesKt.downTo((int)(columnInfo.getX() - 1), (int)0);
                    for (Object t : iterable) {
                        int it = ((Number)t).intValue();
                        boolean bl = false;
                        if (!(result2[it] > 0)) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                Integer prevVisible = v1;
                if (prevVisible != null) {
                    ArraysKt.fill((Object[])result2, (Object)result2[prevVisible], (int)(prevVisible + 1), (int)(columnInfo.getX() + 1));
                }
            }
            int nextColumn = columnInfo.getX() + columnInfo.getWidth();
            int n4 = result2[columnInfo.getX()];
            Intrinsics.checkNotNull((Object)size);
            result2[nextColumn] = Math.max(n4 + size, result2[nextColumn]);
        }
        return result2;
    }

    private final void resizeCoords(Integer[] coordinates, Set<Integer> resizableColumns, int width) {
        int count$iv;
        int n;
        int extraSize = width - ((Number)ArraysKt.last((Object[])coordinates)).intValue();
        if (extraSize == 0 || resizableColumns.isEmpty()) {
            return;
        }
        int previousShift = 0;
        Iterable $this$count$iv = resizableColumns;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (!(it < coordinates.length - 1) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int remainedResizableColumns = n;
        int n2 = coordinates.length;
        for (int i = 0; i < n2; ++i) {
            count$iv = i;
            coordinates[count$iv] = coordinates[count$iv] + previousShift;
            if (i >= coordinates.length - 1 || !resizableColumns.contains(i)) continue;
            int correction = extraSize / remainedResizableColumns;
            previousShift += correction;
            extraSize -= correction;
            --remainedResizableColumns;
        }
    }

    private final int getDimension() {
        Iterator iterator = ((Iterable)this.sizes.keySet()).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        ColumnInfo it = (ColumnInfo)iterator.next();
        boolean bl = false;
        int n = it.getX() + it.getWidth();
        while (iterator.hasNext()) {
            ColumnInfo it2 = (ColumnInfo)iterator.next();
            $i$a$-maxOf-ColumnsSizeCalculator$getDimension$1 = false;
            int n2 = it2.getX() + it2.getWidth();
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    private static final int calculateMinCoords$lambda$0(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int calculateMinCoords$lambda$1(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ui/dsl/gridLayout/impl/ColumnsSizeCalculator$ColumnInfo;", "", "x", "", "width", "<init>", "(II)V", "getX", "()I", "getWidth", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.ide"})
    private static final class ColumnInfo {
        private final int x;
        private final int width;

        public ColumnInfo(int x, int width) {
            this.x = x;
            this.width = width;
        }

        public final int getX() {
            return this.x;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.width;
        }

        @NotNull
        public final ColumnInfo copy(int x, int width) {
            return new ColumnInfo(x, width);
        }

        public static /* synthetic */ ColumnInfo copy$default(ColumnInfo columnInfo, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = columnInfo.x;
            }
            if ((n3 & 2) != 0) {
                n2 = columnInfo.width;
            }
            return columnInfo.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "ColumnInfo(x=" + this.x + ", width=" + this.width + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.x);
            result2 = result2 * 31 + Integer.hashCode(this.width);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColumnInfo)) {
                return false;
            }
            ColumnInfo columnInfo = (ColumnInfo)other;
            if (this.x != columnInfo.x) {
                return false;
            }
            return this.width == columnInfo.width;
        }
    }
}

