/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.table;

import com.intellij.ui.table.AdditionalTableHeader;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cJ\u0006\u0010\u001e\u001a\u00020\u0017J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0019H\u0002J\u0012\u0010#\u001a\u00020\u00172\b\u0010$\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u0017H\u0002J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u0011H\u0002J\u000e\u0010+\u001a\u0004\u0018\u00010\u0011*\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0013\u001a\u0004\u0018\u00010\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u000b\"\u0004\b\u0015\u0010\r\u00a8\u0006,"}, d2={"Lcom/intellij/ui/table/AdditionalTableHeaderPositionHelper;", "Ljava/beans/PropertyChangeListener;", "statisticsHeader", "Lcom/intellij/ui/table/AdditionalTableHeader;", "<init>", "(Lcom/intellij/ui/table/AdditionalTableHeader;)V", "getStatisticsHeader", "()Lcom/intellij/ui/table/AdditionalTableHeader;", "myLocation", "Lcom/intellij/ui/table/AdditionalTableHeader$Position;", "getMyLocation", "()Lcom/intellij/ui/table/AdditionalTableHeader$Position;", "setMyLocation", "(Lcom/intellij/ui/table/AdditionalTableHeader$Position;)V", "headerViewport", "Ljavax/swing/JViewport;", "previousTableViewport", "Ljava/awt/Component;", "location", "position", "getPosition", "setPosition", "headerVisibilityChanged", "", "visible", "", "changeTable", "oldTable", "Ljavax/swing/JTable;", "newTable", "currentHeaderContainmentUpdate", "propertyChange", "evt", "Ljava/beans/PropertyChangeEvent;", "canHeaderLocationBeManaged", "trySetUp", "table", "setUp", "scrollPane", "Ljavax/swing/JScrollPane;", "cleanUp", "createCleanViewport", "tableHeader", "findTableHeader", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nAdditionalTableHeaderPositionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdditionalTableHeaderPositionHelper.kt\ncom/intellij/ui/table/AdditionalTableHeaderPositionHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1#2:198\n*E\n"})
public final class AdditionalTableHeaderPositionHelper
implements PropertyChangeListener {
    @NotNull
    private final AdditionalTableHeader statisticsHeader;
    @Nullable
    private AdditionalTableHeader.Position myLocation;
    @Nullable
    private JViewport headerViewport;
    @Nullable
    private Component previousTableViewport;

    public AdditionalTableHeaderPositionHelper(@NotNull AdditionalTableHeader statisticsHeader) {
        Intrinsics.checkNotNullParameter((Object)statisticsHeader, (String)"statisticsHeader");
        this.statisticsHeader = statisticsHeader;
    }

    @NotNull
    public final AdditionalTableHeader getStatisticsHeader() {
        return this.statisticsHeader;
    }

    @Nullable
    public final AdditionalTableHeader.Position getMyLocation() {
        return this.myLocation;
    }

    public final void setMyLocation(@Nullable AdditionalTableHeader.Position position) {
        this.myLocation = position;
    }

    @Nullable
    public final AdditionalTableHeader.Position getPosition() {
        return this.myLocation;
    }

    public final void setPosition(@Nullable AdditionalTableHeader.Position location) {
        this.myLocation = location;
        JTable table = this.statisticsHeader.getTable();
        this.changeTable(table, table);
    }

    public final void headerVisibilityChanged(boolean visible) {
        JTable table = this.statisticsHeader.getTable();
        this.changeTable(table, null);
        if (visible && table != null) {
            this.changeTable(null, table);
        }
    }

    public final void changeTable(@Nullable JTable oldTable, @Nullable JTable newTable) {
        JTable jTable = oldTable;
        if (jTable != null) {
            jTable.removePropertyChangeListener("ancestor", this);
        }
        this.cleanUp();
        if (newTable != null) {
            newTable.addPropertyChangeListener("ancestor", this);
            this.trySetUp(newTable);
        }
    }

    public final void currentHeaderContainmentUpdate() {
        if (!this.canHeaderLocationBeManaged()) {
            this.cleanUp();
        }
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (this.previousTableViewport != evt.getNewValue() && evt.getSource() != this.statisticsHeader.getTable()) {
            this.previousTableViewport = null;
            this.cleanUp();
            this.trySetUp(this.statisticsHeader.getTable());
        }
    }

    private final boolean canHeaderLocationBeManaged() {
        if (this.myLocation == AdditionalTableHeader.Position.NONE) {
            return false;
        }
        Container parent = this.statisticsHeader.getParent();
        return parent == null || parent == this.headerViewport;
    }

    private final void trySetUp(JTable table) {
        Container gp;
        Container p;
        if (table != null && table.isVisible() && this.canHeaderLocationBeManaged() && this.statisticsHeader.isVisible() && (p = table.getParent()) instanceof JViewport && (gp = ((JViewport)p).getParent()) instanceof JScrollPane) {
            JViewport jViewport = ((JScrollPane)gp).getViewport();
            Intrinsics.checkNotNullExpressionValue((Object)jViewport, (String)"getViewport(...)");
            JViewport viewport = jViewport;
            if (viewport.getView() == table) {
                this.setUp((JScrollPane)gp);
                this.previousTableViewport = p;
            }
        }
    }

    private final void setUp(JScrollPane scrollPane2) {
        Component view;
        this.headerViewport = new JViewport(this){
            private final long serialVersionUID;
            final /* synthetic */ AdditionalTableHeaderPositionHelper this$0;
            {
                this.this$0 = $receiver;
                this.serialVersionUID = 7109623726722227105L;
                this.setOpaque(false);
            }

            public void setView(Component view) {
                if (view instanceof JTableHeader) {
                    this.removeTableHeader();
                    ((JTableHeader)view).setVisible(this.this$0.getMyLocation() != AdditionalTableHeader.Position.REPLACE);
                    ((JTableHeader)view).setOpaque(false);
                    this.this$0.getStatisticsHeader().add(view, this.this$0.getMyLocation() == AdditionalTableHeader.Position.INLINE ? "North" : "South");
                    this.this$0.getStatisticsHeader().revalidate();
                    super.setView(this.this$0.getStatisticsHeader());
                } else if (view instanceof AdditionalTableHeader) {
                    this.setView(AdditionalTableHeaderPositionHelper.access$findTableHeader(this.this$0, (AdditionalTableHeader)view));
                }
            }

            private final Component removeTableHeader() {
                Component tableHeader = AdditionalTableHeaderPositionHelper.access$findTableHeader(this.this$0, this.this$0.getStatisticsHeader());
                if (tableHeader != null) {
                    this.this$0.getStatisticsHeader().remove(tableHeader);
                }
                return tableHeader;
            }
        };
        JViewport currentColumnHeader = scrollPane2.getColumnHeader();
        if (currentColumnHeader != null && (view = currentColumnHeader.getView()) != null) {
            JViewport jViewport = this.headerViewport;
            Intrinsics.checkNotNull((Object)jViewport);
            jViewport.setView(view);
        }
        scrollPane2.setColumnHeader(this.headerViewport);
    }

    private final void cleanUp() {
        JViewport currentViewport = this.headerViewport;
        this.headerViewport = null;
        if (currentViewport != null) {
            currentViewport.remove(this.statisticsHeader);
            Container parent = currentViewport.getParent();
            if (parent instanceof JScrollPane && ((JScrollPane)parent).getColumnHeader() == currentViewport) {
                JViewport jViewport;
                Component tableHeader;
                Component component = tableHeader = this.findTableHeader(this.statisticsHeader);
                if (component != null) {
                    Component it = component;
                    boolean bl = false;
                    jViewport = this.createCleanViewport(it);
                } else {
                    jViewport = null;
                }
                JViewport newView = jViewport;
                ((JScrollPane)parent).setColumnHeader(newView);
            }
        }
    }

    private final JViewport createCleanViewport(Component tableHeader) {
        JViewport ret = new JViewport();
        ret.setView(tableHeader);
        return ret;
    }

    private final Component findTableHeader(AdditionalTableHeader $this$findTableHeader) {
        Component[] componentArray = $this$findTableHeader.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component component : componentArray) {
            if (!(component instanceof JTableHeader)) continue;
            return component;
        }
        return null;
    }

    public static final /* synthetic */ Component access$findTableHeader(AdditionalTableHeaderPositionHelper $this, AdditionalTableHeader $receiver) {
        return $this.findTableHeader($receiver);
    }
}

