/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.openapi.rd.GraphicsExKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.JBTabsBorder;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.animation.Animation;
import com.intellij.util.animation.Animations;
import com.intellij.util.animation.Easing;
import com.intellij.util.animation.JBAnimator;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ui/tabs/impl/JBEditorTabsBorder;", "Lcom/intellij/ui/tabs/JBTabsBorder;", "tabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "<init>", "(Lcom/intellij/ui/tabs/impl/JBTabsImpl;)V", "animator", "Lcom/intellij/util/animation/JBAnimator;", "start", "", "end", "animationId", "", "effectiveBorder", "Ljava/awt/Insets;", "getEffectiveBorder", "()Ljava/awt/Insets;", "paintBorder", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "width", "height", "calcRectangle", "Ljava/awt/Rectangle;", "Companion", "intellij.platform.ide"})
@ApiStatus.Internal
public final class JBEditorTabsBorder
extends JBTabsBorder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JBAnimator animator;
    private int start;
    private int end;
    private long animationId;

    public JBEditorTabsBorder(final @NotNull JBTabsImpl tabs) {
        Intrinsics.checkNotNullParameter((Object)tabs, (String)"tabs");
        super(tabs);
        this.animator = new JBAnimator();
        this.start = -1;
        this.end = -1;
        this.animationId = -1L;
        tabs.addListener(new TabsListener(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                void $this$selectionChanged_u24lambda_u243;
                Animation $this$selectionChanged_u24lambda_u241;
                Animation animation;
                Rectangle rectangle = this.bounds(oldSelection);
                if (rectangle == null) {
                    return;
                }
                Rectangle from = rectangle;
                Rectangle rectangle2 = this.bounds(newSelection);
                if (rectangle2 == null) {
                    return;
                }
                Rectangle to = rectangle2;
                if (from.width == 0 || to.width == 0) {
                    return;
                }
                int dur = 100;
                int del = 50;
                int s1 = from.x;
                int s2 = to.x;
                int d1 = s1 > s2 ? 0 : del;
                int e1 = from.x + from.width;
                int e2 = to.x + to.width;
                int d2 = e1 > e2 ? del : 0;
                Animation[] animationArray = new Animation[2];
                Animation animation2 = animation = Animations.animation(s1, s2, arg_0 -> 1.selectionChanged$lambda$0(this, tabs, arg_0));
                int n = 0;
                Animation[] animationArray2 = animationArray;
                JBAnimator jBAnimator = animator;
                JBEditorTabsBorder jBEditorTabsBorder = this;
                boolean bl = false;
                $this$selectionChanged_u24lambda_u241.setDuration(dur - d1);
                $this$selectionChanged_u24lambda_u241.setDelay(d1);
                $this$selectionChanged_u24lambda_u241.setEasing(d1 != 0 ? Easing.EASE_OUT : Easing.LINEAR);
                Unit unit = Unit.INSTANCE;
                animationArray2[n] = animation;
                $this$selectionChanged_u24lambda_u241 = animation = Animations.animation(e1, e2, arg_0 -> 1.selectionChanged$lambda$2(this, tabs, arg_0));
                n = 1;
                animationArray2 = animationArray;
                boolean bl2 = false;
                $this$selectionChanged_u24lambda_u243.setDuration(dur - d2);
                $this$selectionChanged_u24lambda_u243.setDelay(d2);
                $this$selectionChanged_u24lambda_u243.setEasing(d2 != 0 ? Easing.EASE_OUT : Easing.LINEAR);
                unit = Unit.INSTANCE;
                animationArray2[n] = animation;
                jBEditorTabsBorder.animationId = jBAnimator.animate(animationArray);
            }

            private final Rectangle bounds(TabInfo tabInfo) {
                TabInfo tabInfo2 = tabInfo;
                if (tabInfo2 == null) {
                    return null;
                }
                TabLabel tabLabel = tabs.getTabLabel(tabInfo2);
                return tabLabel != null ? tabLabel.getBounds() : null;
            }

            private static final void selectionChanged$lambda$0(JBEditorTabsBorder this$0, JBTabsImpl $tabs, int it) {
                this$0.start = it;
                $tabs.getComponent().repaint();
            }

            private static final void selectionChanged$lambda$2(JBEditorTabsBorder this$0, JBTabsImpl $tabs, int it) {
                this$0.end = it;
                $tabs.getComponent().repaint();
            }
        });
    }

    @Override
    @NotNull
    public Insets getEffectiveBorder() {
        return new Insets(this.getThickness(), 0, 0, 0);
    }

    @Override
    public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        if (ExperimentalUI.Companion.isNewUI()) {
            Graphics2D graphics2D = (Graphics2D)g;
            Point point = new Point(x, y);
            Point point2 = new Point(x + width, y);
            double d = this.getThickness();
            Color color = JBUI.CurrentTheme.MainToolbar.borderColor();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"borderColor(...)");
            GraphicsExKt.paint2DLine(graphics2D, point, point2, LinePainter2D.StrokeType.INSIDE, d, color);
        } else {
            this.tabs.getTabPainter().paintBorderLine((Graphics2D)g, this.getThickness(), new Point(x, y), new Point(x + width, y));
        }
        if (this.tabs.isEmptyVisible() || this.tabs.isHideTabs()) {
            return;
        }
        TabLabel tabLabel = this.tabs.getTabLabel((TabInfo)CollectionsKt.first(this.tabs.getVisibleInfos()));
        if (tabLabel == null) {
            return;
        }
        TabLabel firstLabel = tabLabel;
        switch (WhenMappings.$EnumSwitchMapping$0[this.tabs.getTabsPosition().ordinal()]) {
            case 1: {
                int startY = firstLabel.getY() - (this.tabs.getTabsPosition() == JBTabsPosition.bottom ? 0 : this.getThickness());
                int startRow = ExperimentalUI.Companion.isNewUI() ? 1 : 0;
                LayoutPassInfo layoutPassInfo = this.tabs.getLastLayoutPass();
                Intrinsics.checkNotNull((Object)layoutPassInfo);
                int lastRow = layoutPassInfo.getRowCount();
                for (int eachRow = startRow; eachRow < lastRow; ++eachRow) {
                    Dimension dimension = this.tabs.getHeaderFitSize();
                    Intrinsics.checkNotNull((Object)dimension);
                    int yl = eachRow * dimension.height + startY;
                    this.tabs.getTabPainter().paintBorderLine((Graphics2D)g, this.getThickness(), new Point(x, yl), new Point(x + width, yl));
                }
                if (ExperimentalUI.Companion.isNewUI()) {
                    JBTabsImpl jBTabsImpl = this.tabs;
                    JBEditorTabs jBEditorTabs = jBTabsImpl instanceof JBEditorTabs ? (JBEditorTabs)jBTabsImpl : null;
                    boolean bl = jBEditorTabs != null ? jBEditorTabs.shouldPaintBottomBorder() : false;
                    if (!bl) break;
                }
                Dimension dimension = this.tabs.getHeaderFitSize();
                Intrinsics.checkNotNull((Object)dimension);
                int yl = lastRow * dimension.height + startY;
                this.tabs.getTabPainter().paintBorderLine((Graphics2D)g, this.getThickness(), new Point(x, yl), new Point(x + width, yl));
                break;
            }
            case 2: {
                LayoutPassInfo layoutPassInfo = this.tabs.getLastLayoutPass();
                Intrinsics.checkNotNull((Object)layoutPassInfo);
                int rowCount = layoutPassInfo.getRowCount();
                for (int rowInd = 0; rowInd < rowCount; ++rowInd) {
                    Dimension dimension = this.tabs.getHeaderFitSize();
                    Intrinsics.checkNotNull((Object)dimension);
                    int curY = height - (rowInd + 1) * dimension.height;
                    this.tabs.getTabPainter().paintBorderLine((Graphics2D)g, this.getThickness(), new Point(x, curY), new Point(x + width, curY));
                }
                break;
            }
            case 3: {
                int lx = firstLabel.getX();
                this.tabs.getTabPainter().paintBorderLine((Graphics2D)g, this.getThickness(), new Point(lx, y), new Point(lx, y + height));
                break;
            }
            case 4: {
                Rectangle bounds = firstLabel.getBounds();
                int i = bounds.x + bounds.width - this.getThickness();
                this.tabs.getTabPainter().paintBorderLine((Graphics2D)g, this.getThickness(), new Point(i, y), new Point(i, y + height));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (Companion.hasAnimation$intellij_platform_ide()) {
            Rectangle rectangle = this.calcRectangle();
            if (rectangle == null) {
                return;
            }
            this.tabs.getTabPainter().paintUnderline(this.tabs.getTabsPosition(), rectangle, this.getThickness(), (Graphics2D)g, this.tabs.isActiveTabs(this.tabs.getSelectedInfo()));
        } else {
            TabLabel tabLabel2 = this.tabs.getSelectedLabel();
            if (tabLabel2 == null) {
                return;
            }
            TabLabel selectedLabel = tabLabel2;
            JBTabPainter jBTabPainter = this.tabs.getTabPainter();
            JBTabsPosition jBTabsPosition = this.tabs.getTabsPosition();
            Rectangle rectangle = selectedLabel.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
            jBTabPainter.paintUnderline(jBTabsPosition, rectangle, this.getThickness(), (Graphics2D)g, this.tabs.isActiveTabs(this.tabs.getSelectedInfo()));
        }
    }

    private final Rectangle calcRectangle() {
        TabLabel tabLabel = this.tabs.getSelectedLabel();
        if (tabLabel == null) {
            return null;
        }
        TabLabel selectedLabel = tabLabel;
        if (this.animator.isRunning(this.animationId)) {
            return new Rectangle(this.start, selectedLabel.getY(), this.end - this.start, selectedLabel.getHeight());
        }
        return selectedLabel.getBounds();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ui/tabs/impl/JBEditorTabsBorder$Companion;", "", "<init>", "()V", "hasAnimation", "", "hasAnimation$intellij_platform_ide", "intellij.platform.ide"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean hasAnimation$intellij_platform_ide() {
            return Registry.Companion.is("ide.editor.tab.selection.animation", false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JBTabsPosition.values().length];
            try {
                nArray[JBTabsPosition.top.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JBTabsPosition.bottom.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JBTabsPosition.right.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JBTabsPosition.left.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

