/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.ssl.CertificateWrapper;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CertificateUtil {
    public static final String X509 = "X.509";
    public static final String JKS = "JKS";
    public static final String PKCS12 = "PKCS12";
    public static final String PKIX = "PKIX";
    public static final String TLS = "TLS";
    private static final CertificateFactory ourFactory = CertificateUtil.createFactory();

    private static CertificateFactory createFactory() {
        try {
            return CertificateFactory.getInstance(X509);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Can't initialize X.509 certificate factory", e);
        }
    }

    private CertificateUtil() {
    }

    @Nullable
    public static X509Certificate loadX509Certificate(@NotNull String path) {
        X509Certificate x509Certificate;
        if (path == null) {
            CertificateUtil.$$$reportNull$$$0(0);
        }
        FileInputStream stream = new FileInputStream(path);
        try {
            x509Certificate = (X509Certificate)ourFactory.generateCertificate(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Logger.getInstance(CertificateUtil.class).error("Can't add certificate for path: " + path, (Throwable)e);
                return null;
            }
        }
        ((InputStream)stream).close();
        return x509Certificate;
    }

    public static String getCommonName(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            CertificateUtil.$$$reportNull$$$0(1);
        }
        return new CertificateWrapper(certificate).getSubjectField(CertificateWrapper.CommonField.COMMON_NAME);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/net/ssl/CertificateUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadX509Certificate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommonName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

