/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.ui.GenericListComponentUpdater;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopupChooserBuilder<T>
implements IPopupChooserBuilder<T> {
    private final PopupComponentAdapter<T> myChooserComponent;
    private @NlsContexts.PopupTitle String myTitle;
    private final ArrayList<KeyStroke> myAdditionalKeystrokes;
    private Runnable myItemChosenRunnable;
    private JBSplitter myContentSplitter;
    private JComponent myNorthComponent;
    private JComponent mySouthComponent;
    private JComponent myEastComponent;
    private JComponent myPreferableFocusComponent;
    private JBPopup myPopup;
    private boolean myRequestFocus;
    private boolean myForceResizable;
    private boolean myForceMovable;
    private String myDimensionServiceKey;
    private Computable<Boolean> myCancelCallback;
    private boolean myAutoselect;
    private float myAlpha;
    private Component[] myFocusOwners;
    private boolean myCancelKeyEnabled;
    private final List<JBPopupListener> myListeners;
    private @NlsContexts.PopupAdvertisement String myAd;
    private JComponent myAdvertiser;
    private Dimension myMinSize;
    private ActiveComponent myCommandButton;
    private final List<Pair<ActionListener, KeyStroke>> myKeyboardActions;
    private Component mySettingsButtons;
    private boolean myAutoselectOnMouseMove;
    private Function<? super T, String> myItemsNamer;
    private boolean myFilterAlwaysVisible;
    private boolean myMayBeParent;
    private int myAdAlignment;
    private boolean myModalContext;
    private boolean myCloseOnEnter;
    private boolean myCancelOnWindowDeactivation;
    private boolean myCancelOnOtherWindowOpen;
    private boolean myUseForXYLocation;
    @Nullable
    private Processor<? super JBPopup> myCouldPin;
    private int myVisibleRowCount;
    private boolean myAutoPackHeightOnFiltering;
    private boolean myCancelOnClickOutside;
    private JScrollPane myScrollPane;

    @Override
    public PopupChooserBuilder<T> setCancelOnClickOutside(boolean cancelOnClickOutside) {
        this.myCancelOnClickOutside = cancelOnClickOutside;
        return this;
    }

    public JScrollPane getScrollPane() {
        return this.myScrollPane;
    }

    public PopupChooserBuilder(@NotNull JList<T> list) {
        if (list == null) {
            PopupChooserBuilder.$$$reportNull$$$0(0);
        }
        this.myAdditionalKeystrokes = new ArrayList();
        this.myRequestFocus = true;
        this.myAutoselect = true;
        this.myFocusOwners = new Component[0];
        this.myCancelKeyEnabled = true;
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myKeyboardActions = new ArrayList<Pair<ActionListener, KeyStroke>>();
        this.myAutoselectOnMouseMove = true;
        this.myAdAlignment = 2;
        this.myCloseOnEnter = true;
        this.myCancelOnWindowDeactivation = true;
        this.myCancelOnOtherWindowOpen = true;
        this.myVisibleRowCount = 15;
        this.myAutoPackHeightOnFiltering = true;
        this.myCancelOnClickOutside = true;
        this.myChooserComponent = JBPopupFactory.getInstance().createPopupComponentAdapter(this, list);
    }

    public PopupChooserBuilder(@NotNull JTable table) {
        if (table == null) {
            PopupChooserBuilder.$$$reportNull$$$0(1);
        }
        this.myAdditionalKeystrokes = new ArrayList();
        this.myRequestFocus = true;
        this.myAutoselect = true;
        this.myFocusOwners = new Component[0];
        this.myCancelKeyEnabled = true;
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myKeyboardActions = new ArrayList<Pair<ActionListener, KeyStroke>>();
        this.myAutoselectOnMouseMove = true;
        this.myAdAlignment = 2;
        this.myCloseOnEnter = true;
        this.myCancelOnWindowDeactivation = true;
        this.myCancelOnOtherWindowOpen = true;
        this.myVisibleRowCount = 15;
        this.myAutoPackHeightOnFiltering = true;
        this.myCancelOnClickOutside = true;
        this.myChooserComponent = JBPopupFactory.getInstance().createPopupComponentAdapter(this, table);
    }

    public PopupChooserBuilder(@NotNull JTree tree) {
        if (tree == null) {
            PopupChooserBuilder.$$$reportNull$$$0(2);
        }
        this.myAdditionalKeystrokes = new ArrayList();
        this.myRequestFocus = true;
        this.myAutoselect = true;
        this.myFocusOwners = new Component[0];
        this.myCancelKeyEnabled = true;
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myKeyboardActions = new ArrayList<Pair<ActionListener, KeyStroke>>();
        this.myAutoselectOnMouseMove = true;
        this.myAdAlignment = 2;
        this.myCloseOnEnter = true;
        this.myCancelOnWindowDeactivation = true;
        this.myCancelOnOtherWindowOpen = true;
        this.myVisibleRowCount = 15;
        this.myAutoPackHeightOnFiltering = true;
        this.myCancelOnClickOutside = true;
        this.myChooserComponent = JBPopupFactory.getInstance().createPopupComponentAdapter(this, tree);
    }

    @Override
    public PopupChooserBuilder<T> setTitle(@NlsContexts.PopupTitle @NotNull String title) {
        if (title == null) {
            PopupChooserBuilder.$$$reportNull$$$0(3);
        }
        this.myTitle = title;
        return this;
    }

    public PopupChooserBuilder<T> addAdditionalChooseKeystroke(@Nullable KeyStroke keyStroke) {
        if (keyStroke != null) {
            this.myAdditionalKeystrokes.add(keyStroke);
        }
        return this;
    }

    @Override
    public IPopupChooserBuilder<T> setRenderer(ListCellRenderer<? super T> renderer) {
        this.myChooserComponent.setRenderer(renderer);
        return this;
    }

    public JComponent getChooserComponent() {
        return this.myChooserComponent.getComponent();
    }

    @Override
    public IPopupChooserBuilder<T> setItemChosenCallback(@NotNull Consumer<? super T> callback) {
        if (callback == null) {
            PopupChooserBuilder.$$$reportNull$$$0(4);
        }
        this.myChooserComponent.setItemChosenCallback(callback);
        return this;
    }

    @Override
    public IPopupChooserBuilder<T> setItemsChosenCallback(@NotNull Consumer<? super Set<? extends T>> callback) {
        if (callback == null) {
            PopupChooserBuilder.$$$reportNull$$$0(5);
        }
        this.myChooserComponent.setItemsChosenCallback(callback);
        return this;
    }

    @Deprecated
    public PopupChooserBuilder<T> setItemChoosenCallback(@NotNull Runnable runnable) {
        if (runnable == null) {
            PopupChooserBuilder.$$$reportNull$$$0(6);
        }
        return this.setItemChosenCallback(runnable);
    }

    public PopupChooserBuilder<T> setItemChosenCallback(@NotNull Runnable runnable) {
        if (runnable == null) {
            PopupChooserBuilder.$$$reportNull$$$0(7);
        }
        this.myItemChosenRunnable = () -> {
            try (AccessToken ignore = SlowOperations.startSection((String)"action.perform");){
                runnable.run();
            }
        };
        return this;
    }

    public PopupChooserBuilder<T> setNorthComponent(@NotNull JComponent cmp) {
        if (cmp == null) {
            PopupChooserBuilder.$$$reportNull$$$0(8);
        }
        this.myNorthComponent = cmp;
        return this;
    }

    public PopupChooserBuilder<T> setSouthComponent(@NotNull JComponent cmp) {
        if (cmp == null) {
            PopupChooserBuilder.$$$reportNull$$$0(9);
        }
        this.mySouthComponent = cmp;
        return this;
    }

    public PopupChooserBuilder<T> setContentSplitter(@NotNull JBSplitter splitter) {
        if (splitter == null) {
            PopupChooserBuilder.$$$reportNull$$$0(10);
        }
        this.myContentSplitter = splitter;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setCouldPin(@Nullable Processor<? super JBPopup> callback) {
        this.myCouldPin = callback;
        return this;
    }

    public PopupChooserBuilder<T> setEastComponent(@NotNull JComponent cmp) {
        if (cmp == null) {
            PopupChooserBuilder.$$$reportNull$$$0(11);
        }
        this.myEastComponent = cmp;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setResizable(boolean forceResizable) {
        this.myForceResizable = forceResizable;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setMovable(boolean forceMovable) {
        this.myForceMovable = forceMovable;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setDimensionServiceKey(@NonNls String key) {
        this.myDimensionServiceKey = key;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setUseDimensionServiceForXYLocation(boolean use) {
        this.myUseForXYLocation = use;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setCancelCallback(Computable<Boolean> callback) {
        this.addCancelCallback(callback);
        return this;
    }

    public PopupChooserBuilder<T> setCommandButton(@NotNull ActiveComponent commandButton) {
        if (commandButton == null) {
            PopupChooserBuilder.$$$reportNull$$$0(12);
        }
        this.myCommandButton = commandButton;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setAlpha(float alpha) {
        this.myAlpha = alpha;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setAutoselectOnMouseMove(boolean doAutoSelect) {
        this.myAutoselectOnMouseMove = doAutoSelect;
        return this;
    }

    public boolean isAutoselectOnMouseMove() {
        return this.myAutoselectOnMouseMove;
    }

    public PopupChooserBuilder<T> setFilteringEnabled(Function<Object, String> namer) {
        this.myItemsNamer = namer;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setFilterAlwaysVisible(boolean state) {
        this.myFilterAlwaysVisible = state;
        return this;
    }

    public boolean isFilterAlwaysVisible() {
        return this.myFilterAlwaysVisible;
    }

    @Override
    public PopupChooserBuilder<T> setNamerForFiltering(Function<? super T, String> namer) {
        this.myItemsNamer = namer;
        return this;
    }

    public Function<? super T, String> getItemsNamer() {
        return this.myItemsNamer;
    }

    @Override
    public IPopupChooserBuilder<T> setAutoPackHeightOnFiltering(boolean autoPackHeightOnFiltering) {
        this.myAutoPackHeightOnFiltering = autoPackHeightOnFiltering;
        return this;
    }

    public boolean isAutoPackHeightOnFiltering() {
        return this.myAutoPackHeightOnFiltering;
    }

    @Override
    public PopupChooserBuilder<T> setModalContext(boolean modalContext) {
        this.myModalContext = modalContext;
        return this;
    }

    public JComponent getPreferableFocusComponent() {
        return this.myPreferableFocusComponent;
    }

    @Override
    @NotNull
    public JBPopup createPopup() {
        Predicate<KeyEvent> keyEventHandler;
        JComponent contentComponent;
        JPanel contentPane = new JPanel(new BorderLayout());
        if (this.myAutoselect) {
            this.myChooserComponent.autoSelect();
        }
        if (this.myCloseOnEnter || this.myItemChosenRunnable != null) {
            this.myChooserComponent.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (UIUtil.isActionClick((MouseEvent)e, (int)502) && !UIUtil.isSelectionButtonDown((MouseEvent)e) && !e.isConsumed()) {
                        if (PopupChooserBuilder.this.myCloseOnEnter) {
                            PopupChooserBuilder.this.closePopup(e, true);
                        } else {
                            PopupChooserBuilder.this.myItemChosenRunnable.run();
                        }
                    }
                }
            });
        }
        this.registerClosePopupKeyboardAction(KeyStroke.getKeyStroke(27, 0), false);
        if (this.myCloseOnEnter) {
            this.registerClosePopupKeyboardAction(KeyStroke.getKeyStroke(10, 0), true);
        } else if (this.myItemChosenRunnable != null) {
            this.registerKeyboardAction(KeyStroke.getKeyStroke(10, 0), __ -> this.myItemChosenRunnable.run());
        }
        for (KeyStroke keystroke : this.myAdditionalKeystrokes) {
            this.registerClosePopupKeyboardAction(keystroke, true);
        }
        this.myPreferableFocusComponent = this.myChooserComponent.buildFinalComponent();
        this.myScrollPane = this.myChooserComponent.createScrollPane();
        this.myScrollPane.getViewport().setCursor(Cursor.getPredefinedCursor(12));
        Insets viewportPadding = UIUtil.getListViewportPadding((boolean)StringUtil.isNotEmpty((String)this.myAd));
        ((JComponent)this.myScrollPane.getViewport().getView()).setBorder(BorderFactory.createEmptyBorder(viewportPadding.top, viewportPadding.left, viewportPadding.bottom, viewportPadding.right));
        JComponent jComponent = contentComponent = this.myChooserComponent.hasOwnScrollPane() ? this.myPreferableFocusComponent : this.myScrollPane;
        if (this.myContentSplitter != null) {
            this.myContentSplitter.setFirstComponent(contentComponent);
            this.addCenterComponentToContentPane(contentPane, (JComponent)((Object)this.myContentSplitter));
        } else {
            this.addCenterComponentToContentPane(contentPane, contentComponent);
        }
        if (this.myNorthComponent != null) {
            PopupChooserBuilder.addNorthComponentToContentPane(contentPane, this.myNorthComponent);
        }
        if (this.mySouthComponent != null) {
            PopupChooserBuilder.addSouthComponentToContentPane(contentPane, this.mySouthComponent);
        }
        if (this.myEastComponent != null) {
            PopupChooserBuilder.addEastComponentToContentPane(contentPane, this.myEastComponent);
        }
        if (ExperimentalUI.isNewUI()) {
            this.applyInsets(contentComponent);
        }
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder(contentPane, this.myPreferableFocusComponent);
        for (JBPopupListener each : this.myListeners) {
            builder.addListener(each);
        }
        builder.setDimensionServiceKey(null, this.myDimensionServiceKey, this.myUseForXYLocation).setRequestFocus(this.myRequestFocus).setResizable(this.myForceResizable).setMovable(this.myForceMovable).setTitle(this.myTitle).setAlpha(this.myAlpha).setFocusOwners(this.myFocusOwners).setCancelKeyEnabled(this.myCancelKeyEnabled).setAdText(this.myAd, this.myAdAlignment).setAdvertiser(this.myAdvertiser).setKeyboardActions(this.myKeyboardActions).setMayBeParent(this.myMayBeParent).setLocateWithinScreenBounds(true).setCancelOnOtherWindowOpen(this.myCancelOnOtherWindowOpen).setModalContext(this.myModalContext).setCancelOnWindowDeactivation(this.myCancelOnWindowDeactivation).setCancelOnClickOutside(this.myCancelOnClickOutside).setCouldPin(this.myCouldPin).setOkHandler(this.myItemChosenRunnable);
        if (this.myCancelCallback != null) {
            builder.setCancelCallback(this.myCancelCallback);
        }
        if ((keyEventHandler = this.myChooserComponent.getKeyEventHandler()) != null) {
            builder.setKeyEventHandler((BooleanFunction<? super KeyEvent>)((BooleanFunction)keyEventHandler::test));
        }
        if (this.myCommandButton != null) {
            builder.setCommandButton(this.myCommandButton);
        }
        if (this.myMinSize != null) {
            builder.setMinSize(this.myMinSize);
        }
        if (this.mySettingsButtons != null) {
            builder.setSettingButtons(this.mySettingsButtons);
        }
        JBPopup jBPopup = this.myPopup = builder.createPopup();
        if (jBPopup == null) {
            PopupChooserBuilder.$$$reportNull$$$0(13);
        }
        return jBPopup;
    }

    private static void addEastComponentToContentPane(JPanel contentPane, JComponent component) {
        contentPane.add((Component)component, "East");
    }

    private static void addNorthComponentToContentPane(JPanel contentPane, JComponent component) {
        contentPane.add((Component)component, "North");
    }

    private static void addSouthComponentToContentPane(JPanel contentPane, JComponent component) {
        contentPane.add((Component)component, "South");
    }

    protected void addCenterComponentToContentPane(JPanel contentPane, JComponent component) {
        contentPane.add((Component)component, "Center");
    }

    @Override
    public PopupChooserBuilder<T> setMinSize(Dimension dimension) {
        this.myMinSize = dimension;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> registerKeyboardAction(KeyStroke keyStroke, ActionListener actionListener) {
        this.myKeyboardActions.add((Pair<ActionListener, KeyStroke>)Pair.create((Object)actionListener, (Object)keyStroke));
        return this;
    }

    private void registerClosePopupKeyboardAction(KeyStroke keyStroke, final boolean shouldPerformAction) {
        this.registerPopupKeyboardAction(keyStroke, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!shouldPerformAction && PopupChooserBuilder.this.myChooserComponent.checkResetFilter()) {
                    return;
                }
                PopupChooserBuilder.this.closePopup(null, shouldPerformAction);
            }
        });
    }

    private void registerPopupKeyboardAction(KeyStroke keyStroke, AbstractAction action) {
        this.myChooserComponent.getComponent().registerKeyboardAction(action, keyStroke, 1);
    }

    private void closePopup(MouseEvent e, boolean isOk) {
        if (isOk) {
            this.myPopup.closeOk((InputEvent)e);
        } else {
            this.myPopup.cancel((InputEvent)e);
        }
    }

    @Override
    public PopupChooserBuilder<T> setAutoSelectIfEmpty(boolean autoSelect) {
        this.myAutoselect = autoSelect;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setCancelKeyEnabled(boolean enabled) {
        this.myCancelKeyEnabled = enabled;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> addListener(JBPopupListener listener2) {
        this.myListeners.add(listener2);
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setSettingButton(Component button2) {
        this.mySettingsButtons = button2;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setMayBeParent(boolean mayBeParent) {
        this.myMayBeParent = mayBeParent;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setCloseOnEnter(boolean closeOnEnter) {
        this.myCloseOnEnter = closeOnEnter;
        return this;
    }

    public PopupChooserBuilder<T> setFocusOwners(Component @NotNull [] focusOwners) {
        if (focusOwners == null) {
            PopupChooserBuilder.$$$reportNull$$$0(14);
        }
        this.myFocusOwners = focusOwners;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setAdText(String ad) {
        this.setAdText(ad, 2);
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setAdvertiser(@Nullable JComponent advertiser) {
        this.myAdvertiser = advertiser;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setAdText(String ad, int alignment) {
        this.myAd = ad;
        this.myAdAlignment = alignment;
        return this;
    }

    @Override
    public PopupChooserBuilder<T> setCancelOnWindowDeactivation(boolean cancelOnWindowDeactivation) {
        this.myCancelOnWindowDeactivation = cancelOnWindowDeactivation;
        return this;
    }

    @Override
    public IPopupChooserBuilder<T> setCancelOnOtherWindowOpen(boolean cancelOnWindow) {
        this.myCancelOnOtherWindowOpen = cancelOnWindow;
        return this;
    }

    @Override
    public IPopupChooserBuilder<T> setSelectionMode(int selection) {
        this.myChooserComponent.setSelectionMode(selection);
        return this;
    }

    @Override
    public IPopupChooserBuilder<T> setSelectedValue(T preselection, boolean shouldScroll) {
        this.myChooserComponent.setSelectedValue(preselection, shouldScroll);
        return this;
    }

    @Override
    public IPopupChooserBuilder<T> setAccessibleName(String title) {
        AccessibleContextUtil.setName((Component)this.myChooserComponent.getComponent(), (String)title);
        return this;
    }

    @Override
    public IPopupChooserBuilder<T> setItemSelectedCallback(Consumer<? super T> c) {
        this.myChooserComponent.setItemSelectedCallback(c);
        return this;
    }

    private void addCancelCallback(Computable<Boolean> cbb) {
        Computable<Boolean> callback = this.myCancelCallback;
        this.myCancelCallback = () -> (Boolean)cbb.compute() != false && (callback == null || (Boolean)callback.compute() != false);
    }

    @Override
    public IPopupChooserBuilder<T> withHintUpdateSupply() {
        HintUpdateSupply.installDataContextHintUpdateSupply(this.myChooserComponent.getComponent());
        this.addCancelCallback((Computable<Boolean>)((Computable)() -> {
            HintUpdateSupply.hideHint(this.myChooserComponent.getComponent());
            return true;
        }));
        return this;
    }

    @Override
    public IPopupChooserBuilder<T> setFont(Font f) {
        this.myChooserComponent.setFont(f);
        return this;
    }

    @Override
    public IPopupChooserBuilder<T> setVisibleRowCount(int visibleRowCount) {
        this.myVisibleRowCount = visibleRowCount;
        return this;
    }

    @Override
    public IPopupChooserBuilder<T> withFixedRendererSize(@NotNull Dimension dimension) {
        if (dimension == null) {
            PopupChooserBuilder.$$$reportNull$$$0(15);
        }
        this.myChooserComponent.setFixedRendererSize(dimension);
        return this;
    }

    public int getVisibleRowCount() {
        return this.myVisibleRowCount;
    }

    @Override
    public GenericListComponentUpdater<T> getBackgroundUpdater() {
        return this.myChooserComponent.getBackgroundUpdater();
    }

    private void applyInsets(JComponent contentComponent) {
        if (contentComponent instanceof ListWithFilter) {
            ListWithFilter listWithFilter = (ListWithFilter)contentComponent;
            Insets insets = PopupUtil.getListInsets(StringUtil.isNotEmpty((String)this.myTitle), StringUtil.isNotEmpty((String)this.myAd));
            listWithFilter.getList().setBorder(new EmptyBorder(insets));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmp";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandButton";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/popup/PopupChooserBuilder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusOwners";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/popup/PopupChooserBuilder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTitle";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setItemChosenCallback";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setItemsChosenCallback";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setItemChoosenCallback";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setNorthComponent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSouthComponent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setContentSplitter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setEastComponent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setCommandButton";
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setFocusOwners";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "withFixedRendererSize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }

    public static interface PopupComponentAdapter<T> {
        public JComponent getComponent();

        default public void setRenderer(ListCellRenderer<? super T> renderer) {
        }

        public void setItemChosenCallback(Consumer<? super T> var1);

        public void setItemsChosenCallback(Consumer<? super Set<T>> var1);

        public JScrollPane createScrollPane();

        default public boolean hasOwnScrollPane() {
            return false;
        }

        default public void addMouseListener(MouseListener listener2) {
            this.getComponent().addMouseListener(listener2);
        }

        default public void autoSelect() {
        }

        default public void setSelectionMode(int selection) {
        }

        default public GenericListComponentUpdater<T> getBackgroundUpdater() {
            return null;
        }

        default public void setSelectedValue(T preselection, boolean shouldScroll) {
            throw new UnsupportedOperationException("Not supported for this popup type");
        }

        default public void setItemSelectedCallback(Consumer<? super T> c) {
            throw new UnsupportedOperationException("Not supported for this popup type");
        }

        default public boolean checkResetFilter() {
            return false;
        }

        @Nullable
        default public Predicate<KeyEvent> getKeyEventHandler() {
            return null;
        }

        default public void setFont(Font f) {
            this.getComponent().setFont(f);
        }

        default public JComponent buildFinalComponent() {
            return this.getComponent();
        }

        default public void setFixedRendererSize(@NotNull Dimension dimension) {
            if (dimension == null) {
                PopupComponentAdapter.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dimension", "com/intellij/openapi/ui/popup/PopupChooserBuilder$PopupComponentAdapter", "setFixedRendererSize"));
        }
    }
}

