/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Key;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneScrolledState;
import com.intellij.ui.ScrollPaneScrolledStateTracker;
import com.intellij.ui.ScrollPaneTracker;
import com.intellij.ui.ScrollableContentBorderKt;
import com.intellij.ui.ScrolledState;
import com.intellij.ui.Side;
import com.intellij.ui.SideBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B'\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u000b\u001a\u00020\fJ8\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ui/ScrollableContentBorder;", "Lcom/intellij/ui/SideBorder;", "sideMask", "", "color", "Ljava/awt/Color;", "thickness", "<init>", "(ILjava/awt/Color;I)V", "setVisible", "", "isVisible", "", "paintBorder", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "width", "height", "Companion", "intellij.platform.ide"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nScrollableContentBorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollableContentBorder.kt\ncom/intellij/ui/ScrollableContentBorder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1#2:209\n*E\n"})
public final class ScrollableContentBorder
extends SideBorder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Color color;
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final Key<Boolean> HEADER_WITH_BORDER_ABOVE;
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final Key<Boolean> TOOL_WINDOW_EDGE_LEFT;
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final Key<Boolean> TOOL_WINDOW_EDGE_RIGHT;
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final Key<Boolean> TOOL_WINDOW_EDGE_BOTTOM;
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final Key<Boolean> TOOLBAR_WITH_BORDER_ABOVE;
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final Key<Boolean> TOOLBAR_WITH_BORDER_LEFT;
    @NotNull
    private static final Key<WeakReference<JComponent>> TARGET_COMPONENT;

    private ScrollableContentBorder(@SideBorder.SideMask int sideMask, Color color, int thickness) {
        super(color, sideMask, thickness);
        this.color = color;
        if (!ScrollableContentBorder.Companion.isOneSideBorder((Border)((Object)this))) {
            boolean bl = false;
            String string = "Only one-side borders are suitable";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /* synthetic */ ScrollableContentBorder(int n, Color color, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            Color color2 = JBColor.border();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"border(...)");
            color = color2;
        }
        if ((n3 & 4) != 0) {
            n2 = 1;
        }
        this(n, color, n2);
    }

    public final void setVisible(boolean isVisible) {
        Color color;
        this.lineColor = color = isVisible ? this.color : UIUtil.TRANSPARENT_COLOR;
    }

    public final boolean isVisible() {
        return !Intrinsics.areEqual((Object)this.lineColor, (Object)UIUtil.TRANSPARENT_COLOR);
    }

    public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
        boolean alreadyHasBorder;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        switch (this.mySideMask) {
            case 2: {
                boolean bl;
                if (ClientProperty.isTrue((Component)c, HEADER_WITH_BORDER_ABOVE) || ClientProperty.isTrue((Component)c, TOOLBAR_WITH_BORDER_ABOVE)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                boolean bl;
                if (ClientProperty.isTrue((Component)c, TOOLBAR_WITH_BORDER_LEFT) || ClientProperty.isTrue((Component)c, TOOL_WINDOW_EDGE_LEFT)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                boolean bl = ClientProperty.isTrue((Component)c, TOOL_WINDOW_EDGE_RIGHT);
                break;
            }
            case 8: {
                boolean bl = ClientProperty.isTrue((Component)c, TOOL_WINDOW_EDGE_BOTTOM);
                break;
            }
            default: {
                boolean bl = alreadyHasBorder = false;
            }
        }
        if (!alreadyHasBorder) {
            super.paintBorder(c, g, x, y, width, height);
        }
    }

    @JvmStatic
    @JvmOverloads
    public static final void setup(@NotNull JScrollPane scrollPane2, @NotNull Side side, @NotNull JComponent targetComponent) {
        Companion.setup(scrollPane2, side, targetComponent);
    }

    @JvmStatic
    @JvmOverloads
    public static final void setup(@NotNull JScrollPane scrollPane2, @NotNull Set<? extends Side> sides, @NotNull JComponent targetComponent) {
        Companion.setup(scrollPane2, sides, targetComponent);
    }

    @JvmStatic
    public static final void setup(@NotNull JComponent container, @NotNull Side side) {
        Companion.setup(container, side);
    }

    @JvmStatic
    public static final void setup(@NotNull JComponent container, @NotNull Set<? extends Side> sides) {
        Companion.setup(container, sides);
    }

    @JvmStatic
    @Nullable
    public static final JComponent getTargetComponent(@NotNull JScrollPane scrollPane2) {
        return Companion.getTargetComponent(scrollPane2);
    }

    @JvmStatic
    @JvmOverloads
    public static final void setup(@NotNull JScrollPane scrollPane2, @NotNull Side side) {
        Companion.setup(scrollPane2, side);
    }

    @JvmStatic
    @JvmOverloads
    public static final void setup(@NotNull JScrollPane scrollPane2, @NotNull Set<? extends Side> sides) {
        Companion.setup(scrollPane2, sides);
    }

    static {
        Key key = Key.create((String)"HEADER_WITH_BORDER_ABOVE");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        HEADER_WITH_BORDER_ABOVE = key;
        Key key2 = Key.create((String)"TOOL_WINDOW_EDGE_LEFT");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        TOOL_WINDOW_EDGE_LEFT = key2;
        Key key3 = Key.create((String)"TOOL_WINDOW_EDGE_RIGHT");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
        TOOL_WINDOW_EDGE_RIGHT = key3;
        Key key4 = Key.create((String)"TOOL_WINDOW_EDGE_BOTTOM");
        Intrinsics.checkNotNullExpressionValue((Object)key4, (String)"create(...)");
        TOOL_WINDOW_EDGE_BOTTOM = key4;
        Key key5 = Key.create((String)"TOOLBAR_WITH_BORDER_ABOVE");
        Intrinsics.checkNotNullExpressionValue((Object)key5, (String)"create(...)");
        TOOLBAR_WITH_BORDER_ABOVE = key5;
        Key key6 = Key.create((String)"TOOLBAR_WITH_BORDER_LEFT");
        Intrinsics.checkNotNullExpressionValue((Object)key6, (String)"create(...)");
        TOOLBAR_WITH_BORDER_LEFT = key6;
        Key key7 = Key.create((String)"ScrollableContentBorder.TARGET_COMPONENT");
        Intrinsics.checkNotNullExpressionValue((Object)key7, (String)"create(...)");
        TARGET_COMPONENT = key7;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u000eH\u0007J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\b\b\u0002\u0010\u0015\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0007J*\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0002J,\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000e2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010 \u001a\u00020\u0006*\u00020\u001f2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00060\"H\u0002J\u0018\u0010$\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010%\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010&\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010'\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/ui/ScrollableContentBorder$Companion;", "", "<init>", "()V", "HEADER_WITH_BORDER_ABOVE", "Lcom/intellij/openapi/util/Key;", "", "TOOL_WINDOW_EDGE_LEFT", "TOOL_WINDOW_EDGE_RIGHT", "TOOL_WINDOW_EDGE_BOTTOM", "TOOLBAR_WITH_BORDER_ABOVE", "TOOLBAR_WITH_BORDER_LEFT", "TARGET_COMPONENT", "Ljava/lang/ref/WeakReference;", "Ljavax/swing/JComponent;", "setup", "", "scrollPane", "Ljavax/swing/JScrollPane;", "side", "Lcom/intellij/ui/Side;", "targetComponent", "sides", "", "container", "installBorders", "", "Lcom/intellij/ui/ScrollableContentBorder;", "updateScrollPaneStates", "borders", "tracker", "Lcom/intellij/ui/ScrollPaneTracker;", "noneMatch", "predicate", "Lkotlin/Function1;", "Lcom/intellij/ui/ScrollPaneScrolledState;", "atLeft", "atRight", "atTop", "atBottom", "isOneSideBorder", "sideBorder", "Ljavax/swing/border/Border;", "getTargetComponent", "intellij.platform.ide"})
    @SourceDebugExtension(value={"SMAP\nScrollableContentBorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollableContentBorder.kt\ncom/intellij/ui/ScrollableContentBorder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1285#2,2:209\n1299#2,4:211\n2746#2,3:217\n37#3,2:215\n1#4:220\n*S KotlinDebug\n*F\n+ 1 ScrollableContentBorder.kt\ncom/intellij/ui/ScrollableContentBorder$Companion\n*L\n115#1:209,2\n115#1:211,4\n138#1:217,3\n116#1:215,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public final void setup(@NotNull JScrollPane scrollPane2, @NotNull Side side, @NotNull JComponent targetComponent) {
            Intrinsics.checkNotNullParameter((Object)scrollPane2, (String)"scrollPane");
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            Intrinsics.checkNotNullParameter((Object)targetComponent, (String)"targetComponent");
            this.setup(scrollPane2, SetsKt.setOf((Object)((Object)side)), targetComponent);
        }

        public static /* synthetic */ void setup$default(Companion companion, JScrollPane jScrollPane, Side side, JComponent jComponent, int n, Object object) {
            if ((n & 4) != 0) {
                jComponent = jScrollPane;
            }
            companion.setup(jScrollPane, side, jComponent);
        }

        @JvmStatic
        @JvmOverloads
        public final void setup(@NotNull JScrollPane scrollPane2, @NotNull Set<? extends Side> sides, @NotNull JComponent targetComponent) {
            Intrinsics.checkNotNullParameter((Object)scrollPane2, (String)"scrollPane");
            Intrinsics.checkNotNullParameter(sides, (String)"sides");
            Intrinsics.checkNotNullParameter((Object)targetComponent, (String)"targetComponent");
            ClientProperty.put((JComponent)scrollPane2, (Key)TARGET_COMPONENT, new WeakReference<JComponent>(targetComponent));
            Map<Side, ScrollableContentBorder> borders = this.installBorders(targetComponent, sides);
            ScrollPaneScrolledStateTracker tracker = new ScrollPaneScrolledStateTracker(scrollPane2, (Function1<? super ScrollPaneScrolledState, Unit>)((Function1)arg_0 -> Companion.setup$lambda$0(targetComponent, borders, arg_0)));
            targetComponent.addPropertyChangeListener("border", new PropertyChangeListener(targetComponent, tracker, scrollPane2){
                final /* synthetic */ JComponent $targetComponent;
                final /* synthetic */ ScrollPaneScrolledStateTracker $tracker;
                final /* synthetic */ JScrollPane $scrollPane;
                {
                    this.$targetComponent = $targetComponent;
                    this.$tracker = $tracker;
                    this.$scrollPane = $scrollPane;
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    this.$targetComponent.removePropertyChangeListener("border", this);
                    this.$tracker.detach();
                    ClientProperty.put((JComponent)this.$scrollPane, (Key)ScrollableContentBorder.access$getTARGET_COMPONENT$cp(), null);
                }
            });
        }

        public static /* synthetic */ void setup$default(Companion companion, JScrollPane jScrollPane, Set set, JComponent jComponent, int n, Object object) {
            if ((n & 4) != 0) {
                jComponent = jScrollPane;
            }
            companion.setup(jScrollPane, set, jComponent);
        }

        @JvmStatic
        public final void setup(@NotNull JComponent container, @NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            this.setup(container, (Set<? extends Side>)SetsKt.setOf((Object)((Object)side)));
        }

        @JvmStatic
        public final void setup(@NotNull JComponent container, @NotNull Set<? extends Side> sides) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            Intrinsics.checkNotNullParameter(sides, (String)"sides");
            Map<Side, ScrollableContentBorder> borders = this.installBorders(container, sides);
            new ScrollPaneTracker(container, (Function1<? super JScrollPane, Boolean>)((Function1)Companion::setup$lambda$1), (Function1<? super ScrollPaneTracker, Unit>)((Function1)arg_0 -> Companion.setup$lambda$2(container, borders, arg_0)));
        }

        /*
         * WARNING - void declaration
         */
        private final Map<Side, ScrollableContentBorder> installBorders(JComponent targetComponent, Set<? extends Side> sides) {
            Border border;
            void $this$associateWithTo$iv$iv;
            Iterable $this$associateWith$iv = sides;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable iterable = $this$associateWith$iv;
            Map destination$iv$iv = result$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void side;
                Side side2 = (Side)((Object)element$iv$iv);
                Object t = element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                ScrollableContentBorder scrollableContentBorder = new ScrollableContentBorder(ScrollableContentBorderKt.access$toMask((Side)side), null, 0, 6, null);
                map.put(t, scrollableContentBorder);
            }
            Map borders = destination$iv$iv;
            if (borders.size() == 1) {
                border = (Border)CollectionsKt.single((Iterable)borders.values());
            } else {
                Collection $this$toTypedArray$iv = borders.values();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                ScrollableContentBorder[] scrollableContentBorderArray = thisCollection$iv.toArray(new ScrollableContentBorder[0]);
                border = JBUI.Borders.compound((Border[])((Border[])Arrays.copyOf(scrollableContentBorderArray, scrollableContentBorderArray.length)));
            }
            targetComponent.setBorder(border);
            return borders;
        }

        private final void updateScrollPaneStates(JComponent container, Map<Side, ScrollableContentBorder> borders, ScrollPaneTracker tracker) {
            for (ScrollPaneScrolledState scrollPaneState : tracker.getScrollPaneStates()) {
                ClientProperty.put((JComponent)scrollPaneState.getScrollPane(), (Key)TARGET_COMPONENT, new WeakReference<JComponent>(container));
            }
            ScrolledState state = new ScrolledState(this.noneMatch(tracker, (Function1<? super ScrollPaneScrolledState, Boolean>)((Function1)arg_0 -> Companion.updateScrollPaneStates$lambda$0(container, arg_0))), this.noneMatch(tracker, (Function1<? super ScrollPaneScrolledState, Boolean>)((Function1)arg_0 -> Companion.updateScrollPaneStates$lambda$1(container, arg_0))), this.noneMatch(tracker, (Function1<? super ScrollPaneScrolledState, Boolean>)((Function1)arg_0 -> Companion.updateScrollPaneStates$lambda$2(container, arg_0))), this.noneMatch(tracker, (Function1<? super ScrollPaneScrolledState, Boolean>)((Function1)arg_0 -> Companion.updateScrollPaneStates$lambda$3(container, arg_0))));
            ScrollableContentBorderKt.access$updateBorderVisibility(container, borders, state);
        }

        private final boolean noneMatch(ScrollPaneTracker $this$noneMatch, Function1<? super ScrollPaneScrolledState, Boolean> predicate2) {
            boolean bl;
            block3: {
                Iterable $this$none$iv = $this$noneMatch.getScrollPaneStates();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ScrollPaneScrolledState it = (ScrollPaneScrolledState)element$iv;
                        boolean bl2 = false;
                        if (!(it.getScrollPane().isShowing() && (Boolean)predicate2.invoke((Object)it) != false)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        private final boolean atLeft(JComponent container, JScrollPane scrollPane2) {
            return SwingUtilities.convertPoint((Component)((Component)scrollPane2.getParent()), (Point)scrollPane2.getLocation(), (Component)((Component)container)).x == container.getInsets().left;
        }

        private final boolean atRight(JComponent container, JScrollPane scrollPane2) {
            Rectangle it = SwingUtilities.convertRectangle(scrollPane2.getParent(), scrollPane2.getBounds(), container);
            boolean bl = false;
            return it.x + it.width == container.getWidth() - container.getInsets().right;
        }

        private final boolean atTop(JComponent container, JScrollPane scrollPane2) {
            return SwingUtilities.convertPoint((Component)((Component)scrollPane2.getParent()), (Point)scrollPane2.getLocation(), (Component)((Component)container)).y == container.getInsets().top;
        }

        private final boolean atBottom(JComponent container, JScrollPane scrollPane2) {
            Rectangle it = SwingUtilities.convertRectangle(scrollPane2.getParent(), scrollPane2.getBounds(), container);
            boolean bl = false;
            return it.y + it.height == container.getHeight() - container.getInsets().bottom;
        }

        private final boolean isOneSideBorder(Border sideBorder) {
            if (!(sideBorder instanceof SideBorder)) {
                return false;
            }
            Insets $this$isOneSideBorder_u24lambda_u240 = ((SideBorder)sideBorder).getBorderInsets(null);
            boolean bl = false;
            Object[] objectArray = new Integer[]{$this$isOneSideBorder_u24lambda_u240.top, $this$isOneSideBorder_u24lambda_u240.bottom, $this$isOneSideBorder_u24lambda_u240.right, $this$isOneSideBorder_u24lambda_u240.left};
            return SequencesKt.count((Sequence)SequencesKt.filter((Sequence)SequencesKt.sequenceOf((Object[])objectArray), Companion::isOneSideBorder$lambda$0$0)) == 1;
        }

        @JvmStatic
        @Nullable
        public final JComponent getTargetComponent(@NotNull JScrollPane scrollPane2) {
            Intrinsics.checkNotNullParameter((Object)scrollPane2, (String)"scrollPane");
            WeakReference weakReference = (WeakReference)ClientProperty.get((Component)scrollPane2, (Key)TARGET_COMPONENT);
            return weakReference != null ? (JComponent)weakReference.get() : null;
        }

        @JvmStatic
        @JvmOverloads
        public final void setup(@NotNull JScrollPane scrollPane2, @NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)scrollPane2, (String)"scrollPane");
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            com.intellij.ui.ScrollableContentBorder$Companion.setup$default(this, scrollPane2, side, null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void setup(@NotNull JScrollPane scrollPane2, @NotNull Set<? extends Side> sides) {
            Intrinsics.checkNotNullParameter((Object)scrollPane2, (String)"scrollPane");
            Intrinsics.checkNotNullParameter(sides, (String)"sides");
            com.intellij.ui.ScrollableContentBorder$Companion.setup$default(this, scrollPane2, sides, null, 4, null);
        }

        private static final Unit setup$lambda$0(JComponent $targetComponent, Map $borders, ScrollPaneScrolledState scrollPaneState) {
            Intrinsics.checkNotNullParameter((Object)scrollPaneState, (String)"scrollPaneState");
            ScrollableContentBorderKt.access$updateBorderVisibility($targetComponent, $borders, scrollPaneState.getState());
            return Unit.INSTANCE;
        }

        private static final boolean setup$lambda$1(JScrollPane it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return true;
        }

        private static final Unit setup$lambda$2(JComponent $container, Map $borders, ScrollPaneTracker tracker) {
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            Companion.updateScrollPaneStates($container, $borders, tracker);
            return Unit.INSTANCE;
        }

        private static final boolean updateScrollPaneStates$lambda$0(JComponent $container, ScrollPaneScrolledState it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.atLeft($container, it.getScrollPane()) && !it.getState().isHorizontalAtStart();
        }

        private static final boolean updateScrollPaneStates$lambda$1(JComponent $container, ScrollPaneScrolledState it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.atRight($container, it.getScrollPane()) && !it.getState().isHorizontalAtEnd();
        }

        private static final boolean updateScrollPaneStates$lambda$2(JComponent $container, ScrollPaneScrolledState it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.atTop($container, it.getScrollPane()) && !it.getState().isVerticalAtStart();
        }

        private static final boolean updateScrollPaneStates$lambda$3(JComponent $container, ScrollPaneScrolledState it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.atBottom($container, it.getScrollPane()) && !it.getState().isVerticalAtEnd();
        }

        private static final boolean isOneSideBorder$lambda$0$0(int it) {
            return it != 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

