/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.config;

import com.intellij.util.config.AbstractProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public final class ListProperty<T>
extends AbstractProperty<List<T>> {
    private final String myName;

    public ListProperty(@NonNls String name) {
        this.myName = name;
    }

    public static <T> ListProperty<T> create(@NonNls String name) {
        return new ListProperty<T>(name);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public List<T> getDefault(AbstractProperty.AbstractPropertyContainer container) {
        return Collections.emptyList();
    }

    @Override
    public List<T> copy(List<T> value2) {
        return Collections.unmodifiableList(value2);
    }

    public ArrayList<T> getModifiableList(AbstractProperty.AbstractPropertyContainer container) {
        ArrayList modifiableList;
        List list = (List)this.get(container);
        if (list instanceof ArrayList) {
            modifiableList = (ArrayList)list;
        } else {
            modifiableList = new ArrayList(list);
            this.set(container, modifiableList);
        }
        for (int i = modifiableList.size() - 1; i >= 0; --i) {
            if (modifiableList.get(i) != null) continue;
            modifiableList.remove(i);
        }
        return modifiableList;
    }

    public Iterator<T> getIterator(AbstractProperty.AbstractPropertyContainer container) {
        return ((List)this.get(container)).iterator();
    }
}

