/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.Prefs;
import com.intellij.ide.Region;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public final class RegionSettings {
    private static final String REGION_CODE_KEY = "JetBrains.region.code";

    private RegionSettings() {
    }

    @ApiStatus.Internal
    public static void setRegion(@NotNull Region region) {
        if (region == null) {
            RegionSettings.$$$reportNull$$$0(0);
        }
        if (region == Region.NOT_SET) {
            RegionSettings.resetCode();
        } else {
            Prefs.put(REGION_CODE_KEY, region.externalName());
            RegionSettings.fireEvent();
        }
    }

    @NotNull
    public static Region getRegion() {
        String name = Prefs.get(REGION_CODE_KEY, Region.NOT_SET.externalName());
        Region region = Region.fromExternalName(name);
        if (region == null) {
            RegionSettings.$$$reportNull$$$0(1);
        }
        return region;
    }

    @ApiStatus.Internal
    public static void resetCode() {
        Prefs.remove(REGION_CODE_KEY);
        RegionSettings.fireEvent();
    }

    private static void fireEvent() {
        ((RegionSettingsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(RegionSettingsListener.UPDATE_TOPIC)).regionChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/RegionSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/RegionSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setRegion";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    public static interface RegionSettingsListener {
        @Topic.AppLevel
        public static final Topic<RegionSettingsListener> UPDATE_TOPIC = new Topic(RegionSettingsListener.class, Topic.BroadcastDirection.NONE, true);

        public void regionChanged();
    }
}

